/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test.audit;

import com.atlassian.bitbucket.test.audit.AffectedObject;
import com.atlassian.bitbucket.test.audit.Attribute;
import com.atlassian.bitbucket.test.audit.ChangedValue;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Objects;

class AuditTestUtils {
    private AuditTestUtils() {
        throw new UnsupportedOperationException(this.getClass().getName() + " is a utility class and should not be instantiated");
    }

    static AffectedObject buildAffectedObject(Map<String, String> rawAffectedObject) {
        return AuditTestUtils.buildAffectedObject(rawAffectedObject.get("name"), rawAffectedObject.getOrDefault("type", ""));
    }

    private static AffectedObject buildAffectedObject(final String name, final String type) {
        return new AffectedObject(){

            @Override
            public Class<? extends Annotation> annotationType() {
                return AffectedObject.class;
            }

            @Override
            public String name() {
                return name;
            }

            @Override
            public String type() {
                return type;
            }

            @Override
            public String toString() {
                return "{name: " + name + ", type: " + type + "}";
            }

            @Override
            public int hashCode() {
                return Objects.hash(name, type);
            }

            @Override
            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null || !AffectedObject.class.isAssignableFrom(obj.getClass())) {
                    return false;
                }
                AffectedObject other = (AffectedObject)obj;
                return Objects.equals(this.name(), other.name()) && Objects.equals(this.type(), other.type());
            }
        };
    }

    static Attribute buildAttribute(Map<String, String> rawAttribute) {
        return AuditTestUtils.buildAttribute(rawAttribute.get("name"), rawAttribute.getOrDefault("value", ""));
    }

    static Attribute buildAttribute(final String name, final String value) {
        return new Attribute(){

            @Override
            public Class<? extends Annotation> annotationType() {
                return Attribute.class;
            }

            @Override
            public String name() {
                return name;
            }

            @Override
            public String value() {
                return value;
            }

            @Override
            public String toString() {
                return "{name: " + name + ", value: " + value + "}";
            }

            @Override
            public int hashCode() {
                return Objects.hash(name, value);
            }

            @Override
            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null || !Attribute.class.isAssignableFrom(obj.getClass())) {
                    return false;
                }
                Attribute other = (Attribute)obj;
                return Objects.equals(this.name(), other.name()) && Objects.equals(this.value(), other.value());
            }
        };
    }

    static ChangedValue buildChangedValue(Map<String, String> rawChangedValue) {
        return AuditTestUtils.buildChangedValue(rawChangedValue.get("key"), rawChangedValue.getOrDefault("from", ""), rawChangedValue.getOrDefault("to", ""));
    }

    static ChangedValue buildChangedValue(final String key, final String from, final String to) {
        return new ChangedValue(){

            @Override
            public Class<? extends Annotation> annotationType() {
                return ChangedValue.class;
            }

            @Override
            public String from() {
                return from;
            }

            @Override
            public String key() {
                return key;
            }

            @Override
            public String to() {
                return to;
            }

            @Override
            public String toString() {
                return "{key: " + this.key() + ", from: " + this.from() + ", to: " + this.to() + "}";
            }

            @Override
            public int hashCode() {
                return Objects.hash(key, from, to);
            }

            @Override
            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null || !ChangedValue.class.isAssignableFrom(obj.getClass())) {
                    return false;
                }
                ChangedValue other = (ChangedValue)obj;
                return Objects.equals(this.key(), other.key()) && Objects.equals(this.from(), other.from()) && Objects.equals(this.to(), other.to());
            }
        };
    }
}

