/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test;

import com.atlassian.bitbucket.test.ProcessResult;
import com.atlassian.bitbucket.test.StringProcessHandler;

public class ProcessFailedException
extends RuntimeException
implements ProcessResult {
    private final String stdErr;
    private final String output;
    private final int exitCode;

    public ProcessFailedException(StringProcessHandler handler) {
        super(ProcessFailedException.buildMessage(handler));
        this.stdErr = handler.getError();
        this.output = handler.getOutput();
        this.exitCode = handler.getExitCode();
    }

    private static String buildMessage(StringProcessHandler handler) {
        return handler.getCommandLine() + " failed (" + handler.getExitCode() + ") out:" + handler.getOutput() + ": err:" + handler.getError() + ":";
    }

    @Override
    public String getStdErr() {
        return this.stdErr;
    }

    @Override
    public String getStdOut() {
        return this.output;
    }

    @Override
    public int getExitCode() {
        return this.exitCode;
    }
}

