/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test.rest.jiracloud.stubs;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.matching.ContentPattern;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import com.github.tomakehurst.wiremock.matching.UrlPattern;

public class AccessTokenStub {
    private static final String RESPONSE = "{\n    \"access_token\": \"%s\",\n    \"scope\": \"manage:jira-data-provider\",\n    \"expires_in\": %d,\n    \"token_type\": \"Bearer\"\n}";
    private final WireMockServer wiremock;
    private String accessToken = "<access-token>";
    private String clientId = "clientId";
    private String clientSecret = "clientSecret";
    private int expiry = 3600;

    private AccessTokenStub(WireMockServer wiremock) {
        this.wiremock = wiremock;
    }

    public static AccessTokenStub aStub(WireMockServer wiremock) {
        return new AccessTokenStub(wiremock);
    }

    public AccessTokenStub forOauth(String clientId, String clientSecret) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        return this;
    }

    public void shouldReturn(String accessToken) {
        this.accessToken = accessToken;
        this.build();
    }

    private void build() {
        this.wiremock.stubFor(WireMock.post((UrlPattern)WireMock.urlEqualTo((String)"/oauth/token")).withRequestBody((ContentPattern)WireMock.matchingJsonPath((String)"$.grant_type", (StringValuePattern)WireMock.equalTo((String)"client_credentials"))).withRequestBody((ContentPattern)WireMock.matchingJsonPath((String)"$.client_id", (StringValuePattern)WireMock.equalTo((String)this.clientId))).withRequestBody((ContentPattern)WireMock.matchingJsonPath((String)"$.client_secret", (StringValuePattern)WireMock.equalTo((String)this.clientSecret))).willReturn(WireMock.aResponse().withBody(String.format(RESPONSE, this.accessToken, this.expiry)).withHeader("Content-Type", new String[]{"application/json"})));
    }
}

