/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test.rest;

import com.atlassian.bitbucket.test.rest.RestAuthentication;
import com.atlassian.bitbucket.test.rest.RestRequest;
import com.atlassian.bitbucket.util.BuilderSupport;
import com.google.common.collect.Maps;
import io.restassured.RestAssured;
import io.restassured.builder.ResponseSpecBuilder;
import io.restassured.specification.ResponseSpecification;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.ws.rs.core.Response;

public abstract class AbstractRestRequest
implements RestRequest {
    private final RestAuthentication authentication;
    private final ResponseSpecification responseSpecification;
    private final Response.Status status;

    protected AbstractRestRequest(AbstractBuilder<?, ?> builder) {
        this.authentication = builder.authentication;
        this.responseSpecification = builder.buildSpecification();
        this.status = builder.status;
    }

    @Nullable
    public RestAuthentication getAuthentication() {
        return this.authentication;
    }

    @Nonnull
    public ResponseSpecification getResponseSpecification() {
        return this.responseSpecification;
    }

    @Override
    @Nonnull
    public Response.Status getStatus() {
        return this.status;
    }

    @Override
    @Nonnull
    public Map<String, Object> toQueryParams() {
        return Maps.newLinkedHashMap();
    }

    protected static abstract class AbstractBuilder<B extends AbstractBuilder<B, R>, R extends AbstractRestRequest>
    extends BuilderSupport {
        private final ResponseSpecification specifications = RestAssured.expect();
        private RestAuthentication authentication;
        private Response.Status status;

        protected AbstractBuilder() {
            this.status = Response.Status.OK;
        }

        protected AbstractBuilder(@Nonnull R request) {
            this.status = ((AbstractRestRequest)Objects.requireNonNull(request, "request")).getStatus();
        }

        @Nonnull
        public B authentication(@Nullable RestAuthentication value) {
            this.authentication = value;
            return this.self();
        }

        @Nonnull
        public abstract R build();

        @Nonnull
        public B specification(@Nullable ResponseSpecification specification) {
            if (specification != null) {
                this.specifications.spec(specification);
            }
            return this.self();
        }

        @Nonnull
        public B status(@Nonnull Response.Status value) {
            this.status = Objects.requireNonNull(value, "status");
            return this.self();
        }

        private ResponseSpecification buildSpecification() {
            return new ResponseSpecBuilder().addResponseSpecification(this.specifications).expectStatusCode(this.status.getStatusCode()).build();
        }

        @Nonnull
        protected abstract B self();
    }
}

