/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test;

import com.atlassian.bitbucket.test.DefaultFuncTestData;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.specification.RequestSpecification;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.junit.rules.ExternalResource;

public class RepositoryHooksTestHelper
extends ExternalResource {
    private final String baseUrl;

    public RepositoryHooksTestHelper(String projectKey) {
        this.baseUrl = DefaultFuncTestData.getRestURL() + "/projects/" + projectKey + "/settings/hooks/";
    }

    public RepositoryHooksTestHelper(String projectKey, String repoSlug) {
        this.baseUrl = DefaultFuncTestData.getRestURL() + "/projects/" + projectKey + "/repos/" + repoSlug + "/settings/hooks/";
    }

    public Map<String, Object> configure(String hookKey, Map<String, Object> settings) {
        return ((Response)RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).contentType("application/json").header("Accept", (Object)"application/json", new Object[0]).body(settings).when().put(this.baseUrl + hookKey + "/settings", new Object[0])).getBody().jsonPath().getMap("");
    }

    public Map<String, Object> disable(String hookKey) {
        return ((Response)RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).contentType("application/json").header("Accept", (Object)"application/json", new Object[0]).when().delete(this.baseUrl + hookKey + "/enabled", new Object[0])).getBody().jsonPath().getMap("");
    }

    public Map<String, Object> enable(String hookKey, Map<String, Object> settings) {
        RequestSpecification specification = RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).contentType("application/json").header("Accept", (Object)"application/json", new Object[0]);
        if (settings != null) {
            specification = specification.body(settings);
        }
        return ((Response)specification.when().put(this.baseUrl + hookKey + "/enabled", new Object[0])).getBody().jsonPath().getMap("");
    }

    public Map<String, Object> enable(String hookKey) {
        return this.enable(hookKey, null);
    }

    public Map<String, Object> get(String hookKey) {
        return ((Response)RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).contentType("application/json").header("Accept", (Object)"application/json", new Object[0]).when().get(this.baseUrl + hookKey, new Object[0])).getBody().jsonPath().getMap("");
    }

    public Map<String, Object> getSettings(String hookKey) {
        return ((Response)RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).contentType("application/json").header("Accept", (Object)"application/json", new Object[0]).when().get(this.baseUrl + hookKey + "/settings", new Object[0])).getBody().jsonPath().getMap("");
    }
}

