/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test;

import com.atlassian.bitbucket.async.AsyncTestUtils;
import com.atlassian.bitbucket.async.WaitCondition;
import com.atlassian.bitbucket.build.BuildState;
import com.atlassian.bitbucket.build.status.RepositoryBuildStatusSetRequest;
import com.atlassian.bitbucket.dmz.build.status.SimpleTestResults;
import com.atlassian.bitbucket.dmz.build.status.legacy.BuildStatusSetRequest;
import com.atlassian.bitbucket.dmz.rest.v2.build.RestBuildStatus;
import com.atlassian.bitbucket.dmz.rest.v2.build.RestBuildStatusSetRequest;
import com.atlassian.bitbucket.hamcrest.IsBlankString;
import com.atlassian.bitbucket.internal.rest.build.status.InternalRestBuildStatus;
import com.atlassian.bitbucket.internal.rest.build.status.RestBuildStatusParent;
import com.atlassian.bitbucket.internal.rest.build.summary.RestBuildSummaries;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.rest.v2.api.RestErrorMessage;
import com.atlassian.bitbucket.rest.v2.api.RestErrors;
import com.atlassian.bitbucket.rest.v2.api.user.RestPerson;
import com.atlassian.bitbucket.test.DefaultFuncTestData;
import com.atlassian.bitbucket.test.TestContext;
import com.google.common.collect.ImmutableMap;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.http.Header;
import io.restassured.response.Response;
import io.restassured.specification.RequestSpecification;
import io.restassured.specification.ResponseSpecification;
import java.security.SecureRandom;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.sf.json.JSONObject;
import org.apache.commons.codec.binary.Hex;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;

public class RepositoryBuildStatusTestHelper {
    public static final Map<BuildState, String> BUILD_STATE_MESSAGE = new HashMap<BuildState, String>(){
        {
            this.put(BuildState.CANCELLED, "Canceled");
            this.put(BuildState.FAILED, "Failed");
            this.put(BuildState.INPROGRESS, "In progress");
            this.put(BuildState.SUCCESSFUL, "Passed");
            this.put(BuildState.UNKNOWN, "Unknown state");
        }
    };
    private static final String BUILD_SERVER_HEADER_NAME = "bbs-test-build-server";
    private static final String SERVER_1_ID = "http://localhost:1234/custom/build/server/1";
    private static final Logger log = LoggerFactory.getLogger(RepositoryBuildStatusTestHelper.class);
    private final String projectKey;
    private final SecureRandom rand = new SecureRandom();
    private final String repoSlug;
    private final String user;

    public RepositoryBuildStatusTestHelper(String projectKey, String repoSlug, String user) {
        this.projectKey = projectKey;
        this.repoSlug = repoSlug;
        this.user = user;
    }

    public static void assertLegacyStatus(RestBuildStatus actualStatus, BuildStatusSetRequest statusRequest) {
        MatcherAssert.assertThat((Object)actualStatus.getKey(), (Matcher)Matchers.equalTo((Object)statusRequest.getKey()));
        MatcherAssert.assertThat((Object)actualStatus.getBuildNumber(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)actualStatus.getDescription(), (Matcher)Matchers.equalTo((Object)statusRequest.getDescription()));
        MatcherAssert.assertThat((Object)actualStatus.getDuration(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)actualStatus.getName(), (Matcher)Matchers.equalTo((Object)statusRequest.getName()));
        MatcherAssert.assertThat((Object)actualStatus.getParent(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)actualStatus.getRef(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)actualStatus.getState(), (Matcher)Matchers.equalTo((Object)statusRequest.getState()));
        MatcherAssert.assertThat((Object)actualStatus.getTestResults(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)actualStatus.getUrl(), (Matcher)Matchers.equalTo((Object)statusRequest.getUrl()));
    }

    public static void assertExtendedStatus(InternalRestBuildStatus actualStatus, RestBuildStatusSetRequest statusRequest, String commitId, String key) {
        RepositoryBuildStatusTestHelper.assertExtendedStatus(actualStatus, statusRequest, false, commitId, key, SERVER_1_ID, false);
    }

    public static void assertExtendedStatus(InternalRestBuildStatus actualStatus, RestBuildStatusSetRequest statusRequest, boolean actionsEnabled, String commitId, String key, String buildServerId, boolean hasAvatar) {
        RepositoryBuildStatusTestHelper.assertStatus((RestBuildStatus)actualStatus, statusRequest, commitId, key, hasAvatar);
        MatcherAssert.assertThat((Object)actualStatus.isActionsEnabled(), (Matcher)Matchers.equalTo((Object)actionsEnabled));
        if (buildServerId != null) {
            MatcherAssert.assertThat((Object)actualStatus.getBuildServer().getBuildServerId(), (Matcher)Matchers.equalTo((Object)buildServerId));
        } else {
            MatcherAssert.assertThat((Object)actualStatus.getBuildServer(), (Matcher)Matchers.nullValue());
        }
    }

    public static void assertExtendedStatusWithAvatar(InternalRestBuildStatus actualStatus, RestBuildStatusSetRequest statusRequest, String commitId, String key) {
        RepositoryBuildStatusTestHelper.assertExtendedStatus(actualStatus, statusRequest, false, commitId, key, SERVER_1_ID, true);
    }

    public static void assertStatus(RestBuildStatus actualStatus, RestBuildStatusSetRequest statusRequest, String commitId, String key) {
        RepositoryBuildStatusTestHelper.assertStatus(actualStatus, statusRequest, commitId, key, true);
    }

    public static void assertStatus(RestBuildStatus actualStatus, RestBuildStatusSetRequest statusRequest, String commitId, String key, boolean hasAvatar) {
        MatcherAssert.assertThat((Object)actualStatus.getKey(), (Matcher)Matchers.equalTo((Object)key));
        MatcherAssert.assertThat((Object)actualStatus.getBuildNumber(), (Matcher)Matchers.equalTo((Object)statusRequest.getBuildNumber()));
        MatcherAssert.assertThat((Object)actualStatus.getDescription(), (Matcher)Matchers.equalTo((Object)statusRequest.getDescription()));
        MatcherAssert.assertThat((Object)actualStatus.getDuration(), (Matcher)Matchers.equalTo((Object)statusRequest.getDuration()));
        MatcherAssert.assertThat((Object)actualStatus.getName(), (Matcher)Matchers.equalTo((Object)statusRequest.getName()));
        MatcherAssert.assertThat((Object)actualStatus.getParent(), (Matcher)Matchers.equalTo((Object)statusRequest.getParent()));
        MatcherAssert.assertThat((Object)actualStatus.getRef(), (Matcher)Matchers.equalTo((Object)statusRequest.getRef()));
        MatcherAssert.assertThat((Object)actualStatus.getState(), (Matcher)Matchers.equalTo((Object)statusRequest.getState()));
        MatcherAssert.assertThat((Object)actualStatus.getTestResults(), (Matcher)Matchers.equalTo((Object)statusRequest.getTestResults()));
        MatcherAssert.assertThat((Object)actualStatus.getUrl(), (Matcher)Matchers.equalTo((Object)statusRequest.getUrl()));
        if (commitId != null) {
            Map commit = (Map)actualStatus.get((Object)"commit");
            MatcherAssert.assertThat(commit.get("id"), (Matcher)Matchers.equalTo((Object)commitId));
            MatcherAssert.assertThat((Object)((String)commit.get("message")), (Matcher)IsBlankString.notBlank());
            RestPerson author = new RestPerson((Map)commit.get("author"));
            MatcherAssert.assertThat((Object)author, (Matcher)Matchers.hasKey((Object)"name"));
            MatcherAssert.assertThat((Object)author, (Matcher)Matchers.hasKey((Object)"emailAddress"));
            if (hasAvatar) {
                MatcherAssert.assertThat((Object)author, (Matcher)Matchers.hasKey((Object)"avatarUrl"));
            }
        }
    }

    public static void assertParents(List<RestBuildStatusParent> actual, String ... expectedParents) {
        List actualParents = actual.stream().map(RestBuildStatusParent::getParent).collect(Collectors.toList());
        Assert.assertTrue((boolean)actualParents.containsAll(Arrays.asList(expectedParents)));
        List actualNames = actual.stream().map(RestBuildStatusParent::getExampleName).collect(Collectors.toList());
        Assert.assertTrue((boolean)actualNames.containsAll(Arrays.stream(expectedParents).map(parent -> parent + " name").collect(Collectors.toList())));
    }

    public static void waitForMigrationToComplete(TestContext testContext) {
        String commitId = "0a943a29376f2336b78312d99e65da17048951db";
        String testSetupProj = "TEST_SETUP";
        String testSetupRepo = "test_setup";
        testContext.project(testSetupProj).repository(testSetupProj, testSetupRepo, (Resource)new ClassPathResource("git/default-repository.zip"));
        new RepositoryBuildStatusTestHelper(testSetupProj, testSetupRepo, DefaultFuncTestData.getAdminUser()).waitForMigrationToComplete(commitId, Duration.ofMinutes(2L));
    }

    public BuildStatusSetRequest createGenericLegacyBuildStatus(String key, String commitId) {
        return this.createGenericLegacyBuildStatus(key, commitId, BuildState.FAILED);
    }

    public BuildStatusSetRequest createGenericLegacyBuildStatus(String key, String commitId, BuildState state) {
        BuildStatusSetRequest request = new BuildStatusSetRequest.Builder(commitId).description("desc").key(key).name("Test build").state(state).url("http://example.com").build();
        JSONObject status = new JSONObject();
        status.put((Object)"description", (Object)request.getDescription());
        status.put((Object)"key", (Object)request.getKey());
        status.put((Object)"name", (Object)request.getName());
        status.put((Object)"state", (Object)request.getState());
        status.put((Object)"url", (Object)request.getUrl());
        RestAssured.given().auth().preemptive().basic(this.user, this.user).body((Object)status).contentType(ContentType.JSON).header("Accept", (Object)ContentType.JSON.getAcceptHeader(), new Object[0]).expect().statusCode(204).when().post(DefaultFuncTestData.getRestURL("build-status", "latest") + "/commits/" + commitId, new Object[0]);
        return request;
    }

    public RestBuildStatusSetRequest createParentfulModernBuildStatus(String parent, String commitId) {
        RepositoryBuildStatusSetRequest request = new RepositoryBuildStatusSetRequest.Builder((Repository)Mockito.mock(Repository.class), "4a12268c3a14dc354f724738852b69b51a5d6298", parent + "-key").buildNumber("123").description("desc").duration(Long.valueOf(67451L)).name(parent + " name").parent(parent).ref("refs/heads/master").state(BuildState.SUCCESSFUL).testResults(new SimpleTestResults.Builder().failed(Integer.valueOf(1)).skipped(Integer.valueOf(2)).successful(Integer.valueOf(3)).build()).url("http://example.com").build();
        RestBuildStatusSetRequest restRequest = new RestBuildStatusSetRequest(request);
        this.set(commitId, restRequest, new Header(BUILD_SERVER_HEADER_NAME, SERVER_1_ID));
        return restRequest;
    }

    public RestBuildStatusSetRequest createGenericModernBuildStatus(String key, String commitId) {
        return this.createGenericModernBuildStatus(key, "refs/heads/master", commitId);
    }

    public RestBuildStatusSetRequest createGenericModernBuildStatus(String key, String ref, String commitId) {
        return this.createGenericModernBuildStatus(key, ref, commitId, BuildState.FAILED);
    }

    public RestBuildStatusSetRequest createGenericModernBuildStatus(String key, String ref, String commitId, BuildState state) {
        return this.createGenericModernBuildStatus(key, ref, commitId, state, new Date());
    }

    public RestBuildStatusSetRequest createGenericModernBuildStatus(String key, String ref, String commitId, BuildState state, Date lastUpdated) {
        RepositoryBuildStatusSetRequest statusRequest = new RepositoryBuildStatusSetRequest.Builder((Repository)Mockito.mock(Repository.class), commitId, key).buildNumber("123").description("desc").duration(Long.valueOf(67451L)).lastUpdated(lastUpdated).name("Test build").parent("build").ref(ref).state(state).testResults(new SimpleTestResults.Builder().failed(Integer.valueOf(1)).skipped(Integer.valueOf(2)).successful(Integer.valueOf(3)).build()).url("http://example.com").build();
        RestBuildStatusSetRequest restRequest = new RestBuildStatusSetRequest(statusRequest);
        this.set(commitId, restRequest, new Header(BUILD_SERVER_HEADER_NAME, SERVER_1_ID));
        return restRequest;
    }

    public Response delete(String commitId, String key) {
        return this.delete(204, commitId, key);
    }

    public Response delete(int expectedStatusCode, String commitId, String key) {
        RequestSpecification request = RestAssured.given();
        if (this.user != null) {
            request.auth().preemptive().basic(this.user, this.user);
        }
        Response response = (Response)((ResponseSpecification)request.contentType(ContentType.JSON).header("Accept", (Object)ContentType.JSON.getAcceptHeader(), new Object[0]).queryParam("key", new Object[]{key}).expect().statusCode(expectedStatusCode).log().ifValidationFails()).when().delete(this.getApiResourceUrl(commitId), new Object[0]);
        return response;
    }

    public RestBuildStatus get(String commitId, String key) {
        return (RestBuildStatus)this.get(200, commitId, key).as(RestBuildStatus.class);
    }

    public Response get(int expectedStatusCode, String commitId, String key) {
        RequestSpecification request = RestAssured.given();
        if (this.user != null) {
            request.auth().preemptive().basic(this.user, this.user);
        }
        Response response = (Response)((ResponseSpecification)request.contentType(ContentType.JSON).header("Accept", (Object)ContentType.JSON.getAcceptHeader(), new Object[0]).queryParam("key", new Object[]{key}).queryParam("avatarSize", new Object[]{32}).expect().statusCode(expectedStatusCode).log().ifValidationFails()).when().get(this.getApiResourceUrl(commitId), new Object[0]);
        return response;
    }

    public InternalRestBuildStatus getExtendedStatus(String commitId, String key) {
        List<InternalRestBuildStatus> results = this.searchRepository((Map<String, String>)ImmutableMap.of((Object)"avatarSize", (Object)"32", (Object)"at", (Object)commitId, (Object)"key", (Object)key));
        if (results.size() != 1) {
            throw new IllegalStateException("There should be exactly 1 build result for a given build key and commit, but found " + results.size());
        }
        return results.get(0);
    }

    public RestBuildSummaries getSummaries(long pullRequestId, Collection<String> commitIds) {
        ImmutableMap queryParams = commitIds.isEmpty() ? Collections.emptyMap() : ImmutableMap.of((Object)"commitId", commitIds);
        return (RestBuildSummaries)((Response)((ResponseSpecification)RestAssured.given().auth().preemptive().basic(this.user, this.user).header("Accept", (Object)ContentType.JSON.getAcceptHeader(), new Object[0]).expect().statusCode(200).log().ifValidationFails()).when().get(this.appendQueryParams(this.getUiResourceUrl() + "/pull-requests/" + pullRequestId + "/build-summaries", (Map<String, Collection<String>>)queryParams), new Object[0])).as(RestBuildSummaries.class);
    }

    public RestBuildSummaries getCommitSummaries(Collection<String> commitIds) {
        ImmutableMap queryParams = commitIds.isEmpty() ? Collections.emptyMap() : ImmutableMap.of((Object)"commitId", commitIds);
        return (RestBuildSummaries)((Response)((ResponseSpecification)RestAssured.given().auth().preemptive().basic(this.user, this.user).header("Accept", (Object)ContentType.JSON.getAcceptHeader(), new Object[0]).expect().statusCode(200).log().ifValidationFails()).when().get(this.appendQueryParams(this.getUiResourceUrl() + "/build-summaries", (Map<String, Collection<String>>)queryParams), new Object[0])).as(RestBuildSummaries.class);
    }

    public RestBuildSummaries getCommitSummaries(Collection<String> commitIds, String refId) {
        ImmutableMap queryParams = commitIds.isEmpty() ? Collections.emptyMap() : ImmutableMap.of((Object)"commitId", commitIds, (Object)"ref", Collections.singletonList(refId));
        return (RestBuildSummaries)((Response)((ResponseSpecification)RestAssured.given().auth().preemptive().basic(this.user, this.user).header("Accept", (Object)ContentType.JSON.getAcceptHeader(), new Object[0]).expect().statusCode(200).log().ifValidationFails()).when().get(this.appendQueryParams(this.getUiResourceUrl() + "/build-summaries", (Map<String, Collection<String>>)queryParams), new Object[0])).as(RestBuildSummaries.class);
    }

    public RestBuildSummaries getPullRequestSummaries(Collection<String> pullRequestIds) {
        ImmutableMap queryParams = pullRequestIds.isEmpty() ? Collections.emptyMap() : ImmutableMap.of((Object)"pullRequestId", pullRequestIds);
        return (RestBuildSummaries)((Response)((ResponseSpecification)RestAssured.given().auth().preemptive().basic(this.user, this.user).header("Accept", (Object)ContentType.JSON.getAcceptHeader(), new Object[0]).expect().statusCode(200).log().ifValidationFails()).when().get(this.appendQueryParams(this.getUiResourceUrl() + "/build-summaries", (Map<String, Collection<String>>)queryParams), new Object[0])).as(RestBuildSummaries.class);
    }

    public RestBuildSummaries getRefSummaries(Collection<String> refIds) {
        ImmutableMap queryParams = refIds.isEmpty() ? Collections.emptyMap() : ImmutableMap.of((Object)"ref", refIds);
        return (RestBuildSummaries)((Response)((ResponseSpecification)RestAssured.given().auth().preemptive().basic(this.user, this.user).header("Accept", (Object)ContentType.JSON.getAcceptHeader(), new Object[0]).expect().statusCode(200).log().ifValidationFails()).when().get(this.appendQueryParams(this.getUiResourceUrl() + "/build-summaries", (Map<String, Collection<String>>)queryParams), new Object[0])).as(RestBuildSummaries.class);
    }

    public String randomCommitId() {
        byte[] randomBytes = new byte[20];
        this.rand.nextBytes(randomBytes);
        return Hex.encodeHexString((byte[])randomBytes);
    }

    public List<InternalRestBuildStatus> searchAt(String at) {
        return this.searchRepository((Map<String, String>)ImmutableMap.of((Object)"avatarSize", (Object)"32", (Object)"at", (Object)at));
    }

    public List<RestBuildStatusParent> searchParent(String filter, Long earliestCreationDate) {
        return this.searchParent((Map<String, Collection<String>>)ImmutableMap.of((Object)"filter", Collections.singleton(filter), (Object)"earliestDate", Collections.singleton(earliestCreationDate.toString())), 200);
    }

    public List<RestBuildStatusParent> searchParent(Map<String, Collection<String>> queryParams, int statusCode) {
        Response response = this.searchRepositoryParents(queryParams, statusCode);
        return ((List)response.path("values", new String[0])).stream().map(RestBuildStatusParent::valueOf).collect(Collectors.toList());
    }

    public List<InternalRestBuildStatus> searchPullRequest(long id) {
        return this.searchPullRequest(id, (Map<String, String>)ImmutableMap.of((Object)"avatarSize", (Object)"32"));
    }

    public List<InternalRestBuildStatus> searchPullRequest(long id, Map<String, String> queryParams) {
        Map<String, Collection<String>> convertedQueryParams = queryParams.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> Collections.singleton((String)entry.getValue())));
        return this.getValues(this.searchPullRequest(id, convertedQueryParams, 200));
    }

    public List<InternalRestBuildStatus> searchPullRequestAndCommit(long id, String commitId) {
        return this.searchPullRequest(id, (Map<String, String>)ImmutableMap.of((Object)"avatarSize", (Object)"32", (Object)"commitId", (Object)commitId));
    }

    public List<InternalRestBuildStatus> searchRepository(Map<String, String> queryParams) {
        Map<String, Collection<String>> convertedQueryParams = queryParams.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> Collections.singleton((String)entry.getValue())));
        return this.getValues(this.searchRepository(convertedQueryParams, 200));
    }

    public void set(String commitId, RestBuildStatusSetRequest setRequest, Header ... extraHeaders) {
        this.set(204, commitId, setRequest, extraHeaders);
    }

    public List<RestErrorMessage> setWithError(int statusCode, String commitId, RestBuildStatusSetRequest setRequest, Header ... extraHeaders) {
        return this.getErrors(this.set(statusCode, commitId, setRequest, extraHeaders));
    }

    public void waitForMigrationToComplete(final String commitId, Duration maxWaitTime) {
        String key = "test-setup";
        RepositoryBuildStatusSetRequest request = new RepositoryBuildStatusSetRequest.Builder((Repository)Mockito.mock(Repository.class), commitId, key).buildNumber("123").description("desc").duration(Long.valueOf(67451L)).name("Test build").parent("build").ref("refs/heads/master").state(BuildState.FAILED).testResults(new SimpleTestResults.Builder().failed(Integer.valueOf(1)).skipped(Integer.valueOf(2)).successful(Integer.valueOf(3)).build()).url("http://example.com").build();
        final RestBuildStatusSetRequest restRequest = new RestBuildStatusSetRequest(request);
        AsyncTestUtils.waitFor((WaitCondition)new WaitCondition(){

            public void describeFailure(Description description) throws Exception {
                description.appendText("Expected migration to be complete within timeout");
            }

            public boolean test() {
                RepositoryBuildStatusTestHelper.this.set(commitId, restRequest, new Header[0]);
                Response response = (Response)RestAssured.given().auth().preemptive().basic(RepositoryBuildStatusTestHelper.this.user, RepositoryBuildStatusTestHelper.this.user).header("Accept", (Object)ContentType.JSON.getAcceptHeader(), new Object[0]).when().get(RepositoryBuildStatusTestHelper.this.repositorySearchUrl((Map<String, Collection<String>>)ImmutableMap.of((Object)"at", Collections.singleton(commitId))), new Object[0]);
                if (response.getStatusCode() == 200) {
                    List<InternalRestBuildStatus> page = RepositoryBuildStatusTestHelper.this.getValues(response);
                    if (page.size() != 1) {
                        throw new IllegalStateException("Expected exactly 1 result when the response code is 200, but the number of results were " + page.size());
                    }
                    InternalRestBuildStatus buildStatus = page.get(0);
                    if (buildStatus.getRef() != null) {
                        log.info("Migration is complete");
                        return true;
                    }
                }
                log.info("Migration not complete, waiting 5s before checking again");
                return false;
            }
        }, (long)maxWaitTime.toMillis(), (long)5000L);
    }

    private String appendQueryParams(String url, Map<String, Collection<String>> queryParams) {
        StringBuilder urlBuilder = new StringBuilder(url);
        if (!queryParams.isEmpty()) {
            urlBuilder.append('?');
            queryParams.forEach((paramName, paramValues) -> paramValues.forEach(paramValue -> urlBuilder.append((String)paramName).append('=').append((String)paramValue).append('&')));
        }
        return StringUtils.trimTrailingCharacter((String)urlBuilder.toString(), (char)'&');
    }

    private String getApiResourceUrl(String commitId) {
        return DefaultFuncTestData.getRestURL("api", "latest") + DefaultFuncTestData.getRepositoryPath(this.projectKey, this.repoSlug) + "/commits/" + commitId + "/builds";
    }

    private List<RestErrorMessage> getErrors(Response response) {
        return ((RestErrors)response.as(RestErrors.class)).getErrors();
    }

    private StringBuilder getUiResourceUrl() {
        return new StringBuilder(DefaultFuncTestData.getRestURL("ui", "latest")).append(DefaultFuncTestData.getRepositoryPath(this.projectKey, this.repoSlug));
    }

    private List<InternalRestBuildStatus> getValues(Response response) {
        return ((List)response.path("page.values", new String[0])).stream().map(InternalRestBuildStatus::valueOf).collect(Collectors.toList());
    }

    private String pullRequestSearchUrl(long id, Map<String, Collection<String>> queryParams) {
        StringBuilder urlBuilder = this.getUiResourceUrl().append("/pull-requests/").append(id).append("/builds");
        return this.appendQueryParams(urlBuilder.toString(), queryParams);
    }

    private String repositorySearchUrl(Map<String, Collection<String>> queryParams) {
        return this.appendQueryParams(this.getUiResourceUrl().append("/builds").toString(), queryParams);
    }

    private String repositorySearchParentUrl(Map<String, Collection<String>> queryParams) {
        return this.appendQueryParams(this.getUiResourceUrl().append("/builds/parents").toString(), queryParams);
    }

    private Response searchPullRequest(long id, Map<String, Collection<String>> queryParams, int expectedStatusCode) {
        return (Response)((ResponseSpecification)RestAssured.given().auth().preemptive().basic(this.user, this.user).header("Accept", (Object)ContentType.JSON.getAcceptHeader(), new Object[0]).expect().statusCode(expectedStatusCode).log().ifValidationFails()).when().get(this.pullRequestSearchUrl(id, queryParams), new Object[0]);
    }

    private Response searchRepository(Map<String, Collection<String>> queryParams, int expectedStatusCode) {
        return (Response)((ResponseSpecification)RestAssured.given().auth().preemptive().basic(this.user, this.user).header("Accept", (Object)ContentType.JSON.getAcceptHeader(), new Object[0]).expect().statusCode(expectedStatusCode).log().ifValidationFails()).when().get(this.repositorySearchUrl(queryParams), new Object[0]);
    }

    public Response searchRepositoryParents(Map<String, Collection<String>> queryParams, int expectedStatusCode) {
        return (Response)((ResponseSpecification)RestAssured.given().auth().preemptive().basic(this.user, this.user).header("Accept", (Object)ContentType.JSON.getAcceptHeader(), new Object[0]).expect().statusCode(expectedStatusCode).log().ifValidationFails()).when().get(this.repositorySearchParentUrl(queryParams), new Object[0]);
    }

    private Response set(int expectedStatusCode, String commitId, RestBuildStatusSetRequest setRequest, Header ... extraHeaders) {
        RequestSpecification request = RestAssured.given();
        if (this.user != null) {
            request.auth().preemptive().basic(this.user, this.user);
        }
        Arrays.stream(extraHeaders).forEach(arg_0 -> ((RequestSpecification)request).header(arg_0));
        Response response = (Response)((ResponseSpecification)request.body((Object)setRequest).contentType(ContentType.JSON).header("Accept", (Object)ContentType.JSON.getAcceptHeader(), new Object[0]).expect().statusCode(expectedStatusCode).log().ifValidationFails()).when().post(this.getApiResourceUrl(commitId), new Object[0]);
        return response;
    }
}

