/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test;

import com.atlassian.bitbucket.test.DefaultFuncTestData;
import com.atlassian.bitbucket.test.GitTestHelper;
import com.atlassian.bitbucket.test.ProcessTestHelper;
import com.atlassian.bitbucket.test.ProjectTestHelper;
import com.atlassian.bitbucket.test.RepositoryTestHelper;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.commons.lang3.StringUtils;
import org.junit.rules.ExternalResource;
import org.junit.rules.TemporaryFolder;

public class ReadmeRepoRule
extends ExternalResource {
    public final String project;
    public final String repo;
    private final TemporaryFolder folder = new TemporaryFolder();

    public ReadmeRepoRule(String project, String repo) {
        this.project = project;
        this.repo = repo;
    }

    public String getRestUrl() {
        return DefaultFuncTestData.getRepositoryRestURL(this.project, this.repo);
    }

    public String getRestUrl(String version) {
        return DefaultFuncTestData.getRepositoryRestURL(version, this.project, this.repo);
    }

    public String getRestUrl(String module, String version) {
        return DefaultFuncTestData.getRepositoryRestURL(module, version, this.project, this.repo);
    }

    public String getUrl() {
        return DefaultFuncTestData.getRepositoryURL(this.project, this.repo);
    }

    private void createWithDir(File repDir) throws Exception {
        ProcessTestHelper.execute(repDir, GitTestHelper.getGitPath(), "init");
        ReadmeRepoRule.writeStringToFile(new File(repDir, "CONTRIBUTING.md"), "# How to contribute\n\nModify `ReadmeRepoRule`");
        ReadmeRepoRule.writeStringToFile(new File(repDir, "LICENSE"), "Anything goes!");
        ReadmeRepoRule.writeStringToFile(new File(repDir, "README.md"), "# test");
        ReadmeRepoRule.writeStringToFile(new File(repDir, "a/readme.md"), "# testa");
        ReadmeRepoRule.writeStringToFile(new File(repDir, "b/notreadme.md"), "# testb");
        ReadmeRepoRule.writeStringToFile(new File(repDir, "c/notmarkdown.js"), "# testc");
        ReadmeRepoRule.writeStringToFile(new File(repDir, "txt/README.txt"), "# test plain" + System.lineSeparator() + "<b>bold</b>");
        ReadmeRepoRule.writeStringToFile(new File(repDir, "txt-with-links/README.txt"), "# test plain" + System.lineSeparator() + "http://localhost:7990/bitbucket/projects/TEST/repos/readmes/browse" + System.lineSeparator() + "www.example.com" + System.lineSeparator() + "http://www.example.com" + System.lineSeparator() + "https://example.com" + System.lineSeparator() + "A link in a sentence https://example.com");
        ReadmeRepoRule.writeStringToFile(new File(repDir, "no-ext/README"), "# test no ext");
        ReadmeRepoRule.writeStringToFile(new File(repDir, "binary/README.md"), "# test\u0000");
        ReadmeRepoRule.writeStringToFile(new File(repDir, "unicode/README.md"), "# H\u00e4ll\u00f6 \ud83d\ude00");
        ReadmeRepoRule.writeStringToFile(new File(repDir, "unicode-emoticons/README.md"), "# \ud83e\uddd1 \ud83d\udc69 \ud83d\udc68 \ud83d\udcf7 \ud83d\udcfa " + StringUtils.repeat((String)"x", (int)180));
        ReadmeRepoRule.writeStringToFile(new File(repDir, "html/README.md"), "<html><h1>test html</h1></html>");
        ReadmeRepoRule.writeStringToFile(new File(repDir, "hardwrap/README.md"), "line 1" + System.lineSeparator() + "line 2" + System.lineSeparator() + System.lineSeparator() + "line 3" + System.lineSeparator() + "line 4");
        ProcessTestHelper.execute(repDir, GitTestHelper.getGitPath(), "add", ".");
        ProcessTestHelper.execute(repDir, GitTestHelper.createCommitterEnv(), GitTestHelper.getGitPath(), "commit", "-m", "First commit");
        ProcessTestHelper.execute(repDir, GitTestHelper.getGitPath(), "branch", "first");
        ReadmeRepoRule.writeStringToFile(new File(repDir, "README.md"), "# test2");
        ProcessTestHelper.execute(repDir, GitTestHelper.createCommitterEnv(), GitTestHelper.getGitPath(), "commit", "-a", "-m", "Second commit");
        ProjectTestHelper.createProject(this.project, this.project, "Project created by the ReadmeRepoRule");
        RepositoryTestHelper.createRepository(this.project, this.repo);
        RepositoryTestHelper.pushRep(repDir, DefaultFuncTestData.getBaseURL(), DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword(), this.project, this.repo);
    }

    protected void after() {
        RepositoryTestHelper.deleteRepository(this.project, this.repo);
        ProjectTestHelper.deleteProject(this.project);
        this.folder.delete();
    }

    protected void before() throws Exception {
        this.folder.create();
        this.createWithDir(this.folder.getRoot());
    }

    private static void writeStringToFile(File file, String string) {
        if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
            throw new IllegalStateException("Could not create parent directory for " + file);
        }
        try {
            Files.write(file.toPath(), string.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

