/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test;

import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.scm.CommandTimeoutException;
import com.atlassian.bitbucket.test.GitTestHelper;
import com.atlassian.bitbucket.test.ProcessFailedException;
import com.atlassian.bitbucket.test.ProcessResult;
import com.atlassian.bitbucket.test.ProcessResultFactory;
import com.atlassian.bitbucket.test.StringProcessHandler;
import com.google.common.collect.ImmutableList;
import com.zaxxer.nuprocess.NuProcess;
import com.zaxxer.nuprocess.NuProcessBuilder;
import com.zaxxer.nuprocess.NuProcessHandler;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessTestHelper {
    private static final Logger log = LoggerFactory.getLogger(ProcessTestHelper.class);
    private final Map<String, String> env;
    private final File repositoryDirectory;

    public ProcessTestHelper(File repositoryDirectory) {
        this(repositoryDirectory, Collections.emptyMap());
    }

    public ProcessTestHelper(File repositoryDirectory, Map<String, String> env) {
        this.repositoryDirectory = repositoryDirectory;
        this.env = env;
    }

    public static ProcessResult execute(File repositoryDirectory, String ... parts) throws ProcessFailedException {
        return ProcessTestHelper.execute(repositoryDirectory, Collections.emptyMap(), parts);
    }

    public static ProcessResult execute(File repositoryDirectory, Map<String, String> env, StringProcessHandler.StdIn stdin, String ... parts) throws ProcessFailedException {
        List<String> command = Arrays.asList(parts);
        StringProcessHandler handler = new StringProcessHandler(StringUtils.join((Object[])parts, (char)' '), stdin);
        NuProcessBuilder builder = new NuProcessBuilder(command);
        builder.setCwd(repositoryDirectory.toPath());
        builder.setProcessListener((NuProcessHandler)handler);
        builder.environment().putAll(env);
        NuProcess process = builder.start();
        try {
            if (Integer.MIN_VALUE == process.waitFor(30L, TimeUnit.MINUTES)) {
                String message = "'" + handler.getCommandLine() + "' timed out";
                throw new CommandTimeoutException(new KeyedMessage("bitbucket.scm.command.timeout", message, message));
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ProcessFailedException(handler);
        }
        if (log.isDebugEnabled()) {
            log.debug("Command: {}", (Object)handler.getCommandLine());
            if (StringUtils.isNotBlank((CharSequence)handler.getOutput())) {
                log.debug("StdOut:\n{}", (Object)StringUtils.chomp((String)handler.getOutput()));
            }
        }
        return ProcessResultFactory.createOrThrow(handler);
    }

    public static ProcessResult execute(File repositoryDirectory, Map<String, String> env, String ... parts) throws ProcessFailedException {
        return ProcessTestHelper.execute(repositoryDirectory, env, StringProcessHandler.StdIn.NONE, parts);
    }

    public ProcessTestHelper execute(String ... parts) {
        ProcessTestHelper.execute(this.repositoryDirectory, this.env, parts);
        return this;
    }

    public Map<String, String> getEnv() {
        return this.env;
    }

    public File getRepositoryDirectory() {
        return this.repositoryDirectory;
    }

    public ProcessTestHelper git(StringProcessHandler.StdIn stdin, String ... parts) {
        ImmutableList gitParts = ImmutableList.builder().add((Object)GitTestHelper.getGitPath()).add((Object[])parts).build();
        ProcessTestHelper.execute(this.repositoryDirectory, this.env, stdin, (String[])gitParts.toArray((Object[])new String[gitParts.size()]));
        return this;
    }

    public ProcessTestHelper git(String ... parts) {
        return this.git(StringProcessHandler.StdIn.NONE, parts);
    }
}

