/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test;

import com.atlassian.bitbucket.dmz.rest.v2.mesh.RestMeshNode;
import com.atlassian.bitbucket.test.DefaultFuncTestData;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.specification.ResponseSpecification;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.ws.rs.core.Response;
import net.sf.json.JSONObject;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public class MeshNodeTestHelper {
    public static final String MESH_NODES_URL = DefaultFuncTestData.getRestURL() + "/admin/git/mesh/nodes";

    private MeshNodeTestHelper() {
        throw new UnsupportedOperationException("Static utility class - not for instantiation");
    }

    public static RestMeshNode getNode(long id) {
        return (RestMeshNode)((Response)((ResponseSpecification)RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).log().ifValidationFails()).given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).get(MESH_NODES_URL + "/" + id, new Object[0])).jsonPath().getObject("$", RestMeshNode.class);
    }

    public static List<RestMeshNode> getNodes() {
        return ((Response)((ResponseSpecification)RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).log().ifValidationFails()).given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).get(MESH_NODES_URL, new Object[0])).jsonPath().getList("$", RestMeshNode.class);
    }

    public static List<RestMeshNode> getNodesRestV1() {
        return ((Response)((ResponseSpecification)RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).log().ifValidationFails()).given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).get(MESH_NODES_URL, new Object[0])).jsonPath().getList("$", RestMeshNode.class);
    }

    @Nonnull
    public static RestMeshNode registerNode(@Nullable String id, @Nonnull String name, @Nonnull String rpcUrl) {
        return MeshNodeTestHelper.registerNode(MeshNodeTestHelper.createMeshNodeBody(id, name, rpcUrl));
    }

    @Nonnull
    public static RestMeshNode registerNode(@Nonnull JSONObject meshNodeJson) {
        return (RestMeshNode)((Response)RestAssured.given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).body((Object)Objects.requireNonNull(meshNodeJson, "meshNodeJson")).contentType("application/json").expect().statusCode(Response.Status.OK.getStatusCode()).log().ifError().when().post(DefaultFuncTestData.getRestURL() + "/admin/git/mesh/nodes", new Object[0])).as(RestMeshNode.class);
    }

    public static void unregisterNode(long id) {
        RestAssured.given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).expect().statusCode((Matcher)Matchers.either((Matcher)Matchers.equalTo((Object)Response.Status.OK.getStatusCode())).or(Matchers.equalTo((Object)Response.Status.NOT_FOUND.getStatusCode()))).log().ifError().when().delete(DefaultFuncTestData.getRestURL() + "/admin/git/mesh/nodes/" + id, new Object[0]);
    }

    private static JSONObject createMeshNodeBody(String nodeId, String name, String rpcUrl) {
        JSONObject bodyObject = new JSONObject();
        if (nodeId != null) {
            bodyObject.put((Object)"id", (Object)nodeId);
        }
        bodyObject.put((Object)"name", (Object)name);
        bodyObject.put((Object)"rpcUrl", (Object)rpcUrl);
        return bodyObject;
    }
}

