/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test;

import com.atlassian.bitbucket.test.ProcessResult;
import com.atlassian.bitbucket.test.ProcessTestHelper;
import com.atlassian.bitbucket.util.Version;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.slf4j.LoggerFactory;

public class GitTestHelper {
    private static final Map<String, String> COMMITTER_ENV = ImmutableMap.builder().putAll(System.getenv()).put((Object)"GIT_COMMITTER_NAME", (Object)"Stash Func Test Runner").put((Object)"GIT_COMMITTER_EMAIL", (Object)"stash-dev@atlassian.com").put((Object)"GIT_AUTHOR_NAME", (Object)"Stash Func Test Runner").put((Object)"GIT_AUTHOR_EMAIL", (Object)"stash-dev@atlassian.com").build();
    private static String gitPath;
    private static Version gitVersion;

    private GitTestHelper() {
        throw new UnsupportedOperationException(GitTestHelper.class.getName() + " should not be instantiated");
    }

    @Nonnull
    public static Map<String, String> createCommitterEnv() {
        return COMMITTER_ENV;
    }

    @Nonnull
    public static String getGitPath() {
        if (gitPath == null) {
            gitPath = (String)MoreObjects.firstNonNull((Object)System.getenv("GIT_PATH"), (Object)"git");
        }
        return gitPath;
    }

    @Nonnull
    public static Optional<Version> getGitVersion() {
        if (gitVersion == null) {
            try {
                ProcessResult result = ProcessTestHelper.execute(new File(System.getProperty("user.dir")), GitTestHelper.getGitPath(), "--version");
                String stdOut = result.getStdOut();
                int index = stdOut.indexOf("git version ");
                if (index >= 0) {
                    gitVersion = new Version(stdOut.substring(index + 12));
                }
            }
            catch (Exception e) {
                LoggerFactory.getLogger(GitTestHelper.class).info("Could not determine git version", (Throwable)e);
            }
        }
        return Optional.ofNullable(gitVersion);
    }

    public static boolean isGitVersionAtLeast(@Nonnull Version minimum) {
        return GitTestHelper.getGitVersion().map(version -> version.compareTo(minimum) >= 0).orElse(Boolean.FALSE);
    }
}

