/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test;

import com.atlassian.bitbucket.test.DefaultFuncTestData;
import com.atlassian.bitbucket.test.ProductTopology;
import com.atlassian.bitbucket.test.ProductTopologyAdapter;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;

public class ClusterUtils {
    private ClusterUtils() {
        throw new UnsupportedOperationException("Constructor not supported in utility class");
    }

    public static void acceptOnEachNode(String targetUrl, Consumer<String> consumer) {
        ProductTopology.get().accept(new NodeUrlVisitor(targetUrl)).forEach(consumer);
    }

    public static <T> Set<T> executeOnEachNode(String targetUrl, Function<String, T> function) {
        return (Set)ProductTopology.get().accept(new NodeUrlVisitor(targetUrl)).stream().map(function).collect(MoreCollectors.toImmutableSet());
    }

    private static class NodeUrlVisitor
    extends ProductTopologyAdapter<Set<String>> {
        private final String targetUrl;

        private NodeUrlVisitor(String targetUrl) {
            this.targetUrl = targetUrl;
        }

        @Override
        public Set<String> visitStashClusterPair() {
            String node1Url = this.targetUrl.replace(DefaultFuncTestData.getBaseURL(), System.getProperty("baseurl.bitbucket-node-1", "http://localhost:7991/bitbucket"));
            String node2Url = this.targetUrl.replace(DefaultFuncTestData.getBaseURL(), System.getProperty("baseurl.bitbucket-node-2", "http://localhost:7992/bitbucket"));
            return ImmutableSet.of((Object)node1Url, (Object)node2Url);
        }

        @Override
        protected Set<String> visitDefault() {
            return ImmutableSet.of((Object)this.targetUrl);
        }
    }
}

