/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test;

import com.atlassian.bitbucket.junit.HashedTestNameRule;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.test.DefaultFuncTestData;
import com.atlassian.bitbucket.test.ProductTopology;
import com.atlassian.bitbucket.test.TestContext;
import com.atlassian.bitbucket.test.annotations.CompatibleWithProductTopologies;
import com.atlassian.bitbucket.test.audit.AuditFileVerifier;
import com.atlassian.bitbucket.test.audit.AuditVerificationRule;
import com.atlassian.bitbucket.test.audit.RestAuditVerifier;
import com.atlassian.bitbucket.test.rules.RestAssuredTimeoutRule;
import com.atlassian.bitbucket.test.rules.TestClassQualified;
import com.atlassian.bitbucket.test.rules.TestNameQualified;
import java.util.Arrays;
import java.util.List;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.rules.RuleChain;
import org.junit.rules.TemporaryFolder;
import org.junit.rules.TestRule;

@CompatibleWithProductTopologies
public abstract class BaseFuncTest {
    @ClassRule
    public static final HashedTestNameRule hashedClassName = new HashedTestNameRule();
    @ClassRule
    public static RestAssuredTimeoutRule restTimeoutRule = new RestAssuredTimeoutRule(30000);
    @ClassRule
    public static final TemporaryFolder tempFolder = new TemporaryFolder();
    @ClassRule
    public static final TestClassQualified testClassQualified = new TestClassQualified(BaseFuncTest.class);
    protected static final AuditVerificationRule auditVerificationRule = BaseFuncTest.getAuditVerificationRule();
    protected static final boolean AUDIT_VERIFICATION_DISABLED = Boolean.parseBoolean(System.getProperty("audit.verification.disabled", String.valueOf(false)));
    protected static final boolean MESH_ENABLED = Boolean.parseBoolean(System.getProperty("mesh.enabled", String.valueOf(true)));
    private static final String ADMIN_DISPLAY_NAME = "Administrator";
    private static final ThreadLocal<TestContext> classTestContext = new ThreadLocal();
    @Rule
    public HashedTestNameRule hashedTestName = new HashedTestNameRule();
    protected final TestNameQualified testNameQualified = new TestNameQualified(this::getTestRunDifferentiator);
    protected final TestContext testContext = new MethodTestContext();
    private String uniqueAdminUsername;
    private String uniqueAdminPassword;

    @ClassRule
    public static TestContext createClassTestContext() {
        ClassTestContext context = new ClassTestContext();
        classTestContext.set(context);
        return context;
    }

    protected static TestContext getClassTestContext() {
        return classTestContext.get();
    }

    @Rule
    public final RuleChain createTestRuleChain() {
        RuleChain chain = RuleChain.emptyRuleChain();
        for (TestRule rule : this.getRuleChain()) {
            chain = chain.around(rule);
        }
        return chain;
    }

    @Before
    public void setupTestSpecificData() {
        this.uniqueAdminPassword = this.uniqueAdminUsername = "admin-" + this.hashedTestName.toString();
        this.testContext.user(this.uniqueAdminUsername, ADMIN_DISPLAY_NAME, this.uniqueAdminUsername).globalPermission(this.uniqueAdminUsername, Permission.SYS_ADMIN);
    }

    public String getAdminUser() {
        return this.uniqueAdminUsername;
    }

    public String getAdminEmail() {
        return this.getAdminUser() + "@testdata.atlassian.com";
    }

    public String getAdminName() {
        return ADMIN_DISPLAY_NAME;
    }

    public String getAdminPassword() {
        return this.uniqueAdminPassword;
    }

    protected static AuditVerificationRule getAuditVerificationRule() {
        if (ProductTopology.get() == ProductTopology.BITBUCKET_CLUSTER_PAIR) {
            return new AuditVerificationRule(new RestAuditVerifier());
        }
        return new AuditVerificationRule(new AuditFileVerifier(DefaultFuncTestData.getBaseURL()), new RestAuditVerifier());
    }

    protected List<TestRule> getRuleChain() {
        return AUDIT_VERIFICATION_DISABLED ? Arrays.asList(this.testNameQualified, this.testContext, tempFolder) : Arrays.asList(this.testNameQualified, this.testContext, tempFolder, auditVerificationRule);
    }

    protected String getTestRunDifferentiator() {
        return "";
    }

    private static class MethodTestContext
    extends TestContext {
        private MethodTestContext() {
        }
    }

    private static class ClassTestContext
    extends TestContext {
        private ClassTestContext() {
        }
    }
}

