/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test.rules;

import com.atlassian.bitbucket.test.DarkFeatureTestHelper;
import com.atlassian.bitbucket.test.annotations.RequiresDarkFeature;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.junit.rules.ExternalResource;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class DarkFeatureRule
extends ExternalResource {
    private String[] initialFeatures;

    public Statement apply(final Statement base, Description description) {
        final List<RequiresDarkFeature> annotations = this.getAnnotations(description);
        if (annotations.isEmpty()) {
            return base;
        }
        return new Statement(){

            public void evaluate() throws Throwable {
                try {
                    DarkFeatureRule.access$002(DarkFeatureRule.this, DarkFeatureTestHelper.getEnabledFeatures());
                    String[] enabledFeatures = (String[])annotations.stream().flatMap(annotation -> Arrays.stream(annotation.value())).distinct().toArray(String[]::new);
                    DarkFeatureTestHelper.enableDarkFeatures(enabledFeatures);
                    base.evaluate();
                }
                finally {
                    DarkFeatureTestHelper.disableDarkFeatures(new String[0]);
                    DarkFeatureTestHelper.enableDarkFeatures(DarkFeatureRule.this.initialFeatures);
                }
            }
        };
    }

    private List<RequiresDarkFeature> getAnnotations(Description description) {
        RequiresDarkFeature classAnnotation;
        ArrayList<RequiresDarkFeature> annotations = new ArrayList<RequiresDarkFeature>();
        RequiresDarkFeature descriptionAnnotation = (RequiresDarkFeature)description.getAnnotation(RequiresDarkFeature.class);
        if (descriptionAnnotation != null) {
            annotations.add(descriptionAnnotation);
        }
        if ((classAnnotation = description.getTestClass().getAnnotation(RequiresDarkFeature.class)) != null) {
            annotations.add(classAnnotation);
        }
        annotations.addAll(description.getChildren().stream().map(child -> (RequiresDarkFeature)child.getAnnotation(RequiresDarkFeature.class)).filter(Objects::nonNull).collect(Collectors.toList()));
        return annotations;
    }

    static /* synthetic */ String[] access$002(DarkFeatureRule x0, String[] x1) {
        x0.initialFeatures = x1;
        return x1;
    }
}

