/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test.rest.server.stub.mirror;

import com.atlassian.bitbucket.test.DefaultFuncTestData;
import com.atlassian.bitbucket.test.rest.server.stub.mirror.DescriptorUtils;
import com.atlassian.bitbucket.wiremock.WiremockTestUtils;
import com.atlassian.httpclient.api.Request;
import com.atlassian.jwt.CanonicalHttpRequest;
import com.atlassian.jwt.SigningAlgorithm;
import com.atlassian.jwt.core.writer.JsonSmartJwtJsonBuilder;
import com.atlassian.jwt.core.writer.JwtClaimsBuilder;
import com.atlassian.jwt.core.writer.NimbusJwtWriterFactory;
import com.atlassian.jwt.httpclient.CanonicalHttpUriRequest;
import com.atlassian.jwt.writer.JwtJsonBuilder;
import com.atlassian.jwt.writer.JwtWriterFactory;
import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.matching.MatchResult;
import com.github.tomakehurst.wiremock.matching.RequestPatternBuilder;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MirrorStub {
    private static final Logger log = LoggerFactory.getLogger(MirrorStub.class);
    private static final String type = "single";
    private final String addonKey;
    private final String id;
    private final JwtWriterFactory jwtWriter;
    private final String serverId;
    private final WireMockServer wireMock;
    private volatile String sharedSecret;

    private MirrorStub(WireMockServer wireMockServer, String id) {
        this.wireMock = wireMockServer;
        this.id = id + "-" + Long.toString(new Date().getTime(), 32);
        this.serverId = UUID.randomUUID().toString();
        this.addonKey = "addon-" + this.serverId;
        this.jwtWriter = new NimbusJwtWriterFactory();
    }

    public static MirrorStub aStub(WireMockServer wiremock, String id) {
        return new MirrorStub(wiremock, id);
    }

    public static String getDescriptorUrl(String baseUrl, String mirrorId) {
        return MirrorStub.joinUrlAndPath(baseUrl, MirrorStub.getDescriptorPath(mirrorId));
    }

    public static String joinUrlAndPath(String baseUrl, String path) {
        return String.format("%s%s", baseUrl, StringUtils.prependIfMissing((String)path, (CharSequence)"/", (CharSequence[])new CharSequence[0]));
    }

    public MirrorStub configureDefaultResponders() {
        this.wireMock.stubFor(WireMock.get((UrlPattern)WireMock.urlPathEqualTo((String)this.getDescriptorPath())).willReturn(WireMock.aResponse().withHeader("Content-type", new String[]{"application/json"}).withStatus(Response.Status.OK.getStatusCode()).withBody(this.getDescriptor())));
        this.wireMock.stubFor(WireMock.post((UrlPattern)WireMock.urlPathEqualTo((String)this.getEnabledPath())).willReturn(WireMock.aResponse().withStatus(Response.Status.OK.getStatusCode())));
        this.wireMock.stubFor(WireMock.post((UrlPattern)WireMock.urlPathEqualTo((String)this.getDisabledPath())).willReturn(WireMock.aResponse().withStatus(Response.Status.OK.getStatusCode())));
        this.wireMock.stubFor(WireMock.post((UrlPattern)WireMock.urlPathEqualTo((String)this.getUninstalledPath())).willReturn(WireMock.aResponse().withStatus(Response.Status.OK.getStatusCode())));
        this.wireMock.stubFor(WireMock.post((UrlPattern)WireMock.urlPathEqualTo((String)this.getWebhookEventsPath())).willReturn(WireMock.aResponse().withStatus(Response.Status.OK.getStatusCode())));
        this.wireMock.stubFor(WireMock.requestMatching(request -> {
            if (request.getUrl().contains(this.getInstalledPath())) {
                try {
                    Map properties = (Map)new ObjectMapper().readValue(request.getBodyAsString(), Map.class);
                    String sharedSecretProperty = (String)properties.get("sharedSecret");
                    if (sharedSecretProperty == null) {
                        log.error("No shared secret found during stub mirror install callback. Request body:\n{}", (Object)request.getBody());
                    }
                    this.sharedSecret = sharedSecretProperty;
                }
                catch (IOException e) {
                    log.error("Failed to capture shared secret during stub mirror install callback. Request body:\n{}", (Object)request.getBodyAsString(), (Object)e);
                }
                return MatchResult.of((boolean)true);
            }
            return MatchResult.of((boolean)false);
        }).willReturn(WireMock.aResponse().withStatus(Response.Status.OK.getStatusCode())));
        return this;
    }

    public String getAddonKey() {
        return this.addonKey;
    }

    public String getBaseUrl() {
        return this.wireMock.baseUrl();
    }

    public String getDescriptorPath() {
        return MirrorStub.getDescriptorPath(this.serverId);
    }

    public String getDescriptorUrl() {
        return this.getUrl(this.getDescriptorPath());
    }

    public String getDisabledPath() {
        return String.format("/%s/disabled", this.serverId);
    }

    public String getEnabledPath() {
        return String.format("/%s/enabled", this.serverId);
    }

    public String getId() {
        return this.id;
    }

    public String getInstalledPath() {
        return String.format("/%s/installed", this.serverId);
    }

    public String getType() {
        return type;
    }

    public String getUninstalledPath() {
        return String.format("/%s/uninstalled", this.serverId);
    }

    public String getUrl(String path) {
        return MirrorStub.joinUrlAndPath(this.getBaseUrl(), path);
    }

    public String getWebhookEventsPath() {
        return String.format("/%s/events", this.serverId);
    }

    public String signRequest(Request.Method method, String baseUrl, String requestUrl) throws UnsupportedEncodingException, NoSuchAlgorithmException {
        return this.signRequest(method, baseUrl, requestUrl, Collections.emptyMap());
    }

    public String signRequest(@Nonnull Request.Method method, @Nonnull String baseUrl, @Nonnull String requestUrl, @Nonnull Map<String, String[]> parameters) throws UnsupportedEncodingException, NoSuchAlgorithmException {
        if (this.sharedSecret == null) {
            throw new IllegalStateException("This mirror has not been installed or the install request was not captured");
        }
        Objects.requireNonNull(method, "method");
        Objects.requireNonNull(baseUrl, "baseUrl");
        Objects.requireNonNull(requestUrl, "requestUrl");
        Preconditions.checkArgument((boolean)requestUrl.startsWith(baseUrl), (Object)"requestUrl must start with baseUrl");
        String relativeUrl = requestUrl.substring(DefaultFuncTestData.getBaseURL().length());
        CanonicalHttpUriRequest canonical = new CanonicalHttpUriRequest(method.name(), relativeUrl, "", parameters);
        long issuedAt = TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis());
        long expiresAt = issuedAt + 180L;
        JwtJsonBuilder jwtBuilder = new JsonSmartJwtJsonBuilder().issuedAt(issuedAt).expirationTime(expiresAt).issuer(this.addonKey);
        JwtClaimsBuilder.appendHttpRequestClaims((JwtJsonBuilder)jwtBuilder, (CanonicalHttpRequest)canonical);
        return this.jwtWriter.macSigningWriter(SigningAlgorithm.HS256, this.sharedSecret).jsonToJwt(jwtBuilder.build());
    }

    public void waitForInstallation() {
        WiremockTestUtils.waitForRequest((WireMockServer)this.wireMock, (RequestPatternBuilder)WireMock.postRequestedFor((UrlPattern)WireMock.urlPathEqualTo((String)this.getEnabledPath())));
    }

    private static String getDescriptorPath(String mirrorId) {
        return String.format("/add-ons/%s/descriptor.xml", mirrorId);
    }

    private String getDescriptor() {
        return DescriptorUtils.generateDescriptor(this.addonKey, "Atlassian Stash Stub Mirror", this.getBaseUrl(), this.getInstalledPath(), this.getUninstalledPath(), this.getEnabledPath(), this.getDisabledPath(), this.getWebhookEventsPath(), this.getBaseUrl());
    }
}

