/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test.rest.repository;

import com.atlassian.bitbucket.test.DefaultFuncTestData;
import com.atlassian.bitbucket.test.RestTestHelper;
import com.atlassian.bitbucket.test.rest.AbstractRestHelper;
import com.atlassian.bitbucket.test.rest.RestAuthentication;
import com.atlassian.bitbucket.test.rest.repository.RestRepositoryRequest;
import io.restassured.path.json.JsonPath;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class RestRepositoryHelper
extends AbstractRestHelper {
    private final String projectKey;
    private final String repositorySlug;

    public RestRepositoryHelper(@Nonnull String projectKey, @Nonnull String repositorySlug) {
        this(DefaultFuncTestData.getAdminAuthentication(), projectKey, repositorySlug);
    }

    public RestRepositoryHelper(@Nullable RestAuthentication defaultAuthentication, @Nonnull String projectKey, @Nonnull String repositorySlug) {
        super(defaultAuthentication);
        this.projectKey = Objects.requireNonNull(projectKey, "projectKey");
        this.repositorySlug = Objects.requireNonNull(repositorySlug, "repositorySlug");
    }

    @Nonnull
    public JsonPath get() {
        return this.get(new RestRepositoryRequest.Builder().build());
    }

    @Nonnull
    public JsonPath get(@Nonnull RestRepositoryRequest request) {
        return this.get(this.getUrl(request), request);
    }

    @Nonnull
    public String getUrl(@Nonnull RestRepositoryRequest request) {
        return RestTestHelper.buildUrl(DefaultFuncTestData.getRepositoryRestURL(this.projectKey, this.repositorySlug), request);
    }
}

