/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test.rest.mirror;

import com.atlassian.bitbucket.test.DefaultFuncTestData;
import com.atlassian.bitbucket.test.ProductTopology;
import com.atlassian.bitbucket.test.StatusCodesTestHelper;
import com.atlassian.bitbucket.test.rest.mirror.MirroringRequestHelper;
import com.atlassian.bitbucket.test.rest.server.stub.mirror.MirrorStub;
import io.restassured.RestAssured;
import io.restassured.specification.RequestSpecification;
import io.restassured.specification.ResponseSpecification;
import javax.ws.rs.core.Response;

public class MirroringInstallationHelper {
    public static void uninstall(MirrorStub mirror, Response.Status ... statuses) {
        try {
            MirroringInstallationHelper.doUninstall(mirror, statuses);
        }
        catch (Throwable e) {
            if (ProductTopology.get() == ProductTopology.BITBUCKET_CLUSTER_PAIR) {
                MirroringInstallationHelper.doUninstall(mirror, Response.Status.NO_CONTENT, Response.Status.NOT_FOUND);
            }
            throw e;
        }
    }

    private static void doUninstall(MirrorStub mirror, Response.Status ... statuses) {
        ((ResponseSpecification)((RequestSpecification)RestAssured.given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).contentType("application/json").log().ifValidationFails()).expect().statusCode(StatusCodesTestHelper.matching(statuses)).log().ifValidationFails()).when().delete(MirroringRequestHelper.getAddOnUrl(mirror), new Object[0]);
    }
}

