/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test.rest.jiracloud.stubs;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import org.codehaus.jackson.map.ObjectMapper;

public class PermissionsStub {
    private static final ObjectMapper mapper = new ObjectMapper();
    private final WireMockServer wiremock;
    private String cloudId = "cloudId";

    private PermissionsStub(WireMockServer wiremock) {
        this.wiremock = wiremock;
    }

    public static PermissionsStub asStub(WireMockServer wiremock) {
        return new PermissionsStub(wiremock);
    }

    public static String getPermissionsUrl(String cloudId) {
        return String.format("/jira/hudson/0.1/apps/%s/capabilities", cloudId);
    }

    public PermissionsStub forCloudId(String cloudId) {
        this.cloudId = cloudId;
        return this;
    }

    public void shouldReturnEnabledModules(Permission ... permissions) throws IOException {
        ImmutableSet specifiedPermissions = ImmutableSet.copyOf((Object[])permissions);
        ImmutableMap.Builder permissionsMap = ImmutableMap.builder();
        for (Permission permission : Permission.values()) {
            permissionsMap.put((Object)permission.getFieldName(), (Object)specifiedPermissions.contains((Object)permission));
        }
        String responseBody = mapper.writeValueAsString((Object)permissionsMap.build());
        String permissionsUrl = PermissionsStub.getPermissionsUrl(this.cloudId);
        this.wiremock.stubFor(WireMock.get((UrlPattern)WireMock.urlPathEqualTo((String)permissionsUrl)).willReturn(WireMock.aResponse().withBody(responseBody)));
    }

    public void shouldReturnInvalidAccessTokenError() {
        String permissionsUrl = PermissionsStub.getPermissionsUrl(this.cloudId);
        this.wiremock.stubFor(WireMock.get((UrlPattern)WireMock.urlPathEqualTo((String)permissionsUrl)).willReturn(WireMock.aResponse().withStatus(401)));
    }

    public void shouldReturnOauthCredentialsError() {
        String permissionsUrl = PermissionsStub.getPermissionsUrl(this.cloudId);
        this.wiremock.stubFor(WireMock.get((UrlPattern)WireMock.urlPathEqualTo((String)permissionsUrl)).willReturn(WireMock.aResponse().withStatus(403)));
    }

    public static enum Permission {
        BUILDS("buildsModuleEnabled"),
        DEPLOYMENTS("deploymentsModuleEnabled"),
        DEV_INFO("devInfoModuleEnabled"),
        FEATURE_FLAGS("featureFlagsModuleEnabled");

        private final String fieldName;

        private Permission(String fieldName) {
            this.fieldName = fieldName;
        }

        public String getFieldName() {
            return this.fieldName;
        }
    }
}

