/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test.rest.comment;

import io.restassured.builder.ResponseSpecBuilder;
import io.restassured.specification.ResponseSpecification;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.hamcrest.Matchers;

public class RestCommentLikeUtils {
    public static ResponseSpecification expectLikedBy(String basePath, List<String> userSlugs) {
        return RestCommentLikeUtils.expectLikedBy(basePath, userSlugs, userSlugs.size());
    }

    public static ResponseSpecification expectLikedBy(String basePath, List<String> userSlugs, int totalCount) {
        if (!StringUtils.isEmpty((CharSequence)basePath) && !StringUtils.endsWith((CharSequence)basePath, (CharSequence)".")) {
            basePath = basePath + '.';
        }
        ResponseSpecBuilder builder = new ResponseSpecBuilder();
        builder.expectBody(basePath + "properties.likedBy.total", Matchers.equalTo((Object)totalCount));
        for (int i = 0; i < userSlugs.size(); ++i) {
            builder.expectBody(basePath + "properties.likedBy.likers[" + i + "].slug", Matchers.isIn(userSlugs));
        }
        return builder.build();
    }
}

