/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test.rest;

import com.atlassian.bitbucket.test.rest.AbstractRestRequest;
import com.atlassian.bitbucket.test.rest.HasBody;
import com.atlassian.bitbucket.test.rest.RestAuthentication;
import com.google.common.base.MoreObjects;
import io.restassured.RestAssured;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import io.restassured.specification.RequestSpecification;
import io.restassured.specification.ResponseSpecification;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;

public abstract class AbstractRestHelper {
    protected final RestAuthentication defaultAuthentication;

    protected AbstractRestHelper(@Nullable RestAuthentication defaultAuthentication) {
        this.defaultAuthentication = defaultAuthentication == null ? RestAuthentication.anonymous() : defaultAuthentication;
    }

    public RequestSpecification request() {
        return AbstractRestHelper.authenticatedRequest(this.defaultAuthentication);
    }

    protected JsonPath delete(@Nonnull String url, @Nonnull AbstractRestRequest request) {
        return ((Response)this.buildRequest(request).when().delete(url, new Object[0])).jsonPath();
    }

    protected JsonPath get(@Nonnull String url, @Nonnull AbstractRestRequest request) {
        return ((Response)this.buildRequest(request).when().get(url, new Object[0])).jsonPath();
    }

    protected JsonPath post(@Nonnull String url, @Nonnull AbstractRestRequest request) {
        return ((Response)this.buildRequest(request, true).when().post(url, new Object[0])).jsonPath();
    }

    protected JsonPath put(@Nonnull String url, @Nonnull AbstractRestRequest request) {
        return ((Response)this.buildRequest(request, true).when().put(url, new Object[0])).jsonPath();
    }

    private static RequestSpecification authenticatedRequest(RestAuthentication authentication) {
        RequestSpecification builder = AbstractRestHelper.jsonRequest();
        if (authentication.isAuthenticated()) {
            builder.auth().preemptive().basic(authentication.getUsername(), authentication.getPassword());
        } else {
            builder.auth().none();
        }
        return builder;
    }

    private static RequestSpecification jsonRequest() {
        return RestAssured.given().contentType("application/json");
    }

    private RequestSpecification authenticatedRequest(AbstractRestRequest request) {
        return AbstractRestHelper.authenticatedRequest((RestAuthentication)MoreObjects.firstNonNull((Object)request.getAuthentication(), (Object)this.defaultAuthentication));
    }

    private ResponseSpecification buildRequest(AbstractRestRequest request) {
        return this.buildRequest(request, false);
    }

    private ResponseSpecification buildRequest(AbstractRestRequest request, boolean withBody) {
        RequestSpecification builder = this.authenticatedRequest(request);
        if (withBody && request instanceof HasBody) {
            builder.body((Object)((HasBody)((Object)request)).getBody());
        }
        return (ResponseSpecification)builder.expect().spec(request.getResponseSpecification()).log().ifStatusCodeMatches(CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)request.getStatus().getStatusCode()))).log().ifValidationFails();
    }
}

