/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test.jiracloud;

import com.atlassian.bitbucket.test.DefaultFuncTestData;
import com.atlassian.bitbucket.test.RestTestHelper;
import io.restassured.RestAssured;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.core.Response;
import net.sf.json.JSONObject;
import org.junit.Assert;

public class JiraSiteConfigTestHelper {
    private static final String ENDPOINT = "/jira-site-config";

    public static void assertConfig(Response response) {
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatusCode());
        JsonPath path = JsonPath.from((String)response.asString());
        Assert.assertEquals((Object)"CONNECTED", (Object)path.getString("connectionStatus"));
        Assert.assertFalse((boolean)path.getString("id").isEmpty());
    }

    public static void assertCloudId(String cloudId, Response response) {
        JsonPath path = JsonPath.from((String)response.asString());
        Assert.assertEquals((Object)cloudId, (Object)path.getString("cloudId"));
    }

    public static void assertCloudIdFetchError(Response response) {
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.getStatusCode());
        JsonPath path = JsonPath.from((String)response.asString());
        List<JSONObject> errors = RestTestHelper.extractValues(path, "errors");
        JSONObject error = errors.get(0);
        Assert.assertEquals((Object)"Unable to fetch Cloud ID for the given URL", (Object)error.getString("message"));
        Assert.assertEquals((Object)"com.atlassian.stash.internal.jira.cloud.config.exception.JiraSiteConfigException", (Object)error.getString("exceptionName"));
    }

    public static void assertConfigList(List<Integer> jiraSiteIds, Response response) {
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatusCode());
        List<Integer> extractedJiraSiteIds = JiraSiteConfigTestHelper.extractJiraSiteIds(response);
        Assert.assertTrue((extractedJiraSiteIds.size() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)extractedJiraSiteIds.containsAll(jiraSiteIds));
    }

    public static void assertInvalidOauthCredentialsError(Response response) {
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.getStatusCode());
        JsonPath path = JsonPath.from((String)response.asString());
        List<JSONObject> errors = RestTestHelper.extractValues(path, "errors");
        JSONObject error = errors.get(0);
        Assert.assertEquals((Object)"Invalid OAuth credentials", (Object)error.getString("message"));
        Assert.assertEquals((Object)"com.atlassian.stash.internal.jira.cloud.config.exception.InvalidOauthCredentialException", (Object)error.getString("exceptionName"));
    }

    public static void assertUpdatedConfig(String name, Response response) {
        JiraSiteConfigTestHelper.assertConfig(response);
        JsonPath path = JsonPath.from((String)response.asString());
        Assert.assertEquals((Object)name, (Object)path.getString("name"));
    }

    public static Response createJiraSiteConfig(String name, String clientId, String clientSecret, String jiraSiteUrl) {
        return (Response)RestAssured.given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).contentType("application/json").body(JiraSiteConfigTestHelper.getRequestPayload(name, clientId, clientSecret, jiraSiteUrl)).when().post(JiraSiteConfigTestHelper.getJiraSiteConfigUrl() + ENDPOINT, new Object[0]);
    }

    public static Response createJiraSiteConfigNonAdmin(String name, String clientId, String clientSecret, String jiraSiteUrl) {
        return (Response)RestAssured.given().auth().preemptive().basic(DefaultFuncTestData.getRegularUser(), DefaultFuncTestData.getRegularUserPassword()).contentType("application/json").body(JiraSiteConfigTestHelper.getRequestPayload(name, clientId, clientSecret, jiraSiteUrl)).when().post(JiraSiteConfigTestHelper.getJiraSiteConfigUrl() + ENDPOINT, new Object[0]);
    }

    public static void deleteAllJiraSites() {
        JiraSiteConfigTestHelper.extractJiraSiteIds(JiraSiteConfigTestHelper.getAllJiraSiteConfig()).stream().forEach(id -> JiraSiteConfigTestHelper.deleteJiraSiteConfig(id));
    }

    public static int extractJiraSiteId(Response response) {
        JsonPath path = JsonPath.from((String)response.asString());
        return path.getInt("id");
    }

    public static List<Integer> extractJiraSiteIds(Response response) {
        JsonPath path = JsonPath.from((String)response.asString());
        List<JSONObject> jiraSiteConfigList = RestTestHelper.extractValues(path, "values");
        List<Integer> extractedJiraSiteIds = jiraSiteConfigList.stream().map(f -> f.getInt("id")).collect(Collectors.toList());
        return extractedJiraSiteIds;
    }

    public static List<String> extractNames(Response response) {
        JsonPath path = JsonPath.from((String)response.asString());
        List<JSONObject> jiraSiteConfigList = RestTestHelper.extractValues(path, "values");
        return jiraSiteConfigList.stream().map(f -> f.getString("name")).collect(Collectors.toList());
    }

    public static Response deleteJiraSiteConfig(int id) {
        return (Response)RestAssured.given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).when().delete(JiraSiteConfigTestHelper.getJiraSiteConfigUrl() + ENDPOINT + "/{id}", new Object[]{id});
    }

    public static Response getAllJiraSiteConfig() {
        return (Response)RestAssured.given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).when().get(JiraSiteConfigTestHelper.getJiraSiteConfigUrl() + ENDPOINT, new Object[0]);
    }

    public static Response getJiraSiteConfig(int id) {
        return (Response)RestAssured.given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).when().get(JiraSiteConfigTestHelper.getJiraSiteConfigUrl() + ENDPOINT + "/{id}", new Object[]{id});
    }

    public static Response refreshPermissions(int id) {
        return (Response)RestAssured.given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).when().get(JiraSiteConfigTestHelper.getJiraSiteConfigUrl() + ENDPOINT + "/{id}/refresh-permissions", new Object[]{id});
    }

    public static Response updateJiraSiteConfig(int id, String clientId, String clientSecret, String name, String url) {
        return (Response)RestAssured.given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).contentType("application/json").body(JiraSiteConfigTestHelper.getRequestPayload(name, clientId, clientSecret, url)).when().put(JiraSiteConfigTestHelper.getJiraSiteConfigUrl() + ENDPOINT + "/{id}", new Object[]{id});
    }

    public static Response invokeDeleteRequest(int id) {
        return (Response)RestAssured.given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).when().delete(JiraSiteConfigTestHelper.getJiraSiteConfigUrl() + ENDPOINT + "/{id}", new Object[]{id});
    }

    private static String getRequestPayload(String name, String clientId, String clientSecret, String jiraSiteUrl) {
        JSONObject requestParams = new JSONObject();
        requestParams.put((Object)"name", (Object)name);
        requestParams.put((Object)"clientId", (Object)clientId);
        requestParams.put((Object)"clientSecret", (Object)clientSecret);
        requestParams.put((Object)"url", (Object)jiraSiteUrl);
        return requestParams.toString();
    }

    private static String getJiraSiteConfigUrl() {
        return DefaultFuncTestData.getRestURL("jira-dev", "latest");
    }
}

