/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test.jiracloud;

import com.atlassian.bitbucket.test.DefaultFuncTestData;
import com.atlassian.bitbucket.test.ProcessTestHelper;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;
import org.junit.rules.TemporaryFolder;

public class GitHelper {
    private final ProcessTestHelper run;
    private final String project;
    private final String repo;
    private final File workDir;

    public GitHelper(TemporaryFolder tmp, String project, String repo) {
        String user = DefaultFuncTestData.getAdminUser();
        this.project = project;
        this.repo = repo;
        String authorEmail = user + "@example.com";
        try {
            this.workDir = tmp.newFolder();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.run = new ProcessTestHelper(this.workDir, (Map<String, String>)ImmutableMap.of((Object)"GIT_COMMITTER_NAME", (Object)user, (Object)"GIT_COMMITTER_EMAIL", (Object)authorEmail, (Object)"GIT_AUTHOR_EMAIL", (Object)authorEmail, (Object)"GIT_AUTHOR_NAME", (Object)user));
    }

    public GitHelper addRemote(String name, String username, String password, String project, String repo) {
        this.run.git("remote", "add", name, GitHelper.getCloneUrl(username, password, project, repo));
        return this;
    }

    public GitHelper clone(String username, String password) {
        this.run.git("clone", GitHelper.getCloneUrl(username, password, this.project, this.repo), this.workDir.getPath());
        return this;
    }

    public GitHelper createBranch(String branch) {
        this.run.git("branch", branch, "master");
        return this;
    }

    public GitHelper checkout(String branch) {
        this.run.git("checkout", branch);
        return this;
    }

    public GitHelper commit(FutureCommit commit) {
        commit.fileNameContent.forEach((path, content) -> {
            try {
                FileUtils.writeStringToFile((File)new File(this.workDir, (String)path), (String)content, (Charset)Charsets.UTF_8);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        commit.filesToDelete.forEach(fileName -> Assert.assertTrue((boolean)new File(this.workDir, (String)fileName).delete()));
        this.run.git("add", "-A", ".");
        ArrayList<String> options = new ArrayList<String>();
        if (commit.author != null) {
            options.add("-c");
            options.add("user.name=\"" + commit.username + "\"");
            options.add("-c");
            options.add("user.email=\"" + commit.email + "\"");
        }
        options.add("commit");
        if (commit.author != null) {
            options.add("--author");
            options.add("\"" + commit.author + "\"");
        }
        options.add("--allow-empty");
        options.add("-m");
        options.add(commit.message);
        this.run.git(options.toArray(new String[options.size()]));
        return this;
    }

    public GitHelper deleteBranch(String branch) {
        this.run.git("push", "origin", ":" + branch);
        return this;
    }

    public File getWorkDir() {
        return this.workDir;
    }

    public GitHelper init(String username, String password) {
        this.run.git("init", this.workDir.getPath());
        this.commit(new FutureCommit.Builder().build());
        this.addRemote("origin", username, password, this.project, this.repo);
        return this;
    }

    public GitHelper push() {
        return this.push("origin");
    }

    public GitHelper push(String remote) {
        this.run.git("push", remote, "--all");
        return this;
    }

    private static String getCloneUrl(String username, String password, String projectKey, String repoSlug) {
        try {
            URI url = new URI(DefaultFuncTestData.getBaseURL() + "/scm/" + projectKey + "/" + repoSlug);
            return new URI(url.getScheme(), username + ":" + password, url.getHost(), url.getPort(), url.getPath(), url.getQuery(), url.getFragment()).toASCIIString();
        }
        catch (URISyntaxException uRISyntaxException) {
            return "";
        }
    }

    public static class FutureCommit {
        private final String author;
        private final String username;
        private final String email;
        private final String message;
        private final Map<String, String> fileNameContent;
        private final List<String> filesToDelete;

        private FutureCommit(Builder builder) {
            this.author = builder.author;
            this.username = builder.username;
            this.email = builder.email;
            this.message = builder.message;
            this.fileNameContent = builder.fileNameContentBuilder.build();
            this.filesToDelete = builder.fileNameDeleteBuilder.build();
        }

        public static class Builder {
            private final ImmutableMap.Builder<String, String> fileNameContentBuilder = new ImmutableMap.Builder();
            private final ImmutableList.Builder<String> fileNameDeleteBuilder = new ImmutableList.Builder();
            private String author;
            private String username;
            private String email;
            private String message = "Initial commit";

            public Builder author(String username, String email) {
                this.author = username + "<" + email + ">";
                this.username = username;
                this.email = email;
                return this;
            }

            public Builder deleteFile(String value) {
                this.fileNameDeleteBuilder.add((Object)value);
                return this;
            }

            public Builder message(String value) {
                this.message = value;
                return this;
            }

            public Builder file(String path, String content) {
                this.fileNameContentBuilder.put((Object)path, (Object)content);
                return this;
            }

            public FutureCommit build() {
                return new FutureCommit(this);
            }
        }
    }
}

