/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test.filters;

import com.atlassian.bitbucket.test.ClusterUtils;
import com.atlassian.bitbucket.test.DefaultFuncTestData;
import com.atlassian.bitbucket.test.ProductTopology;
import com.atlassian.bitbucket.test.ProductTopologyAdapter;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.google.common.collect.Sets;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.ws.rs.core.Response;
import org.hamcrest.Matchers;

public class NodeVersionResolver
extends ProductTopologyAdapter<Set<String>> {
    private Set<String> versions;

    public Optional<String> getLowerVersion() {
        return this.getNodeVersions().stream().min(Comparator.naturalOrder());
    }

    public boolean isMixedMode() {
        return this.getNodeVersions().stream().distinct().count() > 1L;
    }

    @Override
    public Set<String> visitStashClusterPair() {
        return ClusterUtils.executeOnEachNode(DefaultFuncTestData.getRestURL(), this::getVersion);
    }

    @Override
    protected Set<String> visitDefault() {
        return Sets.newHashSet((Object[])new String[]{this.getVersion(DefaultFuncTestData.getRestURL())});
    }

    private Set<String> getNodeVersions() {
        if (this.versions == null) {
            this.versions = (Set)ProductTopology.get().accept(this).stream().filter(Objects::nonNull).collect(MoreCollectors.toImmutableSet());
        }
        return this.versions;
    }

    private String getVersion(String restURL) {
        try {
            return (String)((Response)RestAssured.given().accept(ContentType.JSON).expect().statusCode(Response.Status.OK.getStatusCode()).body("version", Matchers.notNullValue(), new Object[0]).when().get(restURL + "/application-properties", new Object[0])).path("version", new String[0]);
        }
        catch (Throwable e) {
            return null;
        }
    }
}

