/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test;

import com.atlassian.bitbucket.test.DefaultFuncTestData;
import com.google.common.collect.ImmutableMap;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.specification.RequestSpecification;
import io.restassured.specification.ResponseSpecification;
import java.util.Map;

public class SystemSigningTestHelper {
    private final String configurationUrl;

    public SystemSigningTestHelper() {
        String baseUrl = DefaultFuncTestData.getRestURL() + "/system-signing";
        this.configurationUrl = baseUrl + "/configuration";
    }

    public RequestSpecification confgurationRequest(String user, String password, int expectedStatusCode, Map<String, Object> requestBody) {
        RequestSpecification request = ((ResponseSpecification)RestAssured.expect().statusCode(expectedStatusCode).log().ifValidationFails()).given().auth().preemptive().basic(user, password).contentType("application/json").when();
        if (requestBody != null) {
            request.body(requestBody);
        }
        return request;
    }

    public void disableSystemSigning() {
        this.toggleEnabled(false, DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword(), 200);
    }

    public void enableSystemSigning() {
        this.toggleEnabled(true, DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword(), 200);
    }

    public Response getConfiguration(String user, String password, int expectedStatusCode) {
        RequestSpecification requestSpecification = ((ResponseSpecification)RestAssured.expect().statusCode(expectedStatusCode).log().ifValidationFails()).given().contentType("application/json").when();
        if (user == null) {
            requestSpecification.auth().none();
        } else {
            requestSpecification.auth().preemptive().basic(user, password);
        }
        return (Response)requestSpecification.get(this.configurationUrl, new Object[0]);
    }

    public boolean isSigningEnabled() {
        return this.getConfiguration(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword(), 200).getBody().jsonPath().getBoolean("enabled");
    }

    public Response toggleEnabled(boolean enabled, String user, String password, int expectedStatusCode) {
        return this.updateConfiguration(user, password, expectedStatusCode, (Map<String, Object>)ImmutableMap.of((Object)"enabled", (Object)enabled));
    }

    public Response updateConfiguration(String user, String password, int expectedStatusCode, Map<String, Object> requestBody) {
        RequestSpecification requestSpecification = ((ResponseSpecification)RestAssured.expect().statusCode(expectedStatusCode).log().ifValidationFails()).given().contentType("application/json").when().body(requestBody);
        if (user == null) {
            requestSpecification.auth().none();
        } else {
            requestSpecification.auth().preemptive().basic(user, password);
        }
        return (Response)requestSpecification.post(this.configurationUrl, new Object[0]);
    }
}

