/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test;

import com.atlassian.bitbucket.async.AsyncTestUtils;
import com.atlassian.bitbucket.async.WaitCondition;
import com.atlassian.bitbucket.rest.repository.RestBranch;
import com.atlassian.bitbucket.test.DefaultFuncTestData;
import com.atlassian.bitbucket.test.GitTestHelper;
import com.atlassian.bitbucket.test.ProcessTestHelper;
import com.atlassian.bitbucket.test.ProductTopology;
import com.atlassian.bitbucket.test.ProjectTestHelper;
import com.atlassian.bitbucket.test.RestTestHelper;
import com.atlassian.bitbucket.test.StatusCodesTestHelper;
import com.atlassian.bitbucket.test.StringProcessHandler;
import com.atlassian.bitbucket.util.FileUtils;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import de.schlichtherle.truezip.file.TArchiveDetector;
import de.schlichtherle.truezip.file.TFile;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.ws.rs.core.Response;
import net.sf.json.JSONObject;
import org.apache.http.client.utils.URIBuilder;
import org.hamcrest.Description;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.rules.TemporaryFolder;
import org.springframework.core.io.Resource;

public final class RepositoryTestHelper {
    public static final String CODEOWNERS_REPOSITORY = "git/codeowners.zip";
    public static final String DEFAULT_REPOSITORY = "git/default-repository.zip";
    public static final String MERGE_COMMITS_REPOSITORY = "git/merge-commits.zip";
    public static final String MERGE_REPOSITORY = "git/merge.zip";
    public static final String PULL_REQUEST_REPOSITORY = "git/pull-requests.zip";
    public static final String QA_RESOURCES_REPOSITORY = "git/qa-resources.zip";
    public static final String SECRETS_REPOSITORY = "git/secrets.zip";
    public static final String SUBMODULE_REPOSITORY = "git/subrepositories.zip";
    public static final long DEFAULT_REPO_OPERATION_MAX_WAIT = 2500L;
    public static final long DEFAULT_CLUSTER_REPO_OPERATION_MAX_WAIT = 20000L;
    public static final String ENV_AUTHOR_DATE = "GIT_AUTHOR_DATE";
    public static final String ENV_AUTHOR_EMAIL = "GIT_AUTHOR_EMAIL";
    public static final String ENV_AUTHOR_NAME = "GIT_AUTHOR_NAME";
    public static final String ENV_COMMITTER_DATE = "GIT_COMMITTER_DATE";
    public static final String ENV_COMMITTER_EMAIL = "GIT_COMMITTER_EMAIL";
    public static final String ENV_COMMITTER_NAME = "GIT_COMMITTER_NAME";

    private RepositoryTestHelper() {
        throw new UnsupportedOperationException("Static utility class - not for instantiation");
    }

    public static void cloneRepo(String user, String password, String project, String repository, String branch, File repoDir) throws URISyntaxException {
        RepositoryTestHelper.cloneRepo(DefaultFuncTestData.getBaseURL(), user, password, project, repository, branch, repoDir);
    }

    public static void cloneRepo(String baseUrl, String user, String password, String project, String repository, String branch, File repoDir) throws URISyntaxException {
        ProcessTestHelper.execute(repoDir, GitTestHelper.getGitPath(), "clone", "--branch", branch, "--", RepositoryTestHelper.getAuthenticatedRepositoryUrl(user, password, baseUrl, project, repository), ".");
    }

    public static String commitWithoutParent(String fileContent, String fileName, String ref, File repoDir, Map<String, String> env) {
        String blob = ProcessTestHelper.execute(repoDir, env, StringProcessHandler.StdIn.fromString(fileContent), GitTestHelper.getGitPath(), "hash-object", "-w", "--stdin").getStdOut();
        ProcessTestHelper.execute(repoDir, env, GitTestHelper.getGitPath(), "update-index", "--add", "--cacheinfo", "100644", blob, fileName);
        String tree = ProcessTestHelper.execute(repoDir, env, GitTestHelper.getGitPath(), "write-tree").getStdOut();
        String commit = ProcessTestHelper.execute(repoDir, env, GitTestHelper.getGitPath(), "commit-tree", tree, "-m", "commit '" + fileName + "'").getStdOut();
        ProcessTestHelper.execute(repoDir, env, GitTestHelper.getGitPath(), "update-ref", ref, commit);
        return commit;
    }

    public static void copyZipFile(File source, File destination) throws IOException {
        TFile.cp_r((File)new TFile(source), (File)destination, (TArchiveDetector)TArchiveDetector.ALL);
    }

    public static long getSize(String projectKey, String repositorySlug) {
        Response response = (Response)RestAssured.given().contentType(ContentType.JSON).accept(ContentType.JSON).auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).expect().body("repository", Matchers.notNullValue(), new Object[0]).statusCode(Response.Status.OK.getStatusCode()).when().get(DefaultFuncTestData.getRepositoryURL(projectKey, repositorySlug) + "/sizes", new Object[0]);
        return response.body().jsonPath().getLong("repository");
    }

    public static boolean isRepoOnSharedHome(String projectKey, String repositorySlug) {
        return RepositoryTestHelper.getRepository(projectKey, repositorySlug).jsonPath().get("partition") == null;
    }

    public static void mergeBranch(String baseUrl, String user, String password, String project, String repository, String commitAuthorName, String commitAuthorEmail, String currentBranch, String mergeBranch) throws IOException, URISyntaxException {
        try (WorkFolder workFolder = new WorkFolder();){
            File repDir = workFolder.getRoot();
            RepositoryTestHelper.cloneRepo(baseUrl, user, password, project, repository, currentBranch, repDir);
            ImmutableMap<String, String> env = RepositoryTestHelper.createCommitterEnv(commitAuthorName, commitAuthorEmail);
            ProcessTestHelper.execute(repDir, env, new String[]{GitTestHelper.getGitPath(), "merge", "origin/" + mergeBranch, "--no-edit", "--no-ff"});
            ProcessTestHelper.execute(repDir, GitTestHelper.getGitPath(), "push", "origin");
        }
    }

    public static void pushRep(TemporaryFolder temporaryFolder, String baseUrl, String user, String password, String project, String repository, Resource repoZipResource) throws IOException, URISyntaxException {
        RepositoryTestHelper.pushRep(temporaryFolder, baseUrl, user, password, project, repository, repoZipResource, (Function<? super ProcessTestHelper, Object>)Functions.constant(null));
    }

    public static void pushRep(TemporaryFolder temporaryFolder, String baseUrl, String user, String password, String project, String repository, Resource repoZipResource, Function<? super ProcessTestHelper, Object> callback) throws IOException, URISyntaxException {
        File repDir = temporaryFolder.newFolder();
        RepositoryTestHelper.copyZipFile(repoZipResource.getFile(), repDir);
        callback.apply((Object)new ProcessTestHelper(repDir));
        RepositoryTestHelper.pushRep(repDir, baseUrl, user, password, project, repository);
    }

    public static void pushEmptyRep(String baseUrl, String user, String password, String project, String repository) throws IOException, URISyntaxException {
        try (WorkFolder workFolder = new WorkFolder();){
            File repDir = workFolder.getRoot();
            ProcessTestHelper.execute(repDir, GitTestHelper.getGitPath(), "init");
            RepositoryTestHelper.pushRep(repDir, baseUrl, user, password, project, repository);
        }
    }

    public static void pushRep(File repDir, String baseUrl, String user, String password, String project, String repository) throws URISyntaxException {
        ProcessTestHelper.execute(repDir, GitTestHelper.getGitPath(), "remote", "add", "origin", RepositoryTestHelper.getAuthenticatedRepositoryUrl(user, password, baseUrl, project, repository));
        ProcessTestHelper.execute(repDir, GitTestHelper.getGitPath(), "push", "-f", "origin", "refs/heads/*:refs/heads/*", "refs/tags/*:refs/tags/*");
    }

    public static String pushCommit(String baseUrl, String user, String password, String project, String repository, String branch, String commitAuthorName, String commitAuthorEmail, String pathName, String filename, String content, String message) throws IOException, URISyntaxException {
        return RepositoryTestHelper.pushCommits(baseUrl, user, password, project, repository, branch, commitAuthorName, commitAuthorEmail, pathName, filename, content, message, 1);
    }

    public static String pushCommits(String baseUrl, String user, String password, String project, String repository, String branch, String commitAuthorName, String commitAuthorEmail, String pathName, String filename, String content, String message, int count) throws IOException, URISyntaxException {
        return RepositoryTestHelper.pushCommits(baseUrl, user, password, project, repository, branch, commitAuthorName, commitAuthorEmail, pathName, filename, content, message, count, 1);
    }

    public static String pushCommits(String baseUrl, String user, String password, String project, String repository, String branch, String commitAuthorName, String commitAuthorEmail, String pathName, String filename, String content, String message, int count, int filesPerCommit) throws IOException, URISyntaxException {
        return RepositoryTestHelper.pushCommits(baseUrl, user, password, project, repository, branch, commitAuthorName, commitAuthorEmail, commitAuthorName, commitAuthorEmail, pathName, filename, content, message, count, filesPerCommit);
    }

    public static String pushCommits(String baseUrl, String user, String password, String project, String repository, String branch, String commitCommitterName, String commitCommitterEmail, String commitAuthorName, String commitAuthorEmail, String pathName, String filename, String content, String message, int count, int filesPerCommit) throws IOException, URISyntaxException {
        try (WorkFolder workFolder = new WorkFolder();){
            File repDir = workFolder.getRoot();
            RepositoryTestHelper.cloneRepo(baseUrl, user, password, project, repository, branch, repDir);
            for (int i = 0; i < count; ++i) {
                for (int j = i; j < filesPerCommit + i; ++j) {
                    File newFileDir = FileUtils.construct((File)repDir, (String[])pathName.split("/"));
                    FileUtils.mkdir((File)newFileDir);
                    File tempFile = new File(newFileDir, RepositoryTestHelper.appendIndex(filename, j, count));
                    Files.asCharSink((File)tempFile, (Charset)StandardCharsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)RepositoryTestHelper.appendIndex(content, i, count));
                    ProcessTestHelper.execute(repDir, GitTestHelper.getGitPath(), "add", tempFile.getCanonicalPath());
                }
                ImmutableMap<String, String> env = RepositoryTestHelper.createCommitterEnv(commitCommitterName, commitCommitterEmail, commitAuthorName, commitAuthorEmail);
                ProcessTestHelper.execute(repDir, env, new String[]{GitTestHelper.getGitPath(), "commit", "-m", RepositoryTestHelper.appendIndex(message, i, count)});
            }
            ProcessTestHelper.execute(repDir, GitTestHelper.getGitPath(), "push", "origin");
            String string = ProcessTestHelper.execute(repDir, GitTestHelper.getGitPath(), "rev-parse", "HEAD").getStdOut().trim();
            return string;
        }
    }

    public static String pushCommits(String baseUrl, String stashUser, String stashPassword, String project, String repository, String branch, List<String> commitAuthorName, List<String> commitAuthorEmail, List<String> pathName, List<String> filename, List<String> content, List<String> message) throws IOException, URISyntaxException {
        try (WorkFolder workFolder = new WorkFolder();){
            File repDir = workFolder.getRoot();
            RepositoryTestHelper.cloneRepo(baseUrl, stashUser, stashPassword, project, repository, branch, repDir);
            int count = commitAuthorName.size();
            for (int i = 0; i < count; ++i) {
                File newFileDir = FileUtils.construct((File)repDir, (String[])pathName.get(i).split("/"));
                FileUtils.mkdir((File)newFileDir);
                File tempFile = new File(newFileDir, filename.get(i));
                Files.asCharSink((File)tempFile, (Charset)StandardCharsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)content.get(i));
                ProcessTestHelper.execute(repDir, GitTestHelper.getGitPath(), "add", tempFile.getCanonicalPath());
                ImmutableMap env = ImmutableMap.of((Object)ENV_AUTHOR_EMAIL, (Object)commitAuthorEmail.get(i), (Object)ENV_AUTHOR_NAME, (Object)commitAuthorName.get(i), (Object)ENV_COMMITTER_EMAIL, (Object)commitAuthorEmail.get(i), (Object)ENV_COMMITTER_NAME, (Object)commitAuthorName.get(i));
                ProcessTestHelper.execute(repDir, (Map<String, String>)env, GitTestHelper.getGitPath(), "commit", "-m", message.get(i));
            }
            ProcessTestHelper.execute(repDir, GitTestHelper.getGitPath(), "push", "origin");
            String string = ProcessTestHelper.execute(repDir, GitTestHelper.getGitPath(), "rev-parse", "HEAD").getStdOut().trim();
            return string;
        }
    }

    public static void resetBranch(String baseUrl, String user, String password, String project, String repository, String branch, int numberOfCommits) throws IOException, URISyntaxException {
        try (WorkFolder workFolder = new WorkFolder();){
            File repDir = workFolder.getRoot();
            RepositoryTestHelper.cloneRepo(baseUrl, user, password, project, repository, branch, repDir);
            ProcessTestHelper.execute(repDir, GitTestHelper.getGitPath(), "reset", "--hard", "HEAD~" + numberOfCommits);
            ProcessTestHelper.execute(repDir, GitTestHelper.getGitPath(), "push", "origin", "-f");
        }
    }

    public static void resetBranchAndPushCommit(String baseUrl, String user, String password, String project, String repository, String branch, String commitAuthorName, String commitAuthorEmail, String pathName, String filename, String content, String message, int numberOfCommits) throws IOException, URISyntaxException {
        try (WorkFolder workFolder = new WorkFolder();){
            File repDir = workFolder.getRoot();
            RepositoryTestHelper.cloneRepo(baseUrl, user, password, project, repository, branch, repDir);
            ProcessTestHelper.execute(repDir, GitTestHelper.getGitPath(), "reset", "--hard", "HEAD~" + numberOfCommits);
            RepositoryTestHelper.pushCommit(baseUrl, user, password, project, repository, branch, commitAuthorName, commitAuthorEmail, pathName, filename, content, message);
            ProcessTestHelper.execute(repDir, GitTestHelper.getGitPath(), "push", "origin", "-f");
        }
    }

    public static String getSlugFromResponse(Response response) {
        return (String)response.getBody().jsonPath().get("slug");
    }

    public static <T> T getIdFromResponse(Response response) {
        return (T)response.getBody().jsonPath().get("id");
    }

    public static <T> T getNameFromResponse(Response response) {
        return (T)response.getBody().jsonPath().get("name");
    }

    public static String getProjectKeyFromResponse(Response response) {
        return (String)response.getBody().jsonPath().get("project.key");
    }

    public static String getProjectNameFromResponse(Response response) {
        return (String)response.getBody().jsonPath().get("project.name");
    }

    public static Response getRepository(String projectKey, String repositorySlug) {
        return RepositoryTestHelper.getRepository(projectKey, repositorySlug, DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword());
    }

    public static Response getRepository(String projectKey, String repositorySlug, String username, String password) {
        return RepositoryTestHelper.getRepository("/projects/" + projectKey + "/repos/" + repositorySlug, username, password);
    }

    public static Response getRepository(String repoPath) {
        return RepositoryTestHelper.getRepository(repoPath, DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword());
    }

    public static Response getRepository(String repoPath, String username, String password) {
        return (Response)RestAssured.given().auth().preemptive().basic(username, password).when().get(DefaultFuncTestData.getRestURL() + repoPath, new Object[0]);
    }

    public static Response createRepository(String projectKey, String repositoryName) {
        return RepositoryTestHelper.createRepositoryAtPath("/projects/" + projectKey + "/repos/", RepositoryTestHelper.createRepositoryBody(repositoryName));
    }

    public static Response createRepositoryAtPath(String projectPath, JSONObject bodyObject) {
        return (Response)RestAssured.given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).body((Object)bodyObject).contentType("application/json").expect().statusCode(Response.Status.CREATED.getStatusCode()).log().ifError().when().post(DefaultFuncTestData.getRestURL() + projectPath, new Object[0]);
    }

    public static Response createRepositoryAndWait(String projectKey, String repositoryName) {
        return RepositoryTestHelper.createRepositoryAndWait(projectKey, repositoryName, RepositoryTestHelper.getRepoOperationTimeout());
    }

    public static Response createPersonalRepositoryAndWait(String userSlug, String repositoryName, long maxWaitTime) {
        return RepositoryTestHelper.createRepositoryAtPathAndWait("/users/" + userSlug, maxWaitTime, RepositoryTestHelper.createRepositoryBody(repositoryName));
    }

    public static Response createRepositoryAndWait(String projectKey, String repositoryName, long maxWaitTime) {
        return RepositoryTestHelper.createRepositoryAndWait(projectKey, maxWaitTime, RepositoryTestHelper.createRepositoryBody(repositoryName));
    }

    public static Response createRepositoryAndWait(String projectKey, long maxWaitTime, JSONObject repositoryBody) {
        return RepositoryTestHelper.createRepositoryAtPathAndWait("/projects/" + projectKey, maxWaitTime, repositoryBody);
    }

    public static Response createRepositoryAtPathAndWait(final String projectPath, final long maxWaitTime, JSONObject repositoryBody) {
        Response response = RepositoryTestHelper.createRepositoryAtPath(projectPath + "/repos/", repositoryBody);
        final String repositorySlug = response.jsonPath().getString("slug");
        AsyncTestUtils.waitFor((WaitCondition)new WaitCondition(){

            public boolean test() {
                Response response = RepositoryTestHelper.getRepository(projectPath + "/repos/" + repositorySlug);
                if (response.getStatusCode() == 200) {
                    String repoState = (String)JsonPath.from((String)response.asString()).get("state");
                    return !"Initialising".endsWith(repoState);
                }
                return false;
            }

            public void describeFailure(Description description) {
                description.appendText("The repository did not become available within ").appendValue((Object)maxWaitTime).appendText(" milliseconds");
            }
        }, (long)maxWaitTime);
        return response;
    }

    public static JSONObject createRepositoryBody(String repositoryName) {
        return RepositoryTestHelper.createRepositoryBodyWithDescription(repositoryName, null);
    }

    public static JSONObject createRepositoryBodyWithDescription(String repositoryName, String description) {
        JSONObject bodyObject = new JSONObject();
        if (repositoryName != null) {
            bodyObject.put((Object)"name", (Object)repositoryName);
        }
        if (description != null) {
            bodyObject.put((Object)"description", (Object)description);
        }
        bodyObject.put((Object)"scmId", (Object)"git");
        return bodyObject;
    }

    public static JSONObject createRepositoryBody(@Nonnull String projectKey, @Nonnull String repoSlug) {
        JSONObject bodyObject = new JSONObject();
        bodyObject.put((Object)"project", (Object)ProjectTestHelper.createProjectBody(projectKey));
        bodyObject.put((Object)"slug", (Object)repoSlug);
        return bodyObject;
    }

    public static Response deletePersonalRepository(String repositorySlug, String username, String password) {
        return (Response)RestAssured.given().auth().preemptive().basic(username, password).when().delete(DefaultFuncTestData.getRestURL() + "/projects/~" + username + "/repos/" + repositorySlug, new Object[0]);
    }

    public static void deletePersonalRepositoryAndWait(String repositorySlug, String username) {
        RepositoryTestHelper.deleteRepositoryAndWait("~" + username, repositorySlug);
    }

    public static Response deleteRepository(int repoId) {
        return (Response)RestAssured.given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).when().delete(DefaultFuncTestData.getRestURL("repo-tests-support", "latest") + "/repos/" + repoId, new Object[0]);
    }

    public static Response deleteRepository(String projectKey, String repositorySlug) {
        return (Response)RestAssured.given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).when().delete(DefaultFuncTestData.getRestURL() + "/projects/" + projectKey + "/repos/" + repositorySlug, new Object[0]);
    }

    public static void deleteRepositoryAndWait(final int repoId, long maxWaitTime) {
        Response response = RepositoryTestHelper.deleteRepository(repoId);
        if (response.getStatusCode() != 202 && response.getStatusCode() != 204) {
            Assert.fail((String)("Repository with ID " + repoId + " could not be deleted; the delete request failed. statusCode = " + response.getStatusCode() + " body = " + response.prettyPrint()));
        }
        final String url = DefaultFuncTestData.getRestURL("repo-tests-support", "latest") + "/repos/" + repoId;
        AsyncTestUtils.waitFor((WaitCondition)new WaitCondition(){

            public void describeFailure(Description description) {
                description.appendText("Repository with ID " + repoId + " was not deleted");
            }

            public boolean test() {
                Response response = (Response)RestAssured.given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).when().get(url, new Object[0]);
                return response.getStatusCode() == 404;
            }
        }, (long)maxWaitTime);
    }

    public static void deleteRepositoryAndWait(String projectKey, String repositorySlug) {
        RepositoryTestHelper.deleteRepositoryAndWait(projectKey, repositorySlug, RepositoryTestHelper.getRepoOperationTimeout());
    }

    public static void deleteRepositoryAndWait(final String projectKey, final String repositorySlug, long maxWaitTime) {
        Response response = RepositoryTestHelper.deleteRepository(projectKey, repositorySlug);
        if (response.getStatusCode() != 202 && response.getStatusCode() != 204) {
            Assert.fail((String)(projectKey + "/" + repositorySlug + " could not be deleted; the delete request failed. statusCode = " + response.getStatusCode() + " body = " + response.prettyPrint()));
        }
        final String url = DefaultFuncTestData.getRestURL() + "/projects/" + projectKey + "/repos/" + repositorySlug;
        AsyncTestUtils.waitFor((WaitCondition)new WaitCondition(){

            public void describeFailure(Description description) {
                description.appendText(projectKey + "/" + repositorySlug + " was not deleted");
            }

            public boolean test() {
                Response response = (Response)RestAssured.given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).when().get(url, new Object[0]);
                return response.getStatusCode() == 404;
            }
        }, (long)maxWaitTime);
    }

    public static List<RestBranch> getBranches(String projectKey, String repositorySlug, int pageSize) {
        return (List)((Response)RestAssured.given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).expect().statusCode(Response.Status.OK.getStatusCode()).when().get(DefaultFuncTestData.getRestURL() + "/projects/" + projectKey + "/repos/" + repositorySlug + "/branches?limit=" + pageSize, new Object[0])).jsonPath().get("values");
    }

    public static Response getRepositorySettings(String projectKey, String repositorySlug) {
        return (Response)RestAssured.given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).expect().statusCode(Response.Status.OK.getStatusCode()).when().get(DefaultFuncTestData.getRestURL() + "/projects/" + projectKey + "/repos/" + repositorySlug + "/settings/pull-requests", new Object[0]);
    }

    public static boolean hasBranch(String projectKey, String repositorySlug, String branch) {
        Response response = (Response)RestAssured.given().queryParam("start", new Object[]{0}).queryParam("limit", new Object[]{100}).queryParam("filterText", new Object[]{branch}).auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).when().get(DefaultFuncTestData.getRestURL() + "/projects/" + projectKey + "/repos/" + repositorySlug + "/branches", new Object[0]);
        return RestTestHelper.hasValue(response, "displayId", branch, true);
    }

    public static boolean hasTag(String projectKey, String repositorySlug, String tag) {
        Response response = (Response)RestAssured.given().queryParam("start", new Object[]{0}).queryParam("limit", new Object[]{100}).queryParam("filterText", new Object[]{tag}).auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).when().get(DefaultFuncTestData.getRestURL() + "/projects/" + projectKey + "/repos/" + repositorySlug + "/tags", new Object[0]);
        return RestTestHelper.hasValue(response, "displayId", tag, true);
    }

    public static String getDefaultBranchId(String projectKey, String repositorySlug) {
        return (String)((ValidatableResponse)((Response)RestAssured.given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).when().get(DefaultFuncTestData.getRestURL() + "/projects/" + projectKey + "/repos/" + repositorySlug + "/branches/default", new Object[0])).then()).extract().path("id", new String[0]);
    }

    public static void setDefaultBranch(String projectKey, String repositorySlug, String defaultBranchId) {
        RestAssured.given().contentType("application/json").body("{\"id\": \"" + defaultBranchId + "\"}").auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).when().put(DefaultFuncTestData.getRestURL() + "/projects/" + projectKey + "/repos/" + repositorySlug + "/branches/default", new Object[0]);
    }

    public static Response forkRepositoryAndWait(String projectKey, String repositoryName, String username, String password, long maxWaitTime) {
        String sourceRepoUrl = DefaultFuncTestData.getRestURL() + "/projects/" + projectKey + "/repos/" + repositoryName;
        Response response = (Response)RestAssured.expect().statusCode(201).log().ifError().given().contentType("application/json").body("{}").auth().preemptive().basic(username, password).when().post(sourceRepoUrl, new Object[0]);
        String forkedRepoUrl = DefaultFuncTestData.getRestURL() + "/projects/~" + username + "/repos/" + repositoryName;
        RepositoryTestHelper.waitForFork(forkedRepoUrl, maxWaitTime, username, password);
        return response;
    }

    public static Response forkNonPersonalRepositoryAndWait(String projectKey, String repoKey, String destProjectKey, String destRepoKey, long maxWaitTimeMs) {
        String sourceRepoUrl = DefaultFuncTestData.getRestURL() + "/projects/" + projectKey + "/repos/" + repoKey;
        RestAssured.enableLoggingOfRequestAndResponseIfValidationFails();
        Response response = (Response)RestAssured.expect().statusCode(201).log().ifError().given().contentType("application/json").body("{\"slug\":\"" + destRepoKey + "\",\"name\":\"" + destRepoKey + "\",\"project\":{\"key\":\"" + destProjectKey + "\"}}").auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).when().post(sourceRepoUrl, new Object[0]);
        String forkedRepoUrl = DefaultFuncTestData.getRestURL() + "/projects/" + destProjectKey + "/repos/" + destRepoKey;
        RepositoryTestHelper.waitForFork(forkedRepoUrl, maxWaitTimeMs, DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword());
        return response;
    }

    public static Response moveRepositoryToDifferentProject(String originalProjectKey, String repositorySlug, String newProjectKey) {
        return RepositoryTestHelper.updateRepository(originalProjectKey, repositorySlug, "{\"project\": { \"key\": \"" + newProjectKey + "\" } }");
    }

    public static void setRepositoryReadOnly(String projectKey, String repositorySlug, boolean readOnly) {
        String url = DefaultFuncTestData.getRestURL("repo-tests-support", "latest") + "/read-only/projects/" + projectKey + "/repos/" + repositorySlug + "/enabled";
        if (readOnly) {
            ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).when().put(url, new Object[0])).then()).statusCode(Response.Status.NO_CONTENT.getStatusCode())).log().ifValidationFails();
        } else {
            ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).when().delete(url, new Object[0])).then()).statusCode(Response.Status.NO_CONTENT.getStatusCode())).log().ifValidationFails();
        }
    }

    private static void waitForFork(final String forkedRepoUrl, final long maxWaitTimeMs, final String username, final String password) {
        AsyncTestUtils.waitFor((WaitCondition)new WaitCondition(){

            public boolean test() {
                Response response = (Response)RestAssured.given().auth().preemptive().basic(username, password).when().get(forkedRepoUrl, new Object[0]);
                if (response.getStatusCode() == 200) {
                    String repoState = (String)JsonPath.from((String)response.asString()).get("state");
                    return !"Initialising".endsWith(repoState);
                }
                return false;
            }

            public void describeFailure(Description description) {
                description.appendText("The forked repository did not become available within ").appendValue((Object)maxWaitTimeMs).appendText(" milliseconds");
            }
        }, (long)maxWaitTimeMs);
    }

    public static Response updateRepository(String projectKey, String repositorySlug, String body) {
        return (Response)RestAssured.given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).body(body).contentType("application/json").expect().statusCode(StatusCodesTestHelper.matching(Response.Status.OK, Response.Status.CREATED)).when().put(DefaultFuncTestData.getRestURL() + "/projects/" + projectKey + "/repos/" + repositorySlug, new Object[0]);
    }

    public static Response updateRepositoryName(String projectKey, String repositorySlug, String newRepositoryName) {
        return RepositoryTestHelper.updateRepository(projectKey, repositorySlug, "{\"name\": \"" + newRepositoryName + "\"}");
    }

    public static Response setForkable(String projectKey, String repositorySlug, boolean forkable) {
        return RepositoryTestHelper.updateRepository(projectKey, repositorySlug, "{ \"forkable\" : \"" + forkable + "\" }");
    }

    public static Response setRepositoryArchived(String projectKey, String repositorySlug, boolean archived) {
        return RepositoryTestHelper.updateRepository(projectKey, repositorySlug, "{\"archived\": \"" + archived + "\"}");
    }

    public static Response setRepositoryPublicAccessEnabled(String projectKey, String repositorySlug, boolean enabled) {
        return RepositoryTestHelper.updateRepository(projectKey, repositorySlug, "{ \"public\" : \"" + enabled + "\" }");
    }

    public static Response setRepositorySettings(String projectKey, String repositorySlug, String settings) {
        return (Response)RestAssured.given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).body(settings).contentType(ContentType.JSON).expect().statusCode(Response.Status.OK.getStatusCode()).when().post(DefaultFuncTestData.getRestURL() + "/projects/" + projectKey + "/repos/" + repositorySlug + "/settings/pull-requests", new Object[0]);
    }

    private static String appendIndex(String content, int i, int count) {
        if (count == 1) {
            return content;
        }
        return content + '_' + i;
    }

    private static ImmutableMap<String, String> createCommitterEnv(String commitAuthorName, String commitAuthorEmail) {
        return ImmutableMap.builder().put((Object)ENV_COMMITTER_DATE, (Object)"1659139200").put((Object)ENV_AUTHOR_DATE, (Object)"1659139200").put((Object)ENV_AUTHOR_EMAIL, (Object)commitAuthorEmail).put((Object)ENV_AUTHOR_NAME, (Object)commitAuthorName).put((Object)ENV_COMMITTER_EMAIL, (Object)commitAuthorEmail).put((Object)ENV_COMMITTER_NAME, (Object)commitAuthorName).build();
    }

    private static ImmutableMap<String, String> createCommitterEnv(String commitCommitterName, String commitCommitterEmail, String commitAuthorName, String commitAuthorEmail) {
        return ImmutableMap.builder().put((Object)ENV_COMMITTER_DATE, (Object)"1659139200").put((Object)ENV_AUTHOR_DATE, (Object)"1659139200").put((Object)ENV_AUTHOR_EMAIL, (Object)commitAuthorEmail).put((Object)ENV_AUTHOR_NAME, (Object)commitAuthorName).put((Object)ENV_COMMITTER_EMAIL, (Object)commitCommitterEmail).put((Object)ENV_COMMITTER_NAME, (Object)commitCommitterName).build();
    }

    private static String getAuthenticatedRepositoryUrl(String user, String password, String baseUrl, String project, String repository) throws URISyntaxException {
        return new URIBuilder(new URI(baseUrl + "/scm/" + project + "/" + repository + ".git").normalize()).setUserInfo(user, password).build().toString();
    }

    private static long getRepoOperationTimeout() {
        if (ProductTopology.get() == ProductTopology.BITBUCKET_STANDALONE) {
            return 2500L;
        }
        return 20000L;
    }

    private static class WorkFolder
    extends TemporaryFolder
    implements Closeable {
        WorkFolder() throws IOException {
            this.create();
        }

        @Override
        public void close() {
            this.delete();
        }
    }
}

