/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test;

import com.atlassian.bitbucket.async.AsyncTestUtils;
import com.atlassian.bitbucket.async.WaitCondition;
import com.atlassian.bitbucket.comment.CommentSeverity;
import com.atlassian.bitbucket.comment.CommentState;
import com.atlassian.bitbucket.comment.CommentThreadDiffAnchorType;
import com.atlassian.bitbucket.content.DiffSegmentType;
import com.atlassian.bitbucket.pull.PullRequestChangeScope;
import com.atlassian.bitbucket.pull.PullRequestEntityType;
import com.atlassian.bitbucket.pull.PullRequestParticipantStatus;
import com.atlassian.bitbucket.pull.PullRequestState;
import com.atlassian.bitbucket.test.DefaultFuncTestData;
import com.atlassian.bitbucket.test.PullRequestRestTestHelper;
import com.atlassian.bitbucket.test.RepositoryTestHelper;
import com.atlassian.bitbucket.test.rest.AbstractRestHelper;
import com.atlassian.bitbucket.test.rest.RestAuthentication;
import com.atlassian.bitbucket.test.rest.comment.RestCommentUtils;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.util.UrlUtils;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import io.restassured.RestAssured;
import io.restassured.builder.ResponseSpecBuilder;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import io.restassured.specification.ResponseSpecification;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.ws.rs.core.Response;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableLong;
import org.hamcrest.Description;
import org.hamcrest.Matchers;

public class PullRequestTestHelper
extends AbstractRestHelper {
    private final String projectKey;
    private final String repoSlug;
    private final long id;

    private PullRequestTestHelper(String username, String password, String projectKey, String repoSlug, long id) {
        super(RestAuthentication.authenticated(username, password));
        this.projectKey = projectKey;
        this.repoSlug = repoSlug;
        this.id = id;
    }

    public Response tryAutoMerge() {
        return (Response)this.request().when().post(this.getAutoMergeUrl(), new Object[0]);
    }

    public void requestAutoMerge(String user) {
        JSONObject requestBody = PullRequestTestHelper.toJsonObject("version", this.getVersion());
        requestBody.put((Object)"autoMerge", (Object)true);
        this.doRequestAutoMerge(user, requestBody);
    }

    public void requestAutoMerge(String user, String strategyId) {
        JSONObject requestBody = PullRequestTestHelper.toJsonObject("version", this.getVersion());
        requestBody.put((Object)"autoMerge", (Object)true);
        requestBody.put((Object)"strategyId", (Object)strategyId);
        this.doRequestAutoMerge(user, requestBody);
    }

    public void cancelAutoMerge(String user) {
        ((ResponseSpecification)RestAssured.given().auth().preemptive().basic(user, user).accept("application/json").expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).log().ifValidationFails()).when().delete(this.getAutoMergeUrl(), new Object[0]);
    }

    public long getId() {
        return this.id;
    }

    public String getProjectKey() {
        return this.projectKey;
    }

    public String getRepoSlug() {
        return this.repoSlug;
    }

    public JsonPath get() {
        return ((Response)this.request().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(this.getUrl(), new Object[0])).body().jsonPath();
    }

    public String getAutoMergeUrl() {
        return PullRequestTestHelper.getUrl(this.projectKey, this.repoSlug, this.id) + "/auto-merge";
    }

    public JsonPath getWithMarkup() {
        return ((Response)this.request().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(this.getUrl() + "?markup", new Object[0])).body().jsonPath();
    }

    public String getUiUrl() {
        return DefaultFuncTestData.getRestUiURL() + "/projects/" + this.projectKey + "/repos/" + this.repoSlug + "/pull-requests/" + this.id;
    }

    public String getUrl() {
        return PullRequestTestHelper.getUrl(this.projectKey, this.repoSlug, this.id);
    }

    public String getChangesUrl() {
        return this.getUrl() + "/changes";
    }

    public String getChangesUrl(PullRequestChangeScope changeScope, Boolean withComments) {
        return this.getUrl() + "/changes?" + UrlUtils.buildQueryParams((Object[])new Object[]{"changeScope", changeScope == null ? null : changeScope.toString(), "withComments", withComments});
    }

    public String getUiMergeUrl() {
        return this.getUiUrl() + "/merge";
    }

    public String getWatchUrl() {
        return this.getUrl() + "/watch";
    }

    public String getParticipantsUrl() {
        return this.getUrl() + "/participants";
    }

    public String getDeleteParticipantsUrl(String username) {
        return this.getParticipantsUrl() + "?username=" + username;
    }

    public String getUpdatePullRequestStatusUrl(String userSlug) {
        return this.getParticipantsUrl() + "/" + userSlug;
    }

    public String getDiffUrl(String path, String srcPath) {
        return this.getUrl() + "/diff" + (StringUtils.isEmpty((CharSequence)path) ? "" : "/" + path) + (StringUtils.isEmpty((CharSequence)srcPath) ? "" : "?srcPath=" + srcPath);
    }

    public String getDiffUrlWithMarkup(String path, String srcPath) {
        return this.getDiffUrl(path, srcPath) + (srcPath == null ? "?" : "&") + "markup=true";
    }

    public String getCommentsUrl() {
        return this.getUrl() + "/comments";
    }

    public String getCommentsUrlWithMarkup() {
        return this.getCommentsUrl() + "?markup=true";
    }

    public String getCommentUrl(long id, int version) {
        return this.getCommentsUrl() + "/" + id + "?version=" + version;
    }

    public String getCommentUrlWithMarkup(long id, int version) {
        return this.getCommentUrl(id, version) + "&markup=true";
    }

    public String getCommitsUrl(boolean withCounts) {
        return this.getUrl() + "/commits?withCounts=" + withCounts;
    }

    public String getDeclineUrl() {
        return PullRequestTestHelper.getDeclineUrl(this.projectKey, this.repoSlug, this.id);
    }

    public String getMergeBaseUrl() {
        return this.getUrl() + "/merge-base";
    }

    public String getMergeUrl() {
        return PullRequestTestHelper.getMergeUrl(this.projectKey, this.repoSlug, this.id);
    }

    public String getPatchUrl() {
        return PullRequestTestHelper.getPatchUrl(this.projectKey, this.repoSlug, this.id);
    }

    public String getRawDiffUrl() {
        return PullRequestTestHelper.getRawDiffUrl(this.projectKey, this.repoSlug, this.id);
    }

    public String getReopenUrl() {
        return PullRequestTestHelper.getReopenUrl(this.projectKey, this.repoSlug, this.id);
    }

    public String getActivitiesUrl() {
        return PullRequestTestHelper.getActivitiesUrl(this.projectKey, this.repoSlug, this.id);
    }

    public String getActivitiesUrlStartingAt(PullRequestEntityType fromType, long fromId, int limit) {
        return PullRequestTestHelper.getActivitiesUrlStartingAt(this.projectKey, this.repoSlug, this.id, fromType, fromId, limit);
    }

    public PullRequestState getState() {
        return PullRequestState.valueOf((String)this.get().getString("state"));
    }

    public String getDescription() {
        return this.get().getString("description");
    }

    public String getTitle() {
        return this.get().getString("title");
    }

    public List<String> getReviewers() {
        return (List)this.get().getList("reviewers", Map.class).stream().map(map -> (Map)map.get("user")).map(map -> (String)map.get("name")).collect(MoreCollectors.toImmutableList());
    }

    public int getVersion() {
        return this.get().getInt("version");
    }

    public Set<String> getAllParticipants() {
        Response response = (Response)this.request().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(this.getParticipantsUrl(), new Object[0]);
        return response.body().jsonPath().getList("values.user.displayName").stream().map(String::valueOf).collect(Collectors.toSet());
    }

    public String getReviewUrl() {
        return this.getUrl() + "/review";
    }

    public String getSourceBranchName() {
        return this.get().getString("fromRef.displayId");
    }

    public String getTargetBranchName() {
        return this.get().getString("toRef.displayId");
    }

    public String getLatestCommit() {
        return this.get().getString("fromRef.latestCommit");
    }

    public void updateTitle(String title) {
        HashMap body = (HashMap)this.get().get("");
        body.remove("author");
        body.remove("participants");
        body.put("title", title);
        this.update(JSONObject.fromObject((Object)body));
    }

    private void decline(String username, String password, int version) {
        PullRequestTestHelper.declinePullRequest(username, password, this.projectKey, this.repoSlug, this.id, version);
    }

    public void declineSafe() {
        if (this.hasState(PullRequestState.OPEN)) {
            this.decline(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword(), this.getVersion());
        }
    }

    public void delete() {
        PullRequestTestHelper.deletePullRequest(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword(), this.projectKey, this.repoSlug, this.id, this.getVersion());
    }

    public void deleteSafe() {
        if (this.hasState(PullRequestState.OPEN, PullRequestState.DECLINED)) {
            PullRequestTestHelper.deletePullRequest(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword(), this.projectKey, this.repoSlug, this.id, this.getVersion());
        }
    }

    public boolean exists() {
        return ((Response)RestAssured.given().auth().preemptive().basic(this.defaultAuthentication.getUsername(), this.defaultAuthentication.getPassword()).when().get(this.getUrl(), new Object[0])).getStatusCode() == 200;
    }

    public boolean hasState(PullRequestState ... possibleStates) {
        Response response = (Response)this.request().get(this.getUrl(), new Object[0]);
        if (response.getStatusCode() != Response.Status.OK.getStatusCode()) {
            return false;
        }
        PullRequestState state = PullRequestState.valueOf((String)response.getBody().jsonPath().getString("state"));
        return ArrayUtils.contains((Object[])possibleStates, (Object)state);
    }

    public boolean isAutoMergeRequested() {
        return ((Response)this.request().when().get(this.getAutoMergeUrl(), new Object[0])).statusCode() == Response.Status.OK.getStatusCode();
    }

    public boolean isConflicted() {
        return (Boolean)((Response)this.request().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(this.getMergeUrl(), new Object[0])).body().jsonPath().get("conflicted");
    }

    public boolean isDraft() {
        return (Boolean)((Response)this.request().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(PullRequestTestHelper.getUrl(this.projectKey, this.repoSlug) + "/" + this.id, new Object[0])).body().jsonPath().get("draft");
    }

    public void mergeSafe() {
        if (this.hasState(PullRequestState.OPEN)) {
            PullRequestTestHelper.mergePullRequest(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword(), this.projectKey, this.repoSlug, this.id, this.getVersion());
        }
    }

    public void reopenSafe() {
        if (this.hasState(PullRequestState.DECLINED)) {
            PullRequestTestHelper.reopenPullRequest(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword(), this.projectKey, this.repoSlug, this.id, this.getVersion());
        }
    }

    private void update(JSONObject body) {
        ((Response)this.request().body(body.toString()).when().put(this.getUrl(), new Object[0])).asString();
    }

    public void addReviewers(String ... usernames) {
        Map body = (Map)this.get().get("");
        List reviewers = (List)body.get("reviewers");
        Arrays.stream(usernames).map(username -> {
            JSONObject userObject = new JSONObject();
            userObject.put((Object)"name", username);
            JSONObject wrapperObject = new JSONObject();
            wrapperObject.put((Object)"user", (Object)userObject);
            return wrapperObject;
        }).forEach(reviewers::add);
        body.remove("author");
        body.remove("participants");
        this.update(JSONObject.fromObject((Object)body));
    }

    public void removeReviewers(String ... usernames) {
        Map body = (Map)this.get().get("");
        List reviewers = (List)body.get("reviewers");
        ImmutableSet usernamesToRemove = ImmutableSet.copyOf((Object[])usernames);
        Iterator it = reviewers.iterator();
        while (it.hasNext()) {
            Map reviewer = (Map)it.next();
            Map userObject = (Map)reviewer.get("user");
            if (!usernamesToRemove.contains(userObject.get("name"))) continue;
            it.remove();
        }
        body.remove("author");
        body.remove("participants");
        this.update(JSONObject.fromObject((Object)body));
    }

    public void updateDraft(boolean draft) {
        HashMap body = (HashMap)this.get().get("");
        body.remove("author");
        body.remove("participants");
        body.put("draft", draft);
        this.update(JSONObject.fromObject((Object)body));
    }

    public void updateTargetBranch(String newRefId) {
        Map body = (Map)this.get().get("");
        JSONObject refObject = new JSONObject();
        refObject.put((Object)"id", (Object)newRefId);
        body.put("toRef", refObject);
        body.remove("author");
        body.remove("participants");
        this.update(JSONObject.fromObject((Object)body));
    }

    public void setDescription(String description) {
        HashMap body = (HashMap)this.get().get("");
        body.remove("author");
        body.remove("participants");
        body.put("description", description);
        this.update(JSONObject.fromObject((Object)body));
    }

    public void setStatusFor(String username, PullRequestParticipantStatus status) {
        RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).body("user", Matchers.notNullValue(), new Object[0]).body("user.name", Matchers.equalTo((Object)username), new Object[0]).body("status", Matchers.equalTo((Object)status.name()), new Object[0]).log().ifError().given().auth().preemptive().basic(username, username).contentType("application/json").body((Object)PullRequestTestHelper.toJsonObject("status", status)).put(this.getUpdatePullRequestStatusUrl(username), new Object[0]);
    }

    public Response getMergeStatus() {
        return (Response)this.request().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(PullRequestTestHelper.getMergeUrl(this.projectKey, this.repoSlug, this.id), new Object[0]);
    }

    public List<String> getMergeVetoes() {
        JsonPath json = this.getMergeStatus().jsonPath();
        Boolean canMerge = json.getBoolean("canMerge");
        if (Boolean.TRUE.equals(canMerge)) {
            return Collections.emptyList();
        }
        List vetoes = json.getList("vetoes");
        return vetoes.stream().map(veto -> (String)veto.get("detailedMessage")).collect(Collectors.toList());
    }

    public Response addGeneralComment(String commentText) {
        return (Response)this.request().body((Object)RestCommentUtils.createBody(commentText)).expect().statusCode(Response.Status.CREATED.getStatusCode()).body("text", Matchers.equalTo((Object)commentText), new Object[0]).log().ifError().when().post(this.getCommentsUrl(), new Object[0]);
    }

    public Response addGeneralTask(String taskText, boolean resolved) {
        JSONObject body = RestCommentUtils.createBody(taskText);
        body.put((Object)"severity", (Object)CommentSeverity.BLOCKER.name());
        Response response = (Response)this.request().body((Object)body).expect().statusCode(Response.Status.CREATED.getStatusCode()).body("text", Matchers.equalTo((Object)taskText), new Object[0]).log().ifError().when().post(this.getCommentsUrl(), new Object[0]);
        if (resolved) {
            return this.resolveTask(response.jsonPath().getInt("id"), response.jsonPath().getInt("version"));
        }
        return response;
    }

    public Response addCommentReply(String commentText, long id) {
        return (Response)this.request().body((Object)RestCommentUtils.createReplyBody(commentText, id)).expect().statusCode(Response.Status.CREATED.getStatusCode()).body("text", Matchers.equalTo((Object)commentText), new Object[0]).log().ifError().when().post(this.getCommentsUrl(), new Object[0]);
    }

    public Response addCommentReplyTask(String taskText, long id, boolean resolved) {
        JSONObject body = RestCommentUtils.createReplyBody(taskText, id);
        body.put((Object)"severity", (Object)CommentSeverity.BLOCKER.name());
        Response response = (Response)this.request().body((Object)body).expect().statusCode(Response.Status.CREATED.getStatusCode()).body("text", Matchers.equalTo((Object)taskText), new Object[0]).log().ifError().when().post(this.getCommentsUrl(), new Object[0]);
        if (resolved) {
            return this.resolveTask(response.jsonPath().getInt("id"), response.jsonPath().getInt("version"));
        }
        return response;
    }

    public Response addTaskReply(String commentText, long parentId, CommentState state) {
        return (Response)this.request().body((Object)RestCommentUtils.createReplyBody(commentText, parentId, state, CommentSeverity.BLOCKER)).expect().statusCode(Response.Status.CREATED.getStatusCode()).body("text", Matchers.equalTo((Object)commentText), new Object[0]).log().ifError().when().post(this.getCommentsUrl(), new Object[0]);
    }

    public Response addCommitComment(String commitId, String commentText, String path, int line, DiffSegmentType lineType) {
        return this.addCommitComment(commitId, this.getCommitParent(commitId), commentText, path, line, lineType);
    }

    public Response addCommitComment(String commitId, String sinceId, String commentText, String path, int line, DiffSegmentType lineType) {
        JSONObject body = RestCommentUtils.createLineBody(commentText, path, null, line, lineType);
        JSONObject pullRequest = new JSONObject();
        pullRequest.put((Object)"id", (Object)this.getId());
        JSONObject anchor = body.getJSONObject("anchor");
        anchor.put((Object)"pullRequest", (Object)pullRequest);
        anchor.put((Object)"diffType", (Object)"COMMIT");
        anchor.put((Object)"fromHash", (Object)sinceId);
        anchor.put((Object)"toHash", (Object)commitId);
        return (Response)this.request().body((Object)body).expect().statusCode(Response.Status.CREATED.getStatusCode()).body("text", Matchers.equalTo((Object)commentText), new Object[0]).log().ifError().when().post(this.getCommentsUrl(), new Object[0]);
    }

    public Response addCommitFileComment(String commitId, String commentText, String path) {
        return this.addCommitFileComment(commitId, this.getCommitParent(commitId), commentText, path);
    }

    public Response addCommitFileComment(String commitId, String sinceId, String commentText, String path) {
        return this.addFileComment(commitId, sinceId, commentText, path, CommentThreadDiffAnchorType.COMMIT);
    }

    public Response addRangeFileComment(String commitId, String sinceId, String commentText, String path) {
        return this.addFileComment(commitId, sinceId, commentText, path, CommentThreadDiffAnchorType.RANGE);
    }

    public Response addFileComment(String commitId, String sinceId, String commentText, String path, CommentThreadDiffAnchorType diffType) {
        JSONObject body = RestCommentUtils.createFileBody(commentText, path, null);
        JSONObject pullRequest = new JSONObject();
        pullRequest.put((Object)"id", (Object)this.getId());
        JSONObject anchor = body.getJSONObject("anchor");
        anchor.put((Object)"pullRequest", (Object)pullRequest);
        anchor.put((Object)"diffType", (Object)diffType.name());
        anchor.put((Object)"fromHash", (Object)sinceId);
        anchor.put((Object)"toHash", (Object)commitId);
        return (Response)this.request().body((Object)body).expect().statusCode(Response.Status.CREATED.getStatusCode()).body("text", Matchers.equalTo((Object)commentText), new Object[0]).log().ifError().when().post(this.getCommentsUrl(), new Object[0]);
    }

    public Response addDiffComment(String commentText, String path, int line, DiffSegmentType lineType) {
        return (Response)this.request().body((Object)RestCommentUtils.createLineBody(commentText, path, path, line, lineType)).expect().statusCode(Response.Status.CREATED.getStatusCode()).body("text", Matchers.equalTo((Object)commentText), new Object[0]).log().ifError().when().post(this.getCommentsUrl(), new Object[0]);
    }

    public Response addCommitDiffComment(String commitId, String commentText, String path, int line, DiffSegmentType lineType) {
        return this.addCommitDiffComment(commitId, null, commentText, path, line, lineType);
    }

    public Response addCommitDiffComment(String commitId, String sinceId, String commentText, String path, int line, DiffSegmentType lineType) {
        return this.addDiffComment(commitId, sinceId, commentText, path, line, lineType, CommentThreadDiffAnchorType.COMMIT);
    }

    public Response addRangeDiffComment(String commitId, String sinceId, String commentText, String path, int line, DiffSegmentType lineType) {
        return this.addDiffComment(commitId, sinceId, commentText, path, line, lineType, CommentThreadDiffAnchorType.RANGE);
    }

    public Response addDiffComment(String commitId, String sinceId, String commentText, String path, int line, DiffSegmentType lineType, CommentThreadDiffAnchorType diffType) {
        JSONObject body = RestCommentUtils.createLineBody(commentText, path, path, line, lineType);
        JSONObject pullRequest = new JSONObject();
        pullRequest.put((Object)"id", (Object)this.getId());
        JSONObject anchor = body.getJSONObject("anchor");
        anchor.put((Object)"pullRequest", (Object)pullRequest);
        anchor.put((Object)"diffType", (Object)diffType.name());
        anchor.put((Object)"fromHash", (Object)sinceId);
        anchor.put((Object)"toHash", (Object)commitId);
        return (Response)this.request().body((Object)body).expect().statusCode(Response.Status.CREATED.getStatusCode()).body("text", Matchers.equalTo((Object)commentText), new Object[0]).log().ifError().when().post(this.getCommentsUrl(), new Object[0]);
    }

    public Response addFileComment(String commentText, String path) {
        return (Response)this.request().body((Object)RestCommentUtils.createFileBody(commentText, path, path)).expect().statusCode(Response.Status.CREATED.getStatusCode()).body("text", Matchers.equalTo((Object)commentText), new Object[0]).log().ifError().when().post(this.getCommentsUrl(), new Object[0]);
    }

    public JsonPath getActivities() {
        return ((Response)this.request().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(this.getActivitiesUrl(), new Object[0])).body().jsonPath();
    }

    public int getNumberOfComments() {
        List comments = (List)((Response)this.request().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(this.getActivitiesUrl(), new Object[0])).body().jsonPath().get("values.commentAction");
        return (int)comments.stream().filter(Objects::nonNull).count();
    }

    private Response resolveTask(long id, int version) {
        JSONObject body = new JSONObject();
        body.put((Object)"version", (Object)version);
        body.put((Object)"state", (Object)CommentState.RESOLVED.name());
        return (Response)this.request().body((Object)body).expect().statusCode(Response.Status.OK.getStatusCode()).log().ifError().when().put(this.getUrl() + "/comments/" + id, new Object[0]);
    }

    public int getNumberOfCommitsOnSourceBranch() {
        return (Integer)((ValidatableResponse)((Response)this.request().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(this.getCommitsUrl(true), new Object[0])).then()).extract().path("totalCount", new String[0]);
    }

    public void pushCommitsAndWait(int numberOfCommits, String author, String authorEmail) throws IOException, URISyntaxException {
        this.pushCommitsAndWait(numberOfCommits, 1, author, authorEmail, null);
    }

    public void pushCommitsAndWait(final int numberOfCommits, int filesPerCommit, String author, String authorEmail, String path) throws IOException, URISyntaxException {
        final int initialNumberOfCommits = this.getNumberOfCommitsOnSourceBranch();
        RepositoryTestHelper.pushCommits(DefaultFuncTestData.getBaseURL(), DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword(), this.projectKey, this.repoSlug, this.getSourceBranchName(), author, authorEmail, (String)MoreObjects.firstNonNull((Object)path, (Object)"path/to/file"), "name", "Contents" + initialNumberOfCommits, "message", numberOfCommits, filesPerCommit);
        final int maxWaitTime = 5000;
        AsyncTestUtils.waitFor((WaitCondition)new WaitCondition(){

            public void describeFailure(Description description) {
                description.appendText("The commits were not pushed to the source branch in ").appendValue((Object)maxWaitTime).appendText(" milliseconds");
            }

            public boolean test() {
                return PullRequestTestHelper.this.getNumberOfCommitsOnSourceBranch() == numberOfCommits + initialNumberOfCommits;
            }
        }, (long)maxWaitTime);
    }

    public void removeCommitsAndWait(final int numberOfCommits) throws IOException, URISyntaxException {
        final int initialNumberOfCommits = this.getNumberOfCommitsOnSourceBranch();
        RepositoryTestHelper.resetBranch(DefaultFuncTestData.getBaseURL(), DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword(), this.projectKey, this.repoSlug, this.getSourceBranchName(), numberOfCommits);
        final int maxWaitTime = 5000;
        AsyncTestUtils.waitFor((WaitCondition)new WaitCondition(){

            public void describeFailure(Description description) {
                description.appendText("The commits were not removed from the source branch in ").appendValue((Object)maxWaitTime).appendText(" milliseconds");
            }

            public boolean test() {
                return PullRequestTestHelper.this.getNumberOfCommitsOnSourceBranch() == initialNumberOfCommits - numberOfCommits;
            }
        }, (long)maxWaitTime);
    }

    public void pushToTargetBranchAndWait(String targetBranch, String author, String path, String file) throws Exception {
        String latestCommit = this.get().getString("toRef.latestCommit");
        RepositoryTestHelper.pushCommit(DefaultFuncTestData.getBaseURL(), DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword(), this.projectKey, this.repoSlug, targetBranch, author, author + "@test.com", path, file, "Contents 1", "New commit on branch 1");
        PullRequestTestHelper.waitForPullRequestToUpdate(() -> !latestCommit.equals(this.get().getString("toRef.latestCommit")));
    }

    public String toString() {
        return "{projectKey: " + this.projectKey + ", repoSlug:" + this.repoSlug + ", id: " + this.id + "}";
    }

    public static String getUrl(String projectKey, String repoSlug) {
        return DefaultFuncTestData.getRestURL() + "/projects/" + projectKey + "/repos/" + repoSlug + "/pull-requests";
    }

    public static String getUrl(String projectKey, String repoSlug, Map<String, String> queryParameters) {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, String> parameter : queryParameters.entrySet()) {
            builder.append(builder.length() == 0 ? "?" : "&").append(String.format("%s=%s", parameter.getKey(), parameter.getValue()));
        }
        return PullRequestTestHelper.getUrl(projectKey, repoSlug) + builder.toString();
    }

    public static String getUrl(String projectKey, String repoSlug, long id) {
        return PullRequestTestHelper.getUrl(projectKey, repoSlug) + "/" + id;
    }

    public static String getMergeBaseUrl(String projectKey, String repoSlug, long id) {
        return PullRequestTestHelper.getUrl(projectKey, repoSlug, id) + "/merge-base";
    }

    public static String getCommitsUrl(String projectKey, String repoSlug, long id, boolean withCounts) {
        return PullRequestTestHelper.getUrl(projectKey, repoSlug, id) + "/commits?withCounts=" + withCounts;
    }

    public static String getCommitMessageSuggestionUrl(String projectKey, String repoSlug, long id) {
        return PullRequestTestHelper.getUrl(projectKey, repoSlug, id) + "/commit-message-suggestion";
    }

    public static String getActivitiesUrl(String projectKey, String repoSlug, long id) {
        return PullRequestTestHelper.getUrl(projectKey, repoSlug, id) + "/activities";
    }

    public static String getActivitiesUrlStartingAt(String projectKey, String repoSlug, long id, PullRequestEntityType fromType, long fromId, int limit) {
        return PullRequestTestHelper.getUrl(projectKey, repoSlug, id) + "/activities?fromType=" + fromType + "&fromId=" + fromId + "&limit=" + limit;
    }

    public static String getDeclineUrl(String projectKey, String repoSlug, long id) {
        return PullRequestTestHelper.getUrl(projectKey, repoSlug, id) + "/decline";
    }

    public static String getMergeUrl(String projectKey, String repoSlug, long id) {
        return PullRequestTestHelper.getUrl(projectKey, repoSlug, id) + "/merge";
    }

    public static String getPatchUrl(String projectKey, String repoSlug, long id) {
        return PullRequestTestHelper.getUrl(projectKey, repoSlug, id) + ".patch";
    }

    public static String getRawDiffUrl(String projectKey, String repoSlug, long id) {
        return PullRequestTestHelper.getUrl(projectKey, repoSlug, id) + ".diff";
    }

    public static String getReopenUrl(String projectKey, String repoSlug, long id) {
        return PullRequestTestHelper.getUrl(projectKey, repoSlug, id) + "/reopen";
    }

    public static Response declinePullRequest(String username, String password, String projectKey, String repoSlug, long id, int version) {
        return (Response)RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).log().ifError().body("id", Matchers.equalTo((Object)((int)id)), new Object[0]).body("version", Matchers.equalTo((Object)(version + 1)), new Object[0]).body("state", Matchers.equalTo((Object)PullRequestState.DECLINED.name()), new Object[0]).given().auth().preemptive().basic(username, password).body((Object)PullRequestTestHelper.toJsonObject("version", version)).contentType("application/json").when().post(PullRequestTestHelper.getDeclineUrl(projectKey, repoSlug, id), new Object[0]);
    }

    public static Response deletePullRequest(String username, String password, String projectKey, String repoSlug, long id, int version) {
        return (Response)RestAssured.expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).log().ifError().given().body(PullRequestTestHelper.getVersionBody(version)).auth().preemptive().basic(username, password).contentType("application/json").when().delete(PullRequestTestHelper.getUrl(projectKey, repoSlug, id), new Object[0]);
    }

    public static Response reopenPullRequest(String username, String password, String projectKey, String repoSlug, long id, int version) {
        return (Response)RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).log().ifError().body("id", Matchers.equalTo((Object)((int)id)), new Object[0]).body("version", Matchers.equalTo((Object)(version + 1)), new Object[0]).body("state", Matchers.equalTo((Object)PullRequestState.OPEN.name()), new Object[0]).given().auth().preemptive().basic(username, password).body((Object)PullRequestTestHelper.toJsonObject("version", version)).contentType("application/json").when().post(PullRequestTestHelper.getReopenUrl(projectKey, repoSlug, id), new Object[0]);
    }

    public static Response mergePullRequest(String username, String password, String projectKey, String repoSlug, long id, int version) {
        return (Response)RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).log().ifError().body("id", Matchers.equalTo((Object)((int)id)), new Object[0]).body("version", Matchers.equalTo((Object)(version + 2)), new Object[0]).body("state", Matchers.equalTo((Object)PullRequestState.MERGED.name()), new Object[0]).given().auth().preemptive().basic(username, password).body((Object)PullRequestTestHelper.toJsonObject("version", version)).contentType("application/json").when().post(PullRequestTestHelper.getMergeUrl(projectKey, repoSlug, id), new Object[0]);
    }

    public static Response getMergeStatus(String username, String password, String projectKey, String repoSlug, long id) {
        return (Response)RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).log().ifError().given().auth().preemptive().basic(username, password).contentType("application/json").when().get(PullRequestTestHelper.getMergeUrl(projectKey, repoSlug, id), new Object[0]);
    }

    public static Response createPullRequest(MutableLong id, String username, String password, String title, String description, String fromProjectKey, String fromRepoSlug, String fromBranchId, String toProjectKey, String toRepoSlug, String toBranchId, String ... reviewers) {
        return PullRequestTestHelper.createPullRequest(id, username, password, title, description, false, fromProjectKey, fromRepoSlug, fromBranchId, toProjectKey, toRepoSlug, toBranchId, reviewers);
    }

    public static Response createPullRequest(MutableLong id, String username, String password, String title, String description, boolean draft, String fromProjectKey, String fromRepoSlug, String fromBranchId, String toProjectKey, String toRepoSlug, String toBranchId, String ... reviewers) {
        return PullRequestRestTestHelper.createPullRequest(id, username, password, title, description, draft, fromProjectKey, fromRepoSlug, fromBranchId, toProjectKey, toRepoSlug, toBranchId, new ResponseSpecBuilder().expectStatusCode(Response.Status.CREATED.getStatusCode()).build(), reviewers);
    }

    public static PullRequestTestHelper get(String username, String password, String projectKey, String repoSlug, long id) {
        return new PullRequestTestHelper(username, password, projectKey, repoSlug, id);
    }

    public static String getVersionBody(int version) {
        return "{\"version\": " + version + " }";
    }

    public static JSONObject toJsonObject(String key, Object value) {
        JSONObject json = new JSONObject();
        json.put((Object)key, value);
        return json;
    }

    public static void waitForPullRequestToUpdate(final Supplier<Boolean> action) {
        final int maxWaitTime = 5000;
        AsyncTestUtils.waitFor((WaitCondition)new WaitCondition(){

            public void describeFailure(Description description) {
                description.appendText("The pull request did not rescope within ").appendValue((Object)maxWaitTime).appendText(" milliseconds");
            }

            public boolean test() {
                return (Boolean)action.get();
            }
        }, (long)maxWaitTime);
    }

    private void doRequestAutoMerge(String user, JSONObject requestBody) {
        ((ResponseSpecification)RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).given().auth().preemptive().basic(user, user).body((Object)requestBody).contentType("application/json").expect().log().ifValidationFails()).body("state", Matchers.equalTo((Object)PullRequestState.OPEN.name()), new Object[0]).body("version", Matchers.equalTo((Object)this.getVersion()), new Object[0]).when().post(this.getMergeUrl(), new Object[0]);
    }

    private static String getCommitURL(String projectKey, String repoSlug, String commitId) {
        return DefaultFuncTestData.getRestURL() + "/projects/" + projectKey + "/repos/" + repoSlug + "/commits/" + commitId;
    }

    private String getCommitParent(String commitId) {
        return ((Response)((Response)this.request().expect().statusCode(Response.Status.OK.getStatusCode()).log().ifError().when().get(PullRequestTestHelper.getCommitURL(this.projectKey, this.repoSlug, commitId), new Object[0])).andReturn()).body().jsonPath().getString("parents[0].id");
    }

    public static class Builder {
        private final String password;
        private final Set<String> reviewers;
        private final String sourceProject;
        private final String sourceRepo;
        private final String targetProject;
        private final String targetRepo;
        private final String username;
        private String description;
        private boolean draft;
        private String sourceBranch;
        private String targetBranch;
        private String title;

        public Builder(String usernameAndPassword, String sourceProject, String sourceRepo, String targetProject, String targetRepo) {
            this(usernameAndPassword, usernameAndPassword, null, null, sourceProject, sourceRepo, null, targetProject, targetRepo, null);
        }

        public Builder(String username, String password, String title, String description, String sourceProject, String sourceRepo, String sourceBranch, String targetProject, String targetRepo, String targetBranch) {
            this.username = username;
            this.password = password;
            this.title = title;
            this.description = description;
            this.sourceProject = sourceProject;
            this.sourceRepo = sourceRepo;
            this.sourceBranch = sourceBranch;
            this.targetProject = targetProject;
            this.targetRepo = targetRepo;
            this.targetBranch = targetBranch;
            this.draft = false;
            this.reviewers = new HashSet<String>();
        }

        @Nonnull
        PullRequestTestHelper create() {
            MutableLong id = new MutableLong();
            PullRequestTestHelper.createPullRequest(id, this.username, this.password, this.title, this.description, this.draft, this.sourceProject, this.sourceRepo, this.sourceBranch, this.targetProject, this.targetRepo, this.targetBranch, this.reviewers.toArray(new String[this.reviewers.size()]));
            return new PullRequestTestHelper(this.username, this.password, this.targetProject, this.targetRepo, id.longValue());
        }

        @Nonnull
        public Builder title(String title) {
            this.title = title;
            return this;
        }

        @Nonnull
        public Builder description(String description) {
            this.description = description;
            return this;
        }

        @Nonnull
        public Builder draft(boolean draft) {
            this.draft = draft;
            return this;
        }

        @Nonnull
        public Builder reviewers(String ... usernames) {
            this.reviewers.addAll(Arrays.asList(usernames));
            return this;
        }

        @Nonnull
        public Builder sourceBranch(String sourceBranch) {
            this.sourceBranch = sourceBranch;
            return this;
        }

        @Nonnull
        public Builder targetBranch(String targetBranch) {
            this.targetBranch = targetBranch;
            return this;
        }

        public String getTargetProject() {
            return this.targetProject;
        }

        public String getTargetRepo() {
            return this.targetRepo;
        }
    }
}

