/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test;

import com.atlassian.bitbucket.test.DefaultFuncTestData;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import javax.ws.rs.core.Response;
import org.junit.Assert;

public class PullRequestTemplateHelper {
    private static final String PULL_REQUEST_TEMPLATES_ENDPOINT = "pull-request-templates";
    private final String adminPageUrl;
    private final String url;

    public PullRequestTemplateHelper(String project) {
        this.url = String.format("%s/projects/%s/%s", DefaultFuncTestData.getRestUiURL(), project, PULL_REQUEST_TEMPLATES_ENDPOINT);
        this.adminPageUrl = String.format("%s/projects/%s/settings/%s", DefaultFuncTestData.getBaseURL(), project, PULL_REQUEST_TEMPLATES_ENDPOINT);
    }

    public PullRequestTemplateHelper(String project, String repository) {
        this.url = String.format("%s/projects/%s/repos/%s/%s", DefaultFuncTestData.getRestUiURL(), project, repository, PULL_REQUEST_TEMPLATES_ENDPOINT);
        this.adminPageUrl = String.format("%s/projects/%s/repos/%s/settings/%s", DefaultFuncTestData.getBaseURL(), project, repository, PULL_REQUEST_TEMPLATES_ENDPOINT);
    }

    public void assertTemplate(String description, boolean enabled, String user, String password, int expectedStatusCode) {
        Response response = (Response)RestAssured.given().auth().preemptive().basic(user, password).expect().statusCode(expectedStatusCode).when().get(this.url, new Object[0]);
        if (expectedStatusCode == Response.Status.OK.getStatusCode()) {
            Assert.assertEquals((Object)description, (Object)response.jsonPath().getString("description"));
            Assert.assertEquals((Object)enabled, (Object)response.jsonPath().getBoolean("enabled"));
        }
    }

    public void assertTemplate(String description, boolean enabled) {
        this.assertTemplate(description, enabled, DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword(), Response.Status.OK.getStatusCode());
    }

    public Response getTemplate() {
        return (Response)RestAssured.given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).get(this.url, new Object[0]);
    }

    public Response deleteTemplate() {
        return this.deleteTemplate(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword());
    }

    public Response deleteTemplate(String user, String password) {
        return (Response)RestAssured.given().auth().preemptive().basic(user, password).delete(this.url, new Object[0]);
    }

    public String getAdminPageUrl() {
        return this.adminPageUrl;
    }

    public String getUrl() {
        return this.url;
    }

    public void setTemplate(String description, boolean enabled, String user, String password, int expectedStatusCode) {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().auth().preemptive().basic(user, password).contentType("application/json").request().body("{ \"description\": \"" + description + "\", \"enabled\": " + enabled + "}").when().put(this.url, new Object[0])).then()).log().ifValidationFails()).statusCode(expectedStatusCode);
    }

    public void setTemplate(String description, boolean enabled) {
        this.setTemplate(description, enabled, DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword(), Response.Status.OK.getStatusCode());
    }
}

