/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test;

import com.atlassian.bitbucket.test.DefaultFuncTestData;
import com.atlassian.bitbucket.util.Operation;
import com.atlassian.plugin.util.WaitUntil;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import javax.ws.rs.core.Response;
import net.sf.json.JSONObject;
import org.hamcrest.Matchers;

public class MeshFeaturesTestHelper {
    private MeshFeaturesTestHelper() {
        throw new UnsupportedOperationException("Static utility class - not for instantiation");
    }

    public static <T, E extends Throwable> T withMeshRepositoryCreationEnabled(Operation<T, E> operation) throws E {
        Object object;
        block4: {
            boolean wasEnabled = MeshFeaturesTestHelper.isRepositoryCreationEnabled();
            if (!wasEnabled) {
                MeshFeaturesTestHelper.setRepositoryCreationEnabled(true);
                WaitUntil.invoke((WaitUntil.WaitCondition)new WaitUntil.WaitCondition(){

                    public boolean isFinished() {
                        return MeshFeaturesTestHelper.isRepositoryCreationEnabled();
                    }

                    public String getWaitMessage() {
                        return "Waiting for repository creation on Mesh to become enabled";
                    }
                });
            }
            try {
                object = operation.perform();
                if (wasEnabled) break block4;
            }
            catch (Throwable throwable) {
                if (!wasEnabled) {
                    MeshFeaturesTestHelper.setRepositoryCreationEnabled(false);
                    WaitUntil.invoke((WaitUntil.WaitCondition)new WaitUntil.WaitCondition(){

                        public boolean isFinished() {
                            return !MeshFeaturesTestHelper.isRepositoryCreationEnabled();
                        }

                        public String getWaitMessage() {
                            return "Waiting for repository creation on Mesh to become disabled";
                        }
                    });
                }
                throw throwable;
            }
            MeshFeaturesTestHelper.setRepositoryCreationEnabled(false);
            WaitUntil.invoke((WaitUntil.WaitCondition)new /* invalid duplicate definition of identical inner class */);
        }
        return (T)object;
    }

    private static String getMeshSettingsRestUrl() {
        return DefaultFuncTestData.getRestUiURL() + "/admin/git/mesh/settings";
    }

    private static boolean isRepositoryCreationEnabled() {
        return ((Response)RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).log().ifError().given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).when().get(MeshFeaturesTestHelper.getMeshSettingsRestUrl(), new Object[0])).jsonPath().getBoolean("repositoryCreationEnabled");
    }

    private static void setRepositoryCreationEnabled(boolean createOnMesh) {
        JSONObject body = new JSONObject();
        body.put((Object)"repositoryCreationEnabled", (Object)createOnMesh);
        RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).body("repositoryCreationEnabled", Matchers.equalTo((Object)createOnMesh), new Object[0]).log().ifError().given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).when().body((Object)body).contentType(ContentType.JSON).put(MeshFeaturesTestHelper.getMeshSettingsRestUrl(), new Object[0]);
    }
}

