/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test;

import com.atlassian.bitbucket.rest.pull.RestPullRequestCommitMessageTemplate;
import com.atlassian.bitbucket.test.DefaultFuncTestData;
import com.atlassian.bitbucket.test.rest.AbstractRestHelper;
import com.atlassian.bitbucket.test.rest.RestAuthentication;
import com.google.common.collect.ImmutableMap;
import io.restassured.RestAssured;
import java.util.Map;
import javax.annotation.Nullable;
import javax.ws.rs.core.Response;
import net.sf.json.JSONObject;

public class MergeStrategiesTestHelper
extends AbstractRestHelper {
    public static final String FF_ID = "ff";
    public static final Map<String, Object> FF = ImmutableMap.of((Object)"id", (Object)"ff");
    public static final String FF_ONLY_ID = "ff-only";
    public static final String MERGE_CONFIG = "mergeConfig";
    public static final String NO_FF_ID = "no-ff";
    public static final Map<String, Object> NO_FF = ImmutableMap.of((Object)"id", (Object)"no-ff");
    public static final String REBASE_FF_ONLY_ID = "rebase-ff-only";
    public static final Map<String, Object> REBASE_FF_ONLY = ImmutableMap.of((Object)"id", (Object)"rebase-ff-only");
    public static final String REBASE_NO_FF_ID = "rebase-no-ff";
    public static final Map<String, Object> REBASE_NO_FF = ImmutableMap.of((Object)"id", (Object)"rebase-no-ff");
    public static final String SQUASH_ID = "squash";
    public static final Map<String, Object> SQUASH = ImmutableMap.of((Object)"id", (Object)"squash");
    public static final String SQUASH_FF_ONLY_ID = "squash-ff-only";

    protected MergeStrategiesTestHelper(@Nullable RestAuthentication defaultAuthentication) {
        super(defaultAuthentication);
    }

    public static void clearMergeStrategies(String url) {
        MergeStrategiesTestHelper.clearMergeStrategies(url, DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword());
    }

    public static void clearMergeStrategies(String url, String user, String password) {
        RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).log().ifError().contentType("application/json").given().auth().preemptive().basic(user, password).body(MergeStrategiesTestHelper.getEmptyMergeStrategiesBody()).contentType("application/json").when().post(url, new Object[0]);
    }

    public static String getEmptyMergeStrategiesBody() {
        JSONObject mergeStrategies = new JSONObject();
        mergeStrategies.put((Object)MERGE_CONFIG, (Object)new JSONObject());
        return mergeStrategies.toString();
    }

    public static RestPullRequestCommitMessageTemplate getCommitMessageTemplate(String title, String body) {
        return RestPullRequestCommitMessageTemplate.valueOf((Object)ImmutableMap.of((Object)"title", (Object)title, (Object)"body", (Object)body));
    }

    public static RestPullRequestCommitMessageTemplate getEmptyCommitMessageTemplate() {
        return new RestPullRequestCommitMessageTemplate();
    }

    public static String getMergeStrategiesBody(RestPullRequestCommitMessageTemplate template) {
        return MergeStrategiesTestHelper.getMergeStrategiesBody(10, template, FF, FF);
    }

    @SafeVarargs
    public static String getMergeStrategiesBody(Map<String, Object> defaultMap, Map<String, Object> ... strategies) {
        return MergeStrategiesTestHelper.getMergeStrategiesBody(10, null, defaultMap, strategies);
    }

    @SafeVarargs
    public static String getMergeStrategiesBody(int commitSummaries, Map<String, Object> defaultMap, Map<String, Object> ... strategies) {
        return MergeStrategiesTestHelper.getMergeStrategiesBody(commitSummaries, null, defaultMap, strategies);
    }

    @SafeVarargs
    public static String getMergeStrategiesBody(int commitSummaries, RestPullRequestCommitMessageTemplate template, Map<String, Object> defaultMap, Map<String, Object> ... strategies) {
        ImmutableMap.Builder builder = ImmutableMap.builder().put((Object)"commitSummaries", (Object)commitSummaries);
        if (template != null) {
            builder.put((Object)"commitMessageTemplate", (Object)template);
        }
        if (defaultMap != null) {
            builder.put((Object)"defaultStrategy", defaultMap);
        }
        if (strategies != null) {
            builder.put((Object)"strategies", strategies);
        }
        JSONObject mergeStrategies = new JSONObject();
        mergeStrategies.put((Object)MERGE_CONFIG, (Object)builder.build());
        return mergeStrategies.toString();
    }

    public static String getProjectSettingsUrl(String key) {
        return DefaultFuncTestData.getProjectRestURL(key) + "/settings/pull-requests/git";
    }

    public static String getRepositorySettingsUrl(String key, String slug) {
        return DefaultFuncTestData.getRepositoryRestURL(key, slug) + "/settings/pull-requests";
    }

    @SafeVarargs
    public static void setMergeStrategies(Map<String, Object> defaultMap, Map<String, Object> ... strategies) {
        MergeStrategiesTestHelper.setMergeStrategies(MergeStrategiesTestHelper.getRepositorySettingsUrl(DefaultFuncTestData.getProject1(), DefaultFuncTestData.getProject1Repository1()), defaultMap, strategies);
    }

    public static void setMergeStrategies(String url, RestPullRequestCommitMessageTemplate template) {
        MergeStrategiesTestHelper.setMergeStrategies(url, DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword(), Response.Status.OK.getStatusCode(), 10, template, FF, FF);
    }

    @SafeVarargs
    public static void setMergeStrategies(String url, Map<String, Object> defaultMap, Map<String, Object> ... strategies) {
        MergeStrategiesTestHelper.setMergeStrategies(url, DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword(), 10, defaultMap, strategies);
    }

    @SafeVarargs
    public static void setMergeStrategies(String url, int commitSummaries, Map<String, Object> defaultMap, Map<String, Object> ... strategies) {
        MergeStrategiesTestHelper.setMergeStrategies(url, DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword(), commitSummaries, defaultMap, strategies);
    }

    @SafeVarargs
    public static void setMergeStrategies(String url, int statusCode, int commitSummaries, Map<String, Object> defaultMap, Map<String, Object> ... strategies) {
        MergeStrategiesTestHelper.setMergeStrategies(url, DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword(), statusCode, commitSummaries, null, defaultMap, strategies);
    }

    @SafeVarargs
    public static void setMergeStrategies(String url, String user, String password, int commitSummaries, Map<String, Object> defaultMap, Map<String, Object> ... strategies) {
        MergeStrategiesTestHelper.setMergeStrategies(url, user, password, Response.Status.OK.getStatusCode(), commitSummaries, null, defaultMap, strategies);
    }

    @SafeVarargs
    public static void setMergeStrategies(String url, String user, String password, int statusCode, int commitSummaries, RestPullRequestCommitMessageTemplate commitMessageTemplate, Map<String, Object> defaultMap, Map<String, Object> ... strategies) {
        RestAssured.expect().statusCode(statusCode).log().ifError().contentType("application/json").given().auth().preemptive().basic(user, password).body(MergeStrategiesTestHelper.getMergeStrategiesBody(commitSummaries, commitMessageTemplate, defaultMap, strategies)).contentType("application/json").when().post(url, new Object[0]);
    }
}

