/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test;

import com.atlassian.bitbucket.internal.codeinsights.rest.RestInsightAnnotation;
import com.atlassian.bitbucket.internal.codeinsights.rest.RestInsightReport;
import com.atlassian.bitbucket.rest.RestErrors;
import com.atlassian.bitbucket.rest.RestMapEntity;
import com.atlassian.bitbucket.test.DefaultFuncTestData;
import com.atlassian.bitbucket.test.StatusCodesTestHelper;
import com.google.common.collect.ImmutableMap;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ResponseBody;
import io.restassured.specification.RequestSpecification;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;

public class InsightResourceHelper {
    private final Set<String> createdReportCommits = new HashSet<String>();
    private final String password;
    private final String projectKey;
    private final String repoSlug;
    private final String user;

    public InsightResourceHelper(String user, String password, String projectKey, String repoSlug) {
        this.user = user;
        this.password = password;
        this.projectKey = projectKey;
        this.repoSlug = repoSlug;
    }

    public void createAnnotation(String commit, String key, Map<String, Object> request) {
        this.createAnnotation(commit, key, request, (Response.StatusType)Response.Status.NO_CONTENT);
    }

    public RestMapEntity createAnnotation(String commit, String key, Map<String, Object> request, Response.StatusType expectedStatus) {
        return this.createAnnotation(commit, key, request, expectedStatus, this.user, this.password);
    }

    public RestMapEntity createAnnotation(String commit, String key, Map<String, Object> request, int expectedStatus) {
        return this.createAnnotation(commit, key, request, expectedStatus, this.user, this.password);
    }

    public RestMapEntity createAnnotation(String commit, String key, Map<String, Object> request, Response.StatusType expectedStatus, String user, String password) {
        return this.createAnnotation(commit, key, request, expectedStatus.getStatusCode(), user, password);
    }

    public RestMapEntity createAnnotation(String commit, String key, Map<String, Object> request, int expectedStatusCode, String user, String password) {
        ResponseBody body = ((Response)RestAssured.given().auth().preemptive().basic(user, password).contentType(ContentType.JSON).body(request).expect().log().ifError().statusCode(expectedStatusCode).when().post(this.getReportUrl(commit, key) + "/annotations", new Object[0])).getBody();
        if (!StatusCodesTestHelper.matching(Response.Status.OK, Response.Status.CREATED, Response.Status.ACCEPTED, Response.Status.NO_CONTENT).matches((Object)expectedStatusCode)) {
            return (RestMapEntity)body.as(RestErrors.class);
        }
        return null;
    }

    public RestInsightReport createReport(String commit, String key, Map<String, Object> request) {
        return (RestInsightReport)this.createReport(commit, key, request, Response.Status.OK);
    }

    public RestMapEntity createReport(String commit, String key, Map<String, Object> request, Response.Status expectedStatus) {
        return this.createReport(commit, key, request, expectedStatus, this.user, this.password);
    }

    public RestMapEntity createReport(String commit, String key, Map<String, Object> request, Response.Status expectedStatus, String user, String password) {
        ResponseBody body = ((Response)RestAssured.given().auth().preemptive().basic(user, password).contentType(ContentType.JSON).body(request).expect().log().ifError().statusCode(expectedStatus.getStatusCode()).when().put(this.getReportUrl(commit, key), new Object[0])).getBody();
        if (expectedStatus.getFamily() != Response.Status.Family.SUCCESSFUL) {
            return (RestMapEntity)body.as(RestErrors.class);
        }
        this.createdReportCommits.add(commit);
        return (RestMapEntity)body.as(RestInsightReport.class);
    }

    public void deleteAnnotations(String commitId, String reportKey, Set<String> externalIds) {
        RequestSpecification specification = RestAssured.given().auth().preemptive().basic(this.user, this.password).contentType(ContentType.JSON);
        if (!externalIds.isEmpty()) {
            specification.queryParam("externalId", externalIds);
        }
        specification.expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).log().ifError().when().delete(this.getReportUrl(commitId, reportKey) + "/annotations", new Object[0]);
    }

    public void deleteReport(String commit, String key) {
        this.deleteReport(commit, key, Response.Status.NO_CONTENT);
    }

    public RestMapEntity deleteReport(String commit, String key, Response.Status expectedStatus) {
        return this.deleteReport(commit, key, expectedStatus, this.user, this.password);
    }

    public RestMapEntity deleteReport(String commit, String key, Response.Status expectedStatus, String user, String password) {
        ResponseBody body = ((Response)RestAssured.given().auth().preemptive().basic(user, password).contentType(ContentType.JSON).expect().log().ifError().statusCode(expectedStatus.getStatusCode()).when().delete(this.getReportUrl(commit, key), new Object[0])).getBody();
        if (expectedStatus.getFamily() != Response.Status.Family.SUCCESSFUL) {
            return (RestMapEntity)body.as(RestErrors.class);
        }
        return null;
    }

    public void deleteCreatedReports() {
        this.createdReportCommits.forEach(commit -> this.getReports((String)commit).forEach(report -> this.deleteReport((String)commit, report.getKey())));
    }

    public RestInsightAnnotation[] getAnnotations(String commit) {
        return this.getAnnotations(commit, null);
    }

    public RestInsightAnnotation[] getAnnotations(long pullRequestId) {
        return this.getAnnotations(pullRequestId, Collections.emptyMap());
    }

    public RestInsightAnnotation[] getAnnotations(long pullRequestId, String reportKey) {
        return this.getAnnotations(pullRequestId, reportKey, null);
    }

    public RestInsightAnnotation[] getAnnotations(String commit, Map<String, ?> queryParams) {
        RequestSpecification requestSpecification = RestAssured.given().auth().preemptive().basic(this.user, this.password).contentType(ContentType.JSON);
        this.addQueryParams(queryParams, requestSpecification);
        return (RestInsightAnnotation[])((Response)requestSpecification.expect().log().ifError().when().get(this.getAnnotationsUrl(commit), new Object[0])).getBody().jsonPath().getObject("annotations", RestInsightAnnotation[].class);
    }

    public RestInsightAnnotation[] getAnnotations(long pullRequestId, Map<String, ?> queryParams) {
        RequestSpecification requestSpecification = RestAssured.given().auth().preemptive().basic(this.user, this.password).contentType(ContentType.JSON);
        this.addQueryParams(queryParams, requestSpecification);
        return (RestInsightAnnotation[])((Response)requestSpecification.expect().log().ifError().when().get(this.getAnnotationsUrl(pullRequestId), new Object[0])).getBody().jsonPath().getObject("annotations", RestInsightAnnotation[].class);
    }

    public RestInsightAnnotation[] getAnnotations(long pullRequestId, String reportKey, Map<String, ?> queryParams) {
        RequestSpecification requestSpecification = RestAssured.given().auth().preemptive().basic(this.user, this.password).contentType(ContentType.JSON);
        this.addQueryParams(queryParams, requestSpecification);
        return (RestInsightAnnotation[])((Response)requestSpecification.expect().log().ifError().when().get(this.getAnnotationsUrl(pullRequestId, reportKey), new Object[0])).getBody().jsonPath().getObject("annotations", RestInsightAnnotation[].class);
    }

    public Map<String, Object> getAnnotationsResponse(String commit, Map<String, ?> queryParams) {
        RequestSpecification requestSpecification = RestAssured.given().auth().preemptive().basic(this.user, this.password).contentType(ContentType.JSON);
        this.addQueryParams(queryParams, requestSpecification);
        return (Map)((Response)requestSpecification.expect().log().ifError().when().get(this.getAnnotationsUrl(commit), new Object[0])).getBody().as(Map.class);
    }

    public Map<String, Object> getAnnotationsResponse(long pullRequestId, Map<String, ?> queryParams) {
        RequestSpecification requestSpecification = RestAssured.given().auth().preemptive().basic(this.user, this.password).contentType(ContentType.JSON);
        this.addQueryParams(queryParams, requestSpecification);
        return (Map)((Response)requestSpecification.expect().log().ifError().when().get(this.getAnnotationsUrl(pullRequestId), new Object[0])).getBody().as(Map.class);
    }

    public RestMapEntity getReport(String commit, String key, Response.Status expectedStatus) {
        ResponseBody body = ((Response)RestAssured.given().auth().preemptive().basic(this.user, this.password).contentType(ContentType.JSON).expect().statusCode(expectedStatus.getStatusCode()).when().get(this.getReportUrl(commit, key), new Object[0])).getBody();
        if (expectedStatus.getFamily() != Response.Status.Family.SUCCESSFUL) {
            return (RestMapEntity)body.as(RestErrors.class);
        }
        return (RestMapEntity)body.as(RestInsightReport.class);
    }

    public RestInsightReport getReport(String commit, String key) {
        return (RestInsightReport)this.getReport(commit, key, Response.Status.OK);
    }

    public RestInsightReport getReport(long pullRequestId, String key) {
        ResponseBody body = ((Response)RestAssured.given().auth().preemptive().basic(this.user, this.password).contentType(ContentType.JSON).expect().statusCode(Response.Status.OK.getStatusCode()).when().get(this.getReportUrl(pullRequestId, key), new Object[0])).getBody();
        return (RestInsightReport)body.as(RestInsightReport.class);
    }

    public String getReportUrl(String commit, String key) {
        return String.format("%s/reports/%s", this.getCommitUrl(commit), key);
    }

    public String getReportUrl(long pullRequestId, String key) {
        return String.format("%s/reports/%s", this.getPullRequestUrl(pullRequestId), key);
    }

    public List<RestInsightReport> getReports(String commit) {
        return Arrays.stream((Object[])((Response)RestAssured.given().auth().preemptive().basic(this.user, this.password).contentType(ContentType.JSON).expect().statusCode(Response.Status.OK.getStatusCode()).when().get(this.getCommitUrl(commit) + "/reports", new Object[0])).getBody().jsonPath().getObject("values", RestInsightReport[].class)).collect(Collectors.toList());
    }

    public List<RestInsightReport> getReports(long pullRequestId) {
        return Arrays.stream((Object[])((Response)RestAssured.given().auth().preemptive().basic(this.user, this.password).contentType(ContentType.JSON).expect().statusCode(Response.Status.OK.getStatusCode()).when().get(this.getPullRequestUrl(pullRequestId) + "/reports", new Object[0])).getBody().jsonPath().getObject("values", RestInsightReport[].class)).collect(Collectors.toList());
    }

    public String getCommitUrl(String commit) {
        return DefaultFuncTestData.getRestURL("insights", "latest") + DefaultFuncTestData.getRepositoryPath(this.projectKey, this.repoSlug) + "/commits/" + commit;
    }

    public Map<String, Object> getCoverage(long pullRequestId, String path, int expectedStatusCode) {
        ResponseBody body = ((Response)RestAssured.given().auth().preemptive().basic(this.user, this.password).contentType(ContentType.JSON).expect().statusCode(expectedStatusCode).when().get(this.getCoverageUrl(pullRequestId, path), new Object[0])).getBody();
        if (!StatusCodesTestHelper.matching(Response.Status.OK, Response.Status.CREATED, Response.Status.ACCEPTED, Response.Status.NO_CONTENT).matches((Object)expectedStatusCode)) {
            return (Map)body.as(RestErrors.class);
        }
        return (Map)body.as(Map.class);
    }

    public String getCoverageUrl(long pullRequestId, String path) {
        return String.format("%s/coverage/%s", this.getPullRequestUrl(pullRequestId), StringUtils.isEmpty((CharSequence)path) ? "" : path);
    }

    public String getPullRequestUrl(long pullRequestId) {
        return DefaultFuncTestData.getRestURL("insights", "latest") + DefaultFuncTestData.getRepositoryPath(this.projectKey, this.repoSlug) + "/pull-requests/" + pullRequestId;
    }

    public RestInsightAnnotation[] getReportAnnotations(String commitId, String key) {
        RequestSpecification requestSpecification = RestAssured.given().auth().preemptive().basic(this.user, this.password).contentType(ContentType.JSON);
        return (RestInsightAnnotation[])((Response)requestSpecification.expect().log().ifError().when().get(this.getReportUrl(commitId, key) + "/annotations", new Object[0])).getBody().jsonPath().getObject("annotations", RestInsightAnnotation[].class);
    }

    public void updateAnnotation(String commit, String key, String externalId, ImmutableMap<String, Object> request) {
        RestAssured.given().auth().preemptive().basic(this.user, this.password).contentType(ContentType.JSON).body(request).expect().log().ifError().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(this.getReportUrl(commit, key) + "/annotations/" + externalId, new Object[0]);
    }

    private void addQueryParams(Map<String, ?> queryParams, RequestSpecification requestSpecification) {
        if (queryParams != null) {
            queryParams.forEach((k, v) -> {
                if (v instanceof Collection) {
                    ((Collection)v).forEach(value -> requestSpecification.queryParam(k, new Object[]{value}));
                } else {
                    requestSpecification.queryParam(k, new Object[]{v});
                }
            });
        }
    }

    private String getAnnotationsUrl(String commit) {
        return this.getCommitUrl(commit) + "/annotations";
    }

    private String getAnnotationsUrl(long pullRequestId) {
        return this.getPullRequestUrl(pullRequestId) + "/annotations";
    }

    private String getAnnotationsUrl(long pullRequestId, String reportKey) {
        return this.getReportUrl(pullRequestId, reportKey) + "/annotations";
    }
}

