/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test;

import com.atlassian.bitbucket.test.DefaultFuncTestData;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import javax.ws.rs.core.Response;

public class GitLfsTestHelper {
    private static final String ADMIN_USER = DefaultFuncTestData.getAdminUser();
    private static final String ADMIN_PASSWORD = DefaultFuncTestData.getAdminPassword();

    private GitLfsTestHelper() {
    }

    public static void enable() {
        GitLfsTestHelper.enableRest(GitLfsTestHelper.getEnabledUrl());
    }

    public static void enable(String project, String repository) {
        GitLfsTestHelper.enableRest(GitLfsTestHelper.getEnabledUrl(project, repository));
    }

    public static void disable() {
        GitLfsTestHelper.disableRest(GitLfsTestHelper.getEnabledUrl());
    }

    public static void disable(String project, String repository) {
        GitLfsTestHelper.disableRest(GitLfsTestHelper.getEnabledUrl(project, repository));
    }

    public static boolean isEnabled() {
        return GitLfsTestHelper.isEnabledRest(GitLfsTestHelper.getEnabledUrl());
    }

    public static boolean isEnabled(String project, String repository) {
        return GitLfsTestHelper.isEnabledRest(GitLfsTestHelper.getEnabledUrl(project, repository));
    }

    public static String getEnabledUrl() {
        return DefaultFuncTestData.getBaseURL() + "/rest/git-lfs/admin/enabled";
    }

    public static String getEnabledUrl(String project, String repository) {
        return String.format("%s/rest/git-lfs/admin/projects/%s/repos/%s/enabled", DefaultFuncTestData.getBaseURL(), project, repository);
    }

    private static void disableRest(String url) {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().auth().preemptive().basic(ADMIN_USER, ADMIN_PASSWORD).when().delete(url, new Object[0])).then()).statusCode(Response.Status.NO_CONTENT.getStatusCode())).log().ifValidationFails();
    }

    private static void enableRest(String url) {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().auth().preemptive().basic(ADMIN_USER, ADMIN_PASSWORD).when().put(url, new Object[0])).then()).statusCode(Response.Status.NO_CONTENT.getStatusCode())).log().ifValidationFails();
    }

    private static boolean isEnabledRest(String url) {
        int status = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().auth().preemptive().basic(ADMIN_USER, ADMIN_PASSWORD).when().get(url, new Object[0])).then()).log().ifValidationFails()).extract().statusCode();
        if (status == Response.Status.OK.getStatusCode()) {
            return true;
        }
        if (status == Response.Status.NOT_FOUND.getStatusCode()) {
            return false;
        }
        throw new RuntimeException("Unexpected status: " + status);
    }
}

