/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test;

import com.atlassian.bitbucket.dmz.settingsrestriction.ProjectSettingsRestrictionState;
import com.atlassian.bitbucket.scope.ScopeType;
import com.atlassian.bitbucket.settingsrestriction.ProjectSettingsRestrictionAction;
import com.atlassian.bitbucket.test.DefaultFuncTestData;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.specification.RequestSender;
import io.restassured.specification.RequestSpecification;
import io.restassured.specification.ResponseSpecification;
import javax.ws.rs.core.Response;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.ObjectUtils;
import org.hamcrest.Matchers;

public class AutoMergeSettingsRestRequest {
    private Integer expectedStatusCode;
    private String password = DefaultFuncTestData.getAdminPassword();
    private final String projectKey;
    private String repoSlug;
    private RequestBody requestBody = new RequestBody();
    private ResponseBodyVerification responseBodyVerification;
    private String username = DefaultFuncTestData.getAdminUser();

    public AutoMergeSettingsRestRequest(String projectKey) {
        this.projectKey = projectKey;
    }

    public AutoMergeSettingsRestRequest(String projectKey, String repoSlug) {
        this.projectKey = projectKey;
        this.repoSlug = repoSlug;
    }

    public AutoMergeSettingsRestRequest anonymous() {
        return this.user(null);
    }

    public Response delete() {
        return (Response)this.prepareRequestSender(Response.Status.NO_CONTENT.getStatusCode()).delete(this.getUrl(), new Object[0]);
    }

    public AutoMergeSettingsRestRequest enabled(boolean enabled) {
        this.requestBody = new RequestBody().enabled(enabled);
        return this;
    }

    public AutoMergeSettingsRestRequest expectResponse(ResponseBodyVerification responseBodyVerification) {
        this.responseBodyVerification = responseBodyVerification;
        return this;
    }

    public AutoMergeSettingsRestRequest expectStatusCode(int statusCode) {
        this.expectedStatusCode = statusCode;
        return this;
    }

    public Response get() {
        return (Response)this.prepareRequestSender(Response.Status.OK.getStatusCode()).get(this.getUrl(), new Object[0]);
    }

    public AutoMergeSettingsRestRequest requestBody(RequestBody requestBody) {
        this.requestBody = requestBody;
        return this;
    }

    public Response set() {
        return (Response)this.prepareRequestSender(Response.Status.OK.getStatusCode()).put(this.getUrl(), new Object[0]);
    }

    public AutoMergeSettingsRestRequest user(String username) {
        return this.user(username, username);
    }

    public AutoMergeSettingsRestRequest user(String username, String password) {
        this.username = username;
        this.password = password;
        return this;
    }

    private String getUrl() {
        String baseUrl = this.repoSlug != null ? DefaultFuncTestData.getRepositoryRestURL(this.projectKey, this.repoSlug) : DefaultFuncTestData.getProjectRestURL(this.projectKey);
        return baseUrl + "/settings/auto-merge";
    }

    private RequestSender prepareRequestSender(int successfulStatusCode) {
        RequestSpecification request = RestAssured.given().contentType("application/json");
        request = this.withAuthentication(request);
        ResponseSpecification responseSpecification = request.body((Object)this.requestBody.toJson()).expect().statusCode(((Integer)ObjectUtils.firstNonNull((Object[])new Integer[]{this.expectedStatusCode, successfulStatusCode})).intValue());
        if (this.responseBodyVerification != null) {
            this.responseBodyVerification.verify(responseSpecification);
        }
        return ((ResponseSpecification)responseSpecification.log().ifValidationFails()).when();
    }

    private RequestSpecification withAuthentication(RequestSpecification request) {
        if (this.password == null || this.username == null) {
            return request;
        }
        return request.auth().preemptive().basic(this.username, this.password);
    }

    public static class ResponseBodyVerification {
        private final boolean enabled;
        private final boolean restricted;
        private final ScopeType scopeType;

        public ResponseBodyVerification(boolean enabled, ScopeType scopeType, boolean restricted) {
            this.enabled = enabled;
            this.restricted = restricted;
            this.scopeType = scopeType;
        }

        public void verify(ResponseSpecification responseSpecification) {
            responseSpecification.expect().body("enabled", Matchers.equalTo((Object)this.enabled), new Object[0]).body("scope.type", Matchers.equalTo((Object)this.scopeType.name()), new Object[0]).body("restrictionState", this.restricted ? Matchers.not((Object)ProjectSettingsRestrictionState.NONE.toString()) : Matchers.equalTo((Object)ProjectSettingsRestrictionState.NONE.toString()), new Object[0]);
        }
    }

    public static class RequestBody {
        private Boolean enabled;
        private String restrictionAction;

        public RequestBody() {
            this.restrictionAction = ProjectSettingsRestrictionAction.NONE.toString();
        }

        public RequestBody(boolean enabled, ProjectSettingsRestrictionAction restrictionAction) {
            this.enabled(enabled).restrictionAction(restrictionAction.toString());
        }

        public RequestBody enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public RequestBody restrictionAction(String restrictionAction) {
            this.restrictionAction = restrictionAction;
            return this;
        }

        public JSONObject toJson() {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put((Object)"enabled", (Object)this.enabled);
            jsonObject.put((Object)"restrictionAction", (Object)this.restrictionAction);
            return jsonObject;
        }
    }
}

