/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test;

import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.audit.rest.model.CoverageAreaJson;
import com.atlassian.audit.rest.model.EffectiveCoverageLevelJson;
import com.atlassian.bitbucket.test.ClusterUtils;
import com.atlassian.bitbucket.test.DefaultFuncTestData;
import com.google.common.collect.ImmutableMap;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.specification.RequestSpecification;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;

public class AuditTestHelper {
    public static void clearAuditLogFilesContent(String baseUrl) {
        ((RequestSpecification)RestAssured.expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).log().ifValidationFails()).when().contentType(ContentType.JSON).delete(baseUrl + "/rest/mirroring-audit-tests/latest/audit-log", new Object[0]);
    }

    public static void createAuditEvents(String action, String category, CoverageLevel coverageLevel, int noOfEvents, String username, String password) {
        ((RequestSpecification)RestAssured.expect().statusCode(Response.Status.CREATED.getStatusCode()).given().auth().preemptive().basic(username, password).log().ifValidationFails()).when().contentType(ContentType.JSON).body((Object)ImmutableMap.of((Object)"action", (Object)action, (Object)"category", (Object)category, (Object)"coverageLevel", (Object)coverageLevel.name(), (Object)"noOfEvents", (Object)noOfEvents)).post(DefaultFuncTestData.getBaseURL() + "/rest/browser-tests/latest/auditevents", new Object[0]);
    }

    public static List<String> getAuditLogFilesContent(String baseUrl) {
        Response response = (Response)((RequestSpecification)RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).log().ifValidationFails()).when().accept(ContentType.JSON).get(baseUrl + "/rest/mirroring-audit-tests/latest/audit-log", new Object[0]);
        return response.body().jsonPath().getList(".", String.class);
    }

    static Map<CoverageAreaJson, EffectiveCoverageLevelJson> getLevels() {
        Response response = (Response)RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).when().get(DefaultFuncTestData.getBaseURL() + "/rest/auditing/latest/configuration/coverage", new Object[0]);
        Map levelbyArea = response.getBody().jsonPath().getMap("levelByArea");
        EnumMap<CoverageAreaJson, EffectiveCoverageLevelJson> levels = new EnumMap<CoverageAreaJson, EffectiveCoverageLevelJson>(CoverageAreaJson.class);
        levelbyArea.forEach((area, level) -> levels.put(CoverageAreaJson.fromKey((String)area), EffectiveCoverageLevelJson.fromKey((String)level)));
        return levels;
    }

    static void setLevels(Map<CoverageAreaJson, EffectiveCoverageLevelJson> levels) {
        String requestBody = "{\"levelByArea\": {";
        for (Map.Entry<CoverageAreaJson, EffectiveCoverageLevelJson> entry : levels.entrySet()) {
            requestBody = requestBody + "\"" + entry.getKey() + "\": \"" + entry.getValue() + "\",";
        }
        requestBody = requestBody.substring(0, requestBody.length() - 1) + "}}";
        AuditTestHelper.setCoverageLevel(requestBody);
    }

    static void setLevelForAllAreas(CoverageLevel coverageLevel) {
        String level = coverageLevel.name().toLowerCase();
        String requestBody = "{\n    \"levelByArea\": {\n        \"global-config-and-administration\": \"" + level + "\",\n        \"local-config-and-administration\": \"" + level + "\",\n        \"security\": \"" + level + "\",\n        \"end-user-activity\": \"" + level + "\",\n        \"audit-log\": \"" + level + "\",\n        \"user-management\": \"" + level + "\",\n        \"permissions\": \"" + level + "\"\n    }\n}";
        AuditTestHelper.setCoverageLevel(requestBody);
    }

    private static void setCoverageLevel(String requestBody) {
        ClusterUtils.acceptOnEachNode(DefaultFuncTestData.getBaseURL(), baseUrl -> {
            Response cfr_ignored_0 = (Response)RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).body(requestBody).contentType("application/json").when().put(baseUrl + "/rest/auditing/latest/configuration/coverage", new Object[0]);
        });
    }
}

