/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test.rules;

import com.atlassian.bitbucket.test.rules.TestQualified;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.junit.rules.TestName;

public class TestNameQualified
extends TestName
implements TestQualified {
    private final Supplier<String> testNameUniquenessSource;

    public TestNameQualified(Supplier<String> testNameUniquenessSource) {
        this.testNameUniquenessSource = testNameUniquenessSource;
    }

    @Override
    @Nonnull
    public String group(@Nonnull String base) {
        return TestNameQualified.testNameQualified(this, base, this.testNameUniquenessSource.get(), 255);
    }

    @Override
    @Nonnull
    public String name(@Nonnull String base, int maxLength) {
        return TestNameQualified.testNameQualified(this, base, this.testNameUniquenessSource.get(), maxLength);
    }

    @Override
    @Nonnull
    public String projectKey(@Nonnull String base) {
        return TestNameQualified.testNameQualified(this, base, this.testNameUniquenessSource.get(), 128);
    }

    @Override
    @Nonnull
    public String projectName(@Nonnull String base) {
        return TestNameQualified.testNameQualified(this, base, this.testNameUniquenessSource.get(), 128);
    }

    @Override
    @Nonnull
    public String repoName(@Nonnull String base) {
        return TestNameQualified.testNameQualified(this, base, this.testNameUniquenessSource.get(), 128);
    }

    @Override
    @Nonnull
    public String repoSlug(@Nonnull String base) {
        return TestNameQualified.testNameQualified(this, base, this.testNameUniquenessSource.get(), 128);
    }

    @Override
    @Nonnull
    public String userName(@Nonnull String base) {
        return TestNameQualified.testNameQualified(this, base, 255);
    }

    public static String testNameQualified(TestName testName, String base, int maxLength) {
        return TestNameQualified.testNameQualified(testName, base, "", maxLength);
    }

    public static String testNameQualified(TestName testName, String base, String perTestUniqueness, int maxLength) {
        Objects.requireNonNull(testName.getMethodName(), "A test method or test set up must be active to perform this function");
        Objects.requireNonNull(base, "base");
        String methodName = testName.getMethodName();
        if (methodName == null) {
            throw new IllegalStateException("A test method is not in context. You must wait until the TestName rule has started");
        }
        return StringUtils.truncate((String)(TestQualified.cleanPart(base) + "-" + (perTestUniqueness.isEmpty() ? "" : perTestUniqueness + "-") + TestQualified.uncamelise(TestQualified.cleanPart(methodName)).replaceAll("-+", "-")), (int)maxLength);
    }
}

