/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test.rest.mirror;

import com.atlassian.bitbucket.test.DefaultFuncTestData;
import com.atlassian.bitbucket.test.StatusCodesTestHelper;
import com.atlassian.bitbucket.test.rest.server.stub.mirror.MirrorStub;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.specification.RequestSpecification;
import io.restassured.specification.ResponseSpecification;
import javax.ws.rs.core.Response;

public class MirroringRequestHelper {
    public static Response acceptRequest(int id) {
        return MirroringRequestHelper.acceptRequest(id, Response.Status.OK);
    }

    public static Response acceptRequest(int id, Response.Status expectedStatus) {
        return (Response)((ResponseSpecification)RestAssured.given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).contentType("application/json").expect().statusCode(expectedStatus.getStatusCode()).log().ifValidationFails()).when().post(MirroringRequestHelper.getMirroringRequestAcceptUrl(id), new Object[0]);
    }

    public static Response createMirroringRequestV0(String mirrorId, String baseUrl, String descriptorUrl, Response.Status status) {
        return (Response)((ResponseSpecification)((RequestSpecification)RestAssured.given().contentType("application/json").body(MirroringRequestHelper.newMirroringRequestV0(mirrorId, baseUrl, descriptorUrl)).log().ifValidationFails()).expect().statusCode(status.getStatusCode()).log().ifValidationFails()).when().post(MirroringRequestHelper.getMirroringRequestsUrl(), new Object[0]);
    }

    public static Response createMirroringRequestV1(String mirrorId, String mirrorType, String baseUrl, String descriptorUrl, Response.Status status) {
        return (Response)((ResponseSpecification)((RequestSpecification)RestAssured.given().contentType("application/json").body(MirroringRequestHelper.newMirroringRequestV1(mirrorId, mirrorType, baseUrl, descriptorUrl)).log().ifValidationFails()).expect().statusCode(status.getStatusCode()).log().ifValidationFails()).when().post(MirroringRequestHelper.getMirroringRequestsUrl(), new Object[0]);
    }

    public static Response deleteRequest(int id) {
        return MirroringRequestHelper.deleteRequest(id, Response.Status.NO_CONTENT);
    }

    public static Response deleteRequest(int id, Response.Status ... statuses) {
        return (Response)((ResponseSpecification)((RequestSpecification)RestAssured.given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).contentType("application/json").log().ifValidationFails()).expect().statusCode(StatusCodesTestHelper.matching(statuses)).log().ifValidationFails()).when().delete(MirroringRequestHelper.getMirroringRequestUrl(id), new Object[0]);
    }

    public static String getAddOnUrl(String mirrorId) {
        return DefaultFuncTestData.getRestURL("plugins", "latest") + "/" + mirrorId.toLowerCase() + "-key";
    }

    public static String getAddOnUrl(MirrorStub mirror) {
        return MirroringRequestHelper.getAddOnUrl(mirror.getAddonKey());
    }

    public static int getIdFromResponse(Response response) {
        return response.getBody().jsonPath().getInt("id");
    }

    public static String getMirroringRequestAcceptUrl(int id) {
        return MirroringRequestHelper.getMirroringRequestUrl(id) + "/accept";
    }

    public static String getMirroringRequestRejectUrl(int id) {
        return MirroringRequestHelper.getMirroringRequestUrl(id) + "/reject";
    }

    public static String getMirroringRequestUrl(Object requestId) {
        return MirroringRequestHelper.getMirroringRequestsUrl() + "/" + requestId;
    }

    public static String getMirroringRequestsUrl() {
        return DefaultFuncTestData.getRestURL("mirroring", "latest") + "/requests";
    }

    public static String newMirroringRequestV0(String mirrorId, String baseUrl, String descriptorUrl) {
        return String.format("{\"mirrorId\": \"%s\", \"mirrorName\": \"%s\", \"mirrorBaseUrl\": \"%s\", \"productType\": \"test-mirror\", \"productVersion\": \"none\", \"addonDescriptorUri\": \"%s\"}", mirrorId, mirrorId, baseUrl, descriptorUrl);
    }

    public static String newMirroringRequestV1(String mirrorId, String mirrorType, String baseUrl, String descriptorUrl) {
        return String.format("{\"mirrorId\": \"%s\", \"mirrorName\": \"%s\", \"mirrorType\": \"%s\", \"mirrorBaseUrl\": \"%s\", \"productType\": \"test-mirror\", \"productVersion\": \"none\", \"addonDescriptorUri\": \"%s\"}", mirrorId, mirrorId, mirrorType, baseUrl, descriptorUrl);
    }

    public static Response rejectRequest(int id) {
        return MirroringRequestHelper.rejectRequest(id, Response.Status.OK);
    }

    public static Response rejectRequest(int id, Response.Status expectedStatus) {
        return (Response)((ResponseSpecification)((RequestSpecification)RestAssured.given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).contentType("application/json").log().ifValidationFails()).expect().statusCode(expectedStatus.getStatusCode()).log().ifValidationFails()).when().post(MirroringRequestHelper.getMirroringRequestRejectUrl(id), new Object[0]);
    }

    public static Response retrieveRequest(int id) {
        return (Response)((ResponseSpecification)((RequestSpecification)RestAssured.given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).contentType("application/json").log().ifValidationFails()).expect().statusCode(Response.Status.OK.getStatusCode()).log().ifValidationFails()).when().get(MirroringRequestHelper.getMirroringRequestUrl(id), new Object[0]);
    }
}

