/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test.rest.jiracloud.stubs;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.matching.UrlPattern;

public class DevInfoExistsByPropertiesStub {
    private static final String INVALID_CREDS_ERROR_RESPONSE = "{\n    \"errorMessages\": [\n        {\n            \"message\": \"The request failed: Provider 'OAuthClientId(value=\"%s\")' not installed in cloudId '\"%s\"' for type 'DEVELOPMENT_INFO'\"\n        }\n    ]\n}";
    private static final String INVALID_ACCESS_TOKEN_RESPONSE = "{\n    \"code\": 401,\n    \"message\": \"Unauthorized\"\n}";
    private static final String RESPONSE = "{\n    \"hasDataMatchingProperties\":  \"%s\"\n}";
    private final WireMockServer wiremock;
    private String clientId;
    private String cloudId;

    private DevInfoExistsByPropertiesStub(WireMockServer wiremock) {
        this.wiremock = wiremock;
    }

    public static DevInfoExistsByPropertiesStub aStub(WireMockServer wiremock) {
        return new DevInfoExistsByPropertiesStub(wiremock);
    }

    public DevInfoExistsByPropertiesStub forCredentials(String clientId, String cloudId) {
        this.clientId = clientId;
        this.cloudId = cloudId;
        return this;
    }

    public void shouldReturn(boolean isPropExists) {
        this.wiremock.stubFor(WireMock.get((UrlPattern)WireMock.urlPathEqualTo((String)("/jira/devinfo/0.1/cloud/" + this.cloudId + "/existsByProperties"))).withQueryParam("pseudoProp", WireMock.equalTo((String)"pseudo")).willReturn(WireMock.aResponse().withBody(String.format(RESPONSE, isPropExists)).withHeader("Content-Type", new String[]{"application/json"})));
    }

    public void shouldReturnInvalidAccessTokenError() {
        this.wiremock.stubFor(WireMock.get((UrlPattern)WireMock.urlPathEqualTo((String)("/jira/devinfo/0.1/cloud/" + this.cloudId + "/existsByProperties"))).withQueryParam("pseudoProp", WireMock.equalTo((String)"pseudo")).willReturn(WireMock.aResponse().withStatus(401).withBody(String.format(INVALID_ACCESS_TOKEN_RESPONSE, new Object[0])).withHeader("Content-Type", new String[]{"application/json"})));
    }

    public void shouldReturnOauthCredentialsError() {
        this.wiremock.stubFor(WireMock.get((UrlPattern)WireMock.urlPathEqualTo((String)("/jira/devinfo/0.1/cloud/" + this.cloudId + "/existsByProperties"))).withQueryParam("pseudoProp", WireMock.equalTo((String)"pseudo")).willReturn(WireMock.aResponse().withStatus(403).withBody(String.format(INVALID_CREDS_ERROR_RESPONSE, this.clientId, this.cloudId)).withHeader("Content-Type", new String[]{"application/json"})));
    }
}

