/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test.rest.jiracloud.stubs;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.matching.UrlPattern;

public class CloudIdResolverStub {
    private static final String RESPONSE = "{\n    \"cloudId\": \"%s\"\n}";
    private static final String ERROR_RESPONSE = "{\n  \"errors\": [\n     \"{\n          \"context\": null,\n          \"message\": \"\"Unable to resolve Cloud ID for Jira site [%s]\".\",\n          \"exceptionName\": com.atlassian.stash.internal.jira.cloud.config.exception.CloudIdResolutionException\n      \"}\n    ]\n}";
    private final WireMockServer wireMock;
    private String cloudId = "39394cfa-60b2-44c4-b55a-84ca6f742ece";

    private CloudIdResolverStub(WireMockServer wireMock) {
        this.wireMock = wireMock;
    }

    public static CloudIdResolverStub aStub(WireMockServer wiremock) {
        return new CloudIdResolverStub(wiremock);
    }

    public void returnCloudIdResolutionError(String url) {
        this.wireMock.stubFor(WireMock.get((UrlPattern)WireMock.urlMatching((String)"/([a-zA-Z0-9/-]*)\\/_edge/tenant_info")).willReturn(WireMock.aResponse().withStatus(500).withBody(String.format(ERROR_RESPONSE, url)).withHeader("Content-Type", new String[]{"application/json"})));
    }

    public void shouldReturn(String cloudId) {
        this.cloudId = cloudId;
        this.build();
    }

    private void build() {
        this.wireMock.stubFor(WireMock.get((UrlPattern)WireMock.urlMatching((String)"/([a-zA-Z0-9/-]*)\\/_edge/tenant_info")).willReturn(WireMock.aResponse().withStatus(200).withBody(String.format(RESPONSE, this.cloudId)).withHeader("Content-Type", new String[]{"application/json"})));
    }
}

