/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test.rest.commit;

import com.atlassian.bitbucket.content.DiffFileType;
import com.atlassian.bitbucket.content.DiffSegmentType;
import com.atlassian.bitbucket.test.DefaultFuncTestData;
import com.atlassian.bitbucket.test.RestTestHelper;
import com.atlassian.bitbucket.test.rest.AbstractRestHelper;
import com.atlassian.bitbucket.test.rest.RestAuthentication;
import com.atlassian.bitbucket.test.rest.comment.RestCommentRequest;
import com.atlassian.bitbucket.test.rest.comment.RestCommentUtils;
import com.atlassian.bitbucket.test.rest.commit.AbstractRestCommitCommentsRequest;
import com.atlassian.bitbucket.test.rest.commit.RestAddCommitCommentRequest;
import com.atlassian.bitbucket.test.rest.commit.RestChangesRequest;
import com.atlassian.bitbucket.test.rest.commit.RestDeleteCommitCommentRequest;
import com.atlassian.bitbucket.test.rest.commit.RestDiffRequest;
import com.atlassian.bitbucket.test.rest.commit.RestGetCommitCommentRequest;
import com.atlassian.bitbucket.test.rest.commit.RestGetCommitCommentsRequest;
import com.atlassian.bitbucket.test.rest.commit.RestUpdateCommitCommentRequest;
import io.restassured.builder.ResponseSpecBuilder;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.ws.rs.core.Response;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableLong;
import org.hamcrest.Matchers;

public class RestCommitHelper
extends AbstractRestHelper {
    private final String commitId;
    private final String projectKey;
    private final String repositorySlug;

    public RestCommitHelper(String commitId) {
        this(DefaultFuncTestData.getAdminAuthentication(), DefaultFuncTestData.getProject1(), DefaultFuncTestData.getProject1Repository1(), commitId);
    }

    public RestCommitHelper(RestAuthentication authentication, String projectKey, String repositorySlug, String commitId) {
        super(authentication);
        this.projectKey = projectKey;
        this.repositorySlug = repositorySlug;
        this.commitId = commitId;
    }

    public int addComment(@Nonnull RestAddCommitCommentRequest.Builder requestBuilder, @Nonnull ResponseSpecBuilder responseSpec) {
        MutableLong commentId = new MutableLong();
        this.addComment(((RestAddCommitCommentRequest.Builder)((Object)((RestAddCommitCommentRequest.Builder)((Object)requestBuilder.markup(Boolean.TRUE))).specification(responseSpec.expectBody("id", RestTestHelper.captureLongId(commentId)).build()))).build());
        return commentId.intValue();
    }

    public JsonPath addComment(@Nonnull RestAddCommitCommentRequest request) {
        return this.post(this.getCommentsUrl(request), request);
    }

    public int addFileComment(@Nonnull String text, @Nonnull String path, @Nullable String srcPath) {
        return this.addFileComment(text, path, srcPath, DefaultFuncTestData.getAdminUser());
    }

    public int addFileComment(@Nonnull String text, @Nonnull String path, @Nullable String srcPath, @Nonnull String username) {
        JSONObject body = RestCommentUtils.createFileBody(text, path, srcPath);
        return this.addComment(new RestAddCommitCommentRequest.Builder(body), RestCommentUtils.createSpecBuilderWithNoReplies(Response.Status.CREATED, null, text, username));
    }

    public int addGeneralComment(@Nonnull String text) {
        return this.addGeneralComment(text, DefaultFuncTestData.getAdminUser());
    }

    public int addGeneralComment(@Nonnull String text, @Nonnull String username) {
        JSONObject body = RestCommentUtils.createBody(text);
        return this.addComment(new RestAddCommitCommentRequest.Builder(body), RestCommentUtils.createSpecBuilderWithNoReplies(Response.Status.CREATED, null, text, username));
    }

    public int addLineComment(@Nonnull String text, @Nonnull String path, @Nullable String srcPath, int line, @Nullable DiffSegmentType lineType, @Nullable DiffFileType fileType) {
        return this.addLineComment(text, path, srcPath, line, lineType, fileType, DefaultFuncTestData.getAdminUser());
    }

    public int addLineComment(@Nonnull String text, @Nonnull String path, @Nullable String srcPath, int line, @Nullable DiffSegmentType lineType, @Nullable DiffFileType fileType, @Nonnull String username) {
        JSONObject body = RestCommentUtils.createLineBody(text, path, srcPath, line, lineType, fileType);
        return this.addComment(new RestAddCommitCommentRequest.Builder(body), RestCommentUtils.createSpecBuilderWithNoReplies(Response.Status.CREATED, null, text, username).expectBody("html", Matchers.equalTo((Object)("<p>" + text + "</p>\n"))));
    }

    public int addReply(int commentId, @Nonnull String text, @Nonnull String username) {
        JSONObject body = RestCommentUtils.createReplyBody(text, commentId);
        return this.addComment(new RestAddCommitCommentRequest.Builder(body), RestCommentUtils.createSpecBuilder(Response.Status.CREATED, null, text, username));
    }

    public void deleteComment(@Nonnull RestDeleteCommitCommentRequest request) {
        this.delete(this.getCommentUrl(request), request);
    }

    public JsonPath get() {
        return ((Response)this.request().expect().statusCode(Response.Status.OK.getStatusCode()).log().ifError().when().get(this.getUrl(), new Object[0])).body().jsonPath();
    }

    public JsonPath getChanges(@Nonnull RestChangesRequest request) {
        return this.get(this.getChangesUrl(request), request);
    }

    public JsonPath getComment(@Nonnull RestGetCommitCommentRequest request) {
        return this.get(this.getCommentUrl(request), request);
    }

    public JsonPath getComments(@Nonnull RestGetCommitCommentsRequest request) {
        return this.get(this.getCommentsUrl(request), request);
    }

    public JsonPath getDiff(@Nonnull RestDiffRequest request) {
        return this.get(this.getDiffUrl(request), request);
    }

    public String getChangesUrl(@Nonnull RestChangesRequest request) {
        return RestTestHelper.buildUrl(RestCommitHelper.getChangesUrl(this.projectKey, this.repositorySlug, this.commitId), request);
    }

    public String getCommentsUrl(@Nonnull AbstractRestCommitCommentsRequest request) {
        return RestTestHelper.buildUrl(this.getCommentsUrl(), request);
    }

    public String getCommentUrl(@Nonnull RestCommentRequest request) {
        return RestTestHelper.buildUrl(this.getCommentsUrl() + "/" + request.getId(), request);
    }

    public String getDiffUrl(@Nonnull RestDiffRequest request) {
        return RestTestHelper.buildUrl(RestCommitHelper.getDiffUrl(this.projectKey, this.repositorySlug, this.commitId, request.getPath()), request);
    }

    public String getUrl() {
        return RestCommitHelper.getViewUrl(this.projectKey, this.repositorySlug, this.commitId);
    }

    public String getWatchUrl() {
        return RestCommitHelper.getWatchUrl(this.projectKey, this.repositorySlug, this.commitId);
    }

    public JsonPath updateComment(@Nonnull RestUpdateCommitCommentRequest request) {
        return this.put(this.getCommentUrl(request), request);
    }

    public static String getChangesUrl(String projectKey, String repositorySlug, String commitId) {
        return RestCommitHelper.getViewUrl(projectKey, repositorySlug, commitId) + "/changes";
    }

    public static String getDiffUrl(String projectKey, String repositorySlug, String commitId, String path) {
        return RestCommitHelper.getViewUrl(projectKey, repositorySlug, commitId) + "/diff" + (StringUtils.isBlank((CharSequence)path) ? "" : "/" + path);
    }

    public static String getListUrl(String projectKey, String repositorySlug) {
        return DefaultFuncTestData.getRestURL() + "/projects/" + projectKey + "/repos/" + repositorySlug + "/commits";
    }

    public static String getViewUrl(String projectKey, String repositorySlug, String id) {
        return RestCommitHelper.getListUrl(projectKey, repositorySlug) + "/" + id;
    }

    public static String getWatchUrl(String projectKey, String repositorySlug, String id) {
        return RestCommitHelper.getViewUrl(projectKey, repositorySlug, id) + "/watch";
    }

    private String getCommentsUrl() {
        return RestCommentUtils.getCommitDiscussionCommentsUrl(this.projectKey, this.repositorySlug, this.commitId);
    }
}

