/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test.rest;

import com.google.common.collect.Collections2;
import com.jayway.jsonassert.JsonAssert;
import com.jayway.jsonassert.JsonAsserter;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.spi.json.JsonProvider;
import java.util.Arrays;
import java.util.Collection;
import javax.ws.rs.core.Response;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.SelfDescribing;

public class ResponseMatchers {
    private ResponseMatchers() {
        throw new UnsupportedOperationException(ResponseMatchers.class.getName() + " should not be instantiated");
    }

    public static Matcher<Integer> successful() {
        return Matchers.allOf((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(Response.Status.OK.getStatusCode())), (Matcher)Matchers.lessThan((Comparable)Integer.valueOf(300)));
    }

    public static Matcher<Integer> accepted() {
        return ResponseMatchers.forStatus(Response.Status.ACCEPTED);
    }

    public static Matcher<Integer> badRequest() {
        return ResponseMatchers.forStatus(Response.Status.BAD_REQUEST);
    }

    public static Matcher<Integer> conflict() {
        return ResponseMatchers.forStatus(Response.Status.CONFLICT);
    }

    public static Matcher<Integer> noContent() {
        return ResponseMatchers.forStatus(Response.Status.NO_CONTENT);
    }

    public static Matcher<Integer> notFound() {
        return ResponseMatchers.forStatus(Response.Status.NOT_FOUND);
    }

    public static Matcher<Integer> ok() {
        return ResponseMatchers.forStatus(Response.Status.OK);
    }

    public static Matcher<Integer> unauthorized() {
        return ResponseMatchers.forStatus(Response.Status.UNAUTHORIZED);
    }

    private static Matcher<Integer> forStatus(Response.Status status) {
        return Matchers.is((Object)status.getStatusCode());
    }

    @SafeVarargs
    public static Matcher<? super Object> pathContainsInAnyOrder(final String path, final Matcher<? super Object> ... matchers) {
        final Collection<Matcher<? super Object>> transformedMatchers = ResponseMatchers.transformMatchers(matchers);
        return new BaseMatcher<Object>(){

            public boolean matches(Object json) {
                try {
                    JsonAssert.with((String)((String)json)).assertThat(path, Matchers.containsInAnyOrder((Collection)transformedMatchers));
                    return true;
                }
                catch (AssertionError e) {
                    return false;
                }
            }

            public void describeTo(Description description) {
                description.appendText(path + " is (in any order) ");
                for (int i = 0; i < matchers.length; ++i) {
                    description.appendText("[");
                    description.appendDescriptionOf((SelfDescribing)matchers[i]);
                    description.appendText("]");
                    if (i == matchers.length - 1) continue;
                    description.appendText(", ");
                }
            }
        };
    }

    @SafeVarargs
    public static Matcher<? super Object> pathHasItems(final String path, final Matcher<? super Object> ... matchers) {
        final Collection<Matcher<? super Object>> transformedMatchers = ResponseMatchers.transformMatchers(matchers);
        return new BaseMatcher<Object>(){

            public boolean matches(Object json) {
                try {
                    JsonAssert.with((String)((String)json)).assertThat(path, Matchers.hasItems((Matcher[])transformedMatchers.toArray(new Matcher[0])));
                    return true;
                }
                catch (AssertionError e) {
                    return false;
                }
            }

            public void describeTo(Description description) {
                description.appendText(path + " has items ");
                for (int i = 0; i < matchers.length; ++i) {
                    description.appendText("[");
                    description.appendDescriptionOf((SelfDescribing)matchers[i]);
                    description.appendText("]");
                    if (i == matchers.length - 1) continue;
                    description.appendText(", ");
                }
            }
        };
    }

    public static Matcher<? super Object> matchingValues(final Object ... keyAndMatchers) {
        return new BaseMatcher<Object>(){

            public boolean matches(Object json) {
                JsonAsserter asserter = JsonAssert.with((String)((String)json));
                try {
                    for (int i = 0; i < keyAndMatchers.length; i += 2) {
                        asserter.assertThat((String)keyAndMatchers[i], (Matcher)keyAndMatchers[i + 1]);
                    }
                    return true;
                }
                catch (AssertionError e) {
                    return false;
                }
            }

            public void describeTo(Description description) {
                for (int i = 0; i < keyAndMatchers.length; i += 2) {
                    description.appendText(keyAndMatchers[i] + " is ");
                    description.appendDescriptionOf((SelfDescribing)((Matcher)keyAndMatchers[i + 1]));
                    if (i == keyAndMatchers.length - 2) continue;
                    description.appendText(", ");
                }
            }
        };
    }

    private static Collection<Matcher<? super Object>> transformMatchers(Matcher<? super Object>[] matchers) {
        final JsonProvider jsonProvider = Configuration.defaultConfiguration().jsonProvider();
        return Collections2.transform(Arrays.asList(matchers), matcher -> new BaseMatcher<Object>(){

            public boolean matches(Object item) {
                String json = jsonProvider.toJson(item);
                return matcher.matches((Object)json);
            }

            public void describeTo(Description description) {
                matcher.describeTo(description);
            }
        });
    }
}

