/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test.filters;

import java.util.List;
import org.junit.runner.Description;
import org.junit.runner.manipulation.Filter;

public class CompositeTestFilter
extends Filter {
    private final List<Filter> filters;

    public CompositeTestFilter(List<Filter> filters) {
        this.filters = filters;
    }

    public boolean shouldRun(Description description) {
        for (Filter filter : this.filters) {
            if (filter.shouldRun(description)) continue;
            return false;
        }
        return true;
    }

    public String describe() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(String.format("%s:\n", ((Object)((Object)this)).getClass().getName()));
        for (Filter filter : this.filters) {
            buffer.append(String.format("%s\n", filter.describe()));
        }
        return buffer.toString();
    }
}

