/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test.deployment;

import com.atlassian.bitbucket.async.AsyncTestUtils;
import com.atlassian.bitbucket.async.WaitCondition;
import com.atlassian.bitbucket.dmz.deployments.DeploymentEnvironmentType;
import com.atlassian.bitbucket.dmz.deployments.DeploymentState;
import com.atlassian.bitbucket.rest.RestErrors;
import com.atlassian.bitbucket.rest.deployment.RestDeployment;
import com.atlassian.bitbucket.rest.deployment.RestDeploymentSetRequest;
import com.atlassian.bitbucket.test.BranchTestHelper;
import com.atlassian.bitbucket.test.DefaultFuncTestData;
import com.atlassian.bitbucket.test.RepositoryTestHelper;
import io.restassured.RestAssured;
import io.restassured.filter.log.LogDetail;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.specification.RequestSpecification;
import io.restassured.specification.ResponseSpecification;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.lang3.StringUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;

public class DeploymentTestHelper {
    private static final int TIMEOUT_MS = 5000;
    private final String projectKey;
    private final String repoSlug;
    private final String user;

    public DeploymentTestHelper(String projectKey, String repoSlug, String user) {
        this.projectKey = projectKey;
        this.repoSlug = repoSlug;
        this.user = user;
    }

    public void assertDeployment(RestDeployment actual, RestDeployment expected) {
        MatcherAssert.assertThat((Object)actual.getDeploymentSequenceNumber(), (Matcher)CoreMatchers.equalTo((Object)expected.getDeploymentSequenceNumber()));
        MatcherAssert.assertThat((Object)actual.getDescription(), (Matcher)CoreMatchers.equalTo((Object)expected.getDescription()));
        MatcherAssert.assertThat((Object)actual.getDisplayName(), (Matcher)CoreMatchers.equalTo((Object)expected.getDisplayName()));
        if (expected.getFromCommit() != null) {
            MatcherAssert.assertThat((Object)actual.getFromCommit().get((Object)"id"), (Matcher)CoreMatchers.equalTo((Object)expected.getFromCommit().get((Object)"id")));
        } else {
            Assert.assertNull((Object)actual.getFromCommit());
        }
        MatcherAssert.assertThat((Object)actual.getEnvironment().getDisplayName(), (Matcher)CoreMatchers.equalTo((Object)expected.getEnvironment().getDisplayName()));
        MatcherAssert.assertThat((Object)actual.getEnvironment().getKey(), (Matcher)CoreMatchers.equalTo((Object)expected.getEnvironment().getKey()));
        MatcherAssert.assertThat((Object)actual.getEnvironment().getType(), (Matcher)CoreMatchers.equalTo((Object)expected.getEnvironment().getType()));
        MatcherAssert.assertThat((Object)actual.getEnvironment().getUrl(), (Matcher)CoreMatchers.equalTo((Object)expected.getEnvironment().getUrl()));
        MatcherAssert.assertThat((Object)actual.getKey(), (Matcher)CoreMatchers.equalTo((Object)expected.getKey()));
        MatcherAssert.assertThat((Object)actual.getLastUpdated(), (Matcher)CoreMatchers.equalTo((Object)expected.getLastUpdated()));
        MatcherAssert.assertThat((Object)actual.getRepository().getSlug(), (Matcher)CoreMatchers.equalTo((Object)this.repoSlug));
        MatcherAssert.assertThat((Object)actual.getState(), (Matcher)CoreMatchers.equalTo((Object)expected.getState()));
        MatcherAssert.assertThat((Object)actual.getToCommit().get((Object)"id"), (Matcher)CoreMatchers.equalTo((Object)expected.getToCommit().get((Object)"id")));
        MatcherAssert.assertThat((Object)actual.getUrl(), (Matcher)CoreMatchers.equalTo((Object)expected.getUrl()));
    }

    public UriBuilder commitDeploymentResourceUrl(String commit, String state) {
        UriBuilder uriBuilder = UriBuilder.fromUri((String)DefaultFuncTestData.getRestURL("ui", "latest")).path(DefaultFuncTestData.getRepositoryPath(this.projectKey, this.repoSlug)).path("commits").path(commit).path("deployments");
        this.addQueries(uriBuilder, state);
        return uriBuilder;
    }

    public Map<String, Object> createRequestMap(long deploymentSequenceNumber, String description, String displayName, String environmentDisplayName, String environmentKey, String environmentType, String environmentUrl, String key, Date lastUpdated, DeploymentState state, String url) {
        HashMap<String, String> environmentMap = new HashMap<String, String>();
        environmentMap.put("displayName", environmentDisplayName);
        environmentMap.put("key", environmentKey);
        environmentMap.put("type", environmentType);
        environmentMap.put("url", environmentUrl);
        HashMap<String, Object> requestMap = new HashMap<String, Object>();
        requestMap.put("deploymentSequenceNumber", deploymentSequenceNumber);
        requestMap.put("description", description);
        requestMap.put("displayName", displayName);
        requestMap.put("environment", environmentMap);
        requestMap.put("key", key);
        requestMap.put("lastUpdated", lastUpdated);
        requestMap.put("state", state);
        requestMap.put("url", url);
        return requestMap;
    }

    public RestDeployment createRestDeployment(String commitId, long deploymentSequenceNumber, String description, String displayName, String environmentDisplayName, String environmentKey, DeploymentEnvironmentType environmentType, String environmentUrl, String key, DeploymentState state, String url) {
        return this.createRestDeployment(commitId, deploymentSequenceNumber, description, displayName, environmentDisplayName, environmentKey, environmentType, environmentUrl, key, new Date(), state, url);
    }

    public RestDeployment createRestDeployment(String commitId, long deploymentSequenceNumber, String description, String displayName, String environmentDisplayName, String environmentKey, DeploymentEnvironmentType environmentType, String environmentUrl, String key, Date lastUpdated, DeploymentState state, String url) {
        return this.createRestDeployment(commitId, deploymentSequenceNumber, description, displayName, environmentDisplayName, environmentKey, environmentType != null ? environmentType.toString() : null, environmentUrl, key, lastUpdated, state, url, null);
    }

    public RestDeployment createRestDeployment(String commitId, long deploymentSequenceNumber, String description, String displayName, String environmentDisplayName, String environmentKey, String environmentType, String environmentUrl, String key, Date lastUpdated, DeploymentState state, String url, String userAgent) {
        Map<String, Object> requestMap = this.createRequestMap(deploymentSequenceNumber, description, displayName, environmentDisplayName, environmentKey, environmentType, environmentUrl, key, lastUpdated, state, url);
        RestDeploymentSetRequest restRequest = RestDeploymentSetRequest.valueOf(requestMap);
        RequestSpecification requestSpecification = ((ResponseSpecification)RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).log().ifValidationFails(LogDetail.ALL)).given().auth().preemptive().basic(this.user, this.user).contentType("application/json").body((Object)restRequest);
        if (!StringUtils.isBlank((CharSequence)userAgent)) {
            requestSpecification.header("user-agent", (Object)userAgent, new Object[0]);
        }
        Response response = (Response)requestSpecification.post(this.publicDeploymentResourceUrl(commitId).build(new Object[0]));
        RestDeployment created = (RestDeployment)response.as(RestDeployment.class);
        MatcherAssert.assertThat((Object)created.getDeploymentSequenceNumber(), (Matcher)CoreMatchers.equalTo((Object)deploymentSequenceNumber));
        MatcherAssert.assertThat((Object)created.getDescription(), (Matcher)CoreMatchers.equalTo((Object)description));
        MatcherAssert.assertThat((Object)created.getDisplayName(), (Matcher)CoreMatchers.equalTo((Object)displayName));
        MatcherAssert.assertThat((Object)created.getEnvironment().getDisplayName(), (Matcher)CoreMatchers.equalTo((Object)environmentDisplayName));
        MatcherAssert.assertThat((Object)created.getEnvironment().getKey(), (Matcher)CoreMatchers.equalTo((Object)environmentKey));
        MatcherAssert.assertThat((Object)created.getEnvironment().getType(), (Matcher)CoreMatchers.equalTo((Object)environmentType));
        MatcherAssert.assertThat((Object)created.getEnvironment().getUrl(), (Matcher)CoreMatchers.equalTo((Object)environmentUrl));
        MatcherAssert.assertThat((Object)created.getKey(), (Matcher)CoreMatchers.equalTo((Object)key));
        MatcherAssert.assertThat((Object)created.getLastUpdated(), (Matcher)CoreMatchers.equalTo((Object)lastUpdated.getTime()));
        MatcherAssert.assertThat((Object)created.getState(), (Matcher)CoreMatchers.equalTo((Object)state));
        MatcherAssert.assertThat((Object)created.getToCommit().get((Object)"id"), (Matcher)CoreMatchers.equalTo((Object)commitId));
        MatcherAssert.assertThat((Object)created.getUrl(), (Matcher)CoreMatchers.equalTo((Object)url));
        this.search(commitId, created);
        return created;
    }

    public RestErrors createRestDeploymentUnsuccessfully(String commitId, long deploymentSequenceNumber, String description, String displayName, String environmentDisplayName, String environmentKey, DeploymentEnvironmentType environmentType, String environmentUrl, String key, Date lastUpdated, DeploymentState state, String url) {
        Map<String, Object> requestMap = this.createRequestMap(deploymentSequenceNumber, description, displayName, environmentDisplayName, environmentKey, environmentType.toString(), environmentUrl, key, lastUpdated, state, url);
        RestDeploymentSetRequest restRequest = RestDeploymentSetRequest.valueOf(requestMap);
        return (RestErrors)((Response)((ResponseSpecification)RestAssured.expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).log().ifValidationFails(LogDetail.ALL)).given().auth().preemptive().basic(this.user, this.user).contentType("application/json").body((Object)restRequest).post(this.publicDeploymentResourceUrl(commitId).build(new Object[0]))).as(RestErrors.class);
    }

    public Response delete(int expectedStatusCode, String commitId, String key, String environmentKey, Long deploymentSequenceNumber) {
        UriBuilder deleteUrl = this.getDeploymentUrl(commitId, key, environmentKey, deploymentSequenceNumber);
        RequestSpecification request = RestAssured.given();
        if (this.user != null) {
            request.auth().preemptive().basic(this.user, this.user);
        }
        return (Response)((ResponseSpecification)request.contentType(ContentType.JSON).header("Accept", (Object)ContentType.JSON.getAcceptHeader(), new Object[0]).expect().statusCode(expectedStatusCode).log().ifValidationFails()).when().delete(deleteUrl.build(new Object[0]));
    }

    public RestErrors deleteUnsuccessfully(int expectedStatusCode, String commitId, String key, String environmentKey, Long deploymentSequenceNumber) {
        return (RestErrors)this.delete(expectedStatusCode, commitId, key, environmentKey, deploymentSequenceNumber).as(RestErrors.class);
    }

    public RestDeployment get(String commitId, String key, String envKey, Long deploymentNumber) {
        return (RestDeployment)this.get(Response.Status.OK.getStatusCode(), commitId, key, envKey, deploymentNumber).as(RestDeployment.class);
    }

    public Response get(int expectedStatusCode, String commitId, String key, String envKey, Long deploymentNumber) {
        return (Response)((ResponseSpecification)RestAssured.given().auth().preemptive().basic(this.user, this.user).contentType("application/json").urlEncodingEnabled(false).expect().statusCode(expectedStatusCode).log().ifValidationFails()).when().get(this.getDeploymentUrl(commitId, key, envKey, deploymentNumber).build(new Object[0]));
    }

    public RestErrors getUnsuccessfully(int expectedStatusCode, String commitId, String key, String envKey, Long deploymentNumber) {
        return (RestErrors)this.get(expectedStatusCode, commitId, key, envKey, deploymentNumber).as(RestErrors.class);
    }

    public UriBuilder publicDeploymentResourceUrl(String commitId) {
        return UriBuilder.fromUri((String)DefaultFuncTestData.getRestURL("latest")).path(DefaultFuncTestData.getRepositoryPath(this.projectKey, this.repoSlug)).path("commits").path(commitId).path("deployments");
    }

    public String pushCommitAndWait(String initialCommit) throws IOException, URISyntaxException {
        String branch = "deployment-branch";
        BranchTestHelper.createBranch(this.projectKey, this.repoSlug, branch, initialCommit);
        final String commit = RepositoryTestHelper.pushCommit(DefaultFuncTestData.getBaseURL(), DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminUser(), this.projectKey, this.repoSlug, branch, DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminUser() + "@test.com", "new_path", "new_file", "some_content", "some_message");
        AsyncTestUtils.waitFor((WaitCondition)new WaitCondition(){

            public void describeFailure(Description description) throws Exception {
                description.appendValue((Object)"Commit cannot be found in repository");
            }

            public boolean test() throws Exception {
                Response response = (Response)RestAssured.expect().given().auth().preemptive().basic(DeploymentTestHelper.this.user, DeploymentTestHelper.this.user).when().get(DefaultFuncTestData.getRepositoryRestURL(DeploymentTestHelper.this.projectKey, DeploymentTestHelper.this.repoSlug) + "/commits/" + commit, new Object[0]);
                return response.getStatusCode() == 200;
            }
        }, (long)2000L);
        return commit;
    }

    public List<RestDeployment> search(String commit, RestDeployment ... expectedDeployments) {
        return this.searchWithState(commit, null, expectedDeployments);
    }

    public List<RestDeployment> search(long prId, RestDeployment ... expectedDeployments) {
        return this.searchWithState(prId, null, expectedDeployments);
    }

    public List<RestDeployment> searchWithState(String commit, String state, RestDeployment ... expectedDeployments) {
        return this.waitForDeployments("commit " + commit, () -> this.search(this.commitDeploymentResourceUrl(commit, state)), expectedDeployments);
    }

    public List<RestDeployment> searchWithState(long prId, String state, RestDeployment ... expectedDeployments) {
        return this.waitForDeployments("pull request " + prId, () -> this.search(this.pullRequestSearchUrl(prId, state)), expectedDeployments);
    }

    private void addQueries(UriBuilder url, String state) {
        if (!StringUtils.isBlank((CharSequence)state)) {
            url.queryParam("state", new Object[]{state});
        }
        url.queryParam("limit", new Object[]{1000});
    }

    private UriBuilder getDeploymentUrl(String commitId, String key, String environmentKey, Long deploymentSequenceNumber) {
        UriBuilder uriBuilder = this.publicDeploymentResourceUrl(commitId);
        if (key != null) {
            uriBuilder.queryParam("key", new Object[]{key});
        }
        if (deploymentSequenceNumber != null) {
            uriBuilder.queryParam("deploymentSequenceNumber", new Object[]{deploymentSequenceNumber});
        }
        if (environmentKey != null) {
            uriBuilder.queryParam("environmentKey", new Object[]{environmentKey});
        }
        return uriBuilder;
    }

    private UriBuilder pullRequestSearchUrl(long pullRequestId, String state) {
        UriBuilder uriBuilder = UriBuilder.fromUri((String)DefaultFuncTestData.getRestURL("ui", "latest")).path(DefaultFuncTestData.getRepositoryPath(this.projectKey, this.repoSlug)).path("pull-requests").path(String.valueOf(pullRequestId)).path("deployments");
        this.addQueries(uriBuilder, state);
        return uriBuilder;
    }

    private List<RestDeployment> search(UriBuilder uriBuilder) {
        Response response = (Response)((ResponseSpecification)RestAssured.given().auth().preemptive().basic(this.user, this.user).contentType("application/json").expect().statusCode(Response.Status.OK.getStatusCode()).log().ifValidationFails()).when().get(uriBuilder.build(new Object[0]));
        return ((List)response.path("values", new String[0])).stream().map(RestDeployment::valueOf).collect(Collectors.toList());
    }

    private List<RestDeployment> waitForDeployments(final String name, final Supplier<List<RestDeployment>> deploymentSupplier, final RestDeployment ... expectedDeploymentsArray) {
        final Set expectedDeploymentIds = Arrays.stream(expectedDeploymentsArray).map(d -> d.getKey() + ":" + d.getEnvironment().getKey()).collect(Collectors.toSet());
        AsyncTestUtils.waitFor((WaitCondition)new WaitCondition(){
            private Set<RestDeployment> indexedDeployments;

            public void describeFailure(Description description) throws Exception {
                description.appendText("On ").appendValue((Object)name).appendText(" expected deployments ").appendValueList("(", ",", ")", (Object[])expectedDeploymentsArray).appendText(" but got ").appendValueList("(", ",", ")", this.indexedDeployments);
            }

            public boolean test() throws Exception {
                this.indexedDeployments = new HashSet<RestDeployment>((Collection)deploymentSupplier.get());
                return this.indexedDeployments.stream().map(d -> d.getKey() + ":" + d.getEnvironment().getKey()).collect(Collectors.toSet()).containsAll(expectedDeploymentIds);
            }
        }, (long)5000L);
        return deploymentSupplier.get();
    }
}

