/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test.audit;

import com.atlassian.bitbucket.async.AsyncTestUtils;
import com.atlassian.bitbucket.async.WaitCondition;
import com.atlassian.bitbucket.test.DefaultFuncTestData;
import com.atlassian.bitbucket.test.ProductTopology;
import com.atlassian.bitbucket.test.RestTestHelper;
import com.atlassian.bitbucket.test.audit.Audit;
import com.atlassian.bitbucket.test.audit.AuditTestUtils;
import com.atlassian.bitbucket.test.audit.AuditVerifier;
import com.atlassian.bitbucket.test.audit.VerifyAudited;
import com.google.common.collect.ImmutableMap;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.specification.RequestSpecification;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.ws.rs.core.Response;
import net.sf.json.JSONObject;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class RestAuditVerifier
implements AuditVerifier {
    private static final long AUDIT_LOGGING_TIMEOUT_MILLIS = 10000L;
    private Instant startTime;

    @Override
    public void startRecording() {
        this.startTime = Instant.now();
    }

    @Override
    public void verify(VerifyAudited verifyAudited) {
        AsyncTestUtils.waitFor((WaitCondition)this.logsContain(verifyAudited.value()), (long)10000L);
    }

    private WaitCondition logsContain(Audit[] audits) {
        final Matcher logMatcher = CoreMatchers.hasItems((Matcher[])Arrays.stream(audits).map(this::matchesJson).collect(Collectors.toList()).toArray(new Matcher[0]));
        return new WaitCondition(){
            private List<JSONObject> auditEvents;

            public void describeFailure(Description description) {
                description.appendText("\nExpected: ");
                logMatcher.describeTo(description);
                description.appendText("\nActual: ");
                logMatcher.describeMismatch(this.auditEvents, description);
            }

            public boolean test() {
                Response response = (Response)((RequestSpecification)RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).given().log().ifValidationFails()).auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).contentType("application/json").expect().when().get(DefaultFuncTestData.getBaseURL() + "/rest/auditing/latest/events?from=" + RestAuditVerifier.this.startTime, new Object[0]);
                this.auditEvents = RestTestHelper.extractValues(response.getBody().jsonPath(), "entities");
                return logMatcher.matches(this.auditEvents);
            }
        };
    }

    private Matcher<JSONObject> matchesJson(final Audit audit) {
        return new TypeSafeMatcher<JSONObject>(){

            public void describeTo(Description description) {
                description.appendText("an event with attributes: ").appendValue((Object)ImmutableMap.builder().put((Object)"action", (Object)audit.action()).put((Object)"affectedObjects", Arrays.stream(audit.affectedObjects()).map(a -> String.format("{name: %s, type: %s}", a.name(), a.type())).collect(Collectors.toList())).put((Object)"author", (Object)audit.user()).put((Object)"category", (Object)audit.category()).put((Object)"changedValues", Arrays.stream(audit.changedValues()).map(a -> String.format("{key: %s, to: %s, from: %s}", a.key(), a.to(), a.from())).collect(Collectors.toList())).put((Object)"extraAttributes", Arrays.stream(audit.attributes()).map(a -> String.format("{name: %s, value: %s}", a.name(), a.value())).collect(Collectors.toList())).put((Object)"source", (Object)audit.source()).put((Object)"system", (Object)audit.system()).build());
            }

            protected void describeMismatchSafely(JSONObject item, Description mismatchDescription) {
                String action = item.getJSONObject("type").getString("action");
                if (audit.action().equals(action)) {
                    mismatchDescription.appendText("\nPartially matching event: ").appendValue((Object)item);
                } else {
                    mismatchDescription.appendText("\nEvent with the mismatching action ").appendValue((Object)action);
                }
            }

            protected boolean matchesSafely(JSONObject json) {
                JSONObject type = json.getJSONObject("type");
                String action = Objects.requireNonNull(type.getString("action"), "type.action");
                if (!action.equals(audit.action())) {
                    return false;
                }
                String category = Objects.requireNonNull(type.getString("category"), "type.category");
                List rawAffectedObjects = (List)Objects.requireNonNull(json.getJSONArray("affectedObjects"), "affectedObjects");
                List affectedObjects = rawAffectedObjects.stream().map(AuditTestUtils::buildAffectedObject).collect(Collectors.toList());
                List rawAttributes = (List)Objects.requireNonNull(json.getJSONArray("extraAttributes"), "extraAttributes");
                List attributes = rawAttributes.stream().map(AuditTestUtils::buildAttribute).collect(Collectors.toList());
                List rawChangedValues = (List)Objects.requireNonNull(json.getJSONArray("changedValues"), "changedValues");
                List changedValues = rawChangedValues.stream().map(AuditTestUtils::buildChangedValue).collect(Collectors.toList());
                String author = Objects.requireNonNull(json.getJSONObject("author").getString("name"), "author.name");
                String method = json.getString("method");
                Optional<String> source = Optional.ofNullable((String)json.get("source"));
                String system = json.getString("system");
                return affectedObjects.containsAll(Arrays.asList(audit.affectedObjects())) && attributes.containsAll(Arrays.asList(audit.attributes())) && author.equals(audit.user()) && changedValues.containsAll(Arrays.asList(audit.changedValues())) && category.equals(audit.category()) && source.map(s -> s.equals(audit.source()) || "0:0:0:0:0:0:0:1".equals(s) || ProductTopology.get().equals((Object)ProductTopology.BITBUCKET_CLUSTER_PAIR)).orElse(true) != false && system.equals(audit.system()) && method.equals(audit.method());
            }
        };
    }
}

