/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test.audit;

import com.atlassian.bitbucket.test.audit.Audit;
import com.atlassian.bitbucket.test.audit.AuditFileVerifier;
import java.time.Instant;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;

public class LegacyAuditFileVerifier
extends AuditFileVerifier {
    public LegacyAuditFileVerifier(String baseUrl) {
        super(baseUrl, "atlassian-bitbucket-audit*.log");
    }

    @Override
    TypeSafeMatcher<String> matchesAuditPattern(final Audit audit, final Instant startTime) {
        String legacyLogFormat = "(%s|0:0:0:0:0:0:0:1|-) \\| %s \\| %s \\| (?<time>\\d+)+ \\| (%s|-) \\| .+ \\| - \\| -";
        final String regex = String.format("(%s|0:0:0:0:0:0:0:1|-) \\| %s \\| %s \\| (?<time>\\d+)+ \\| (%s|-) \\| .+ \\| - \\| -", audit.source(), audit.action(), audit.user(), StringUtils.firstNonEmpty((CharSequence[])new String[]{audit.target(), ".*"}));
        final Pattern pattern = Pattern.compile(regex);
        return new TypeSafeMatcher<String>(){

            protected boolean matchesSafely(String item) {
                Matcher matcher = pattern.matcher(item);
                return matcher.matches() && this.loggedAfterStartTime(matcher);
            }

            public void describeTo(Description description) {
                description.appendText("a line matching the regex ").appendText(regex).appendText(" and timestamp after " + startTime.toEpochMilli());
            }

            protected void describeMismatchSafely(String item, Description mismatchDescription) {
                if (item.contains(audit.action())) {
                    mismatchDescription.appendText("\nPartially matching line: ").appendValue((Object)item);
                } else {
                    mismatchDescription.appendText("\nLine containing the mismatching action \"" + item.split("\\|")[1].trim() + "\"");
                }
            }

            private boolean loggedAfterStartTime(Matcher matcher) {
                Instant logTime = Instant.ofEpochMilli(Long.parseLong(matcher.group("time")));
                return logTime.isAfter(startTime);
            }
        };
    }
}

