/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test.audit;

import com.atlassian.bitbucket.test.audit.AffectedObject;
import com.atlassian.bitbucket.test.audit.Attribute;
import com.atlassian.bitbucket.test.audit.ChangedValue;
import java.lang.annotation.Annotation;
import java.util.Map;

class AuditTestUtils {
    private AuditTestUtils() {
        throw new UnsupportedOperationException(this.getClass().getName() + " is a utility class and should not be instantiated");
    }

    static AffectedObject buildAffectedObject(final Map<String, String> rawAffectedObject) {
        return new AffectedObject(){

            @Override
            public Class<? extends Annotation> annotationType() {
                return AffectedObject.class;
            }

            @Override
            public String name() {
                return (String)rawAffectedObject.get("name");
            }

            @Override
            public String type() {
                return rawAffectedObject.getOrDefault("type", "");
            }
        };
    }

    static Attribute buildAttribute(final Map<String, String> rawAttribute) {
        return new Attribute(){

            @Override
            public Class<? extends Annotation> annotationType() {
                return Attribute.class;
            }

            @Override
            public String name() {
                return (String)rawAttribute.get("name");
            }

            @Override
            public String value() {
                return rawAttribute.getOrDefault("value", "");
            }
        };
    }

    static ChangedValue buildChangedValue(final Map<String, String> rawChangedValue) {
        return new ChangedValue(){

            @Override
            public Class<? extends Annotation> annotationType() {
                return ChangedValue.class;
            }

            @Override
            public String from() {
                return rawChangedValue.getOrDefault("from", "");
            }

            @Override
            public String key() {
                return (String)rawChangedValue.get("key");
            }

            @Override
            public String to() {
                return rawChangedValue.getOrDefault("to", "");
            }
        };
    }
}

