/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test.audit;

import com.atlassian.bitbucket.async.AsyncTestUtils;
import com.atlassian.bitbucket.async.WaitCondition;
import com.atlassian.bitbucket.test.AuditTestHelper;
import com.atlassian.bitbucket.test.audit.Audit;
import com.atlassian.bitbucket.test.audit.AuditVerifier;
import com.atlassian.bitbucket.test.audit.VerifyAudited;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public abstract class AuditFileVerifier
implements AuditVerifier {
    private static final long AUDIT_LOGGING_TIMEOUT_MILLIS = 10000L;
    protected final String baseUrl;
    private final String filesPattern;
    private Instant startTime;

    protected AuditFileVerifier(String baseUrl, String filesPattern) {
        this.baseUrl = baseUrl;
        this.filesPattern = filesPattern;
    }

    @Override
    public void startRecording() {
        this.clearLogFilesContent();
        this.startTime = Instant.now();
    }

    @Override
    public void verify(VerifyAudited verifyAudited) {
        Arrays.asList(verifyAudited.value()).forEach(audit -> AsyncTestUtils.waitFor((WaitCondition)this.logsContain((Audit)audit), (long)10000L, (long)50L));
    }

    private void clearLogFilesContent() {
        AuditTestHelper.clearAuditLogFilesContent(this.baseUrl, this.filesPattern);
    }

    private WaitCondition logsContain(Audit audit) {
        final Matcher logMatcher = CoreMatchers.hasItem(this.matchesAuditPattern(audit, this.startTime));
        return new WaitCondition(){
            private List<String> auditLogs;

            public boolean test() {
                this.auditLogs = AuditFileVerifier.this.getLogFilesContent();
                return logMatcher.matches(this.auditLogs);
            }

            public void describeFailure(Description description) {
                description.appendText("\nExpected: ");
                logMatcher.describeTo(description);
                description.appendText("\nActual: ");
                logMatcher.describeMismatch(this.auditLogs, description);
            }
        };
    }

    private List<String> getLogFilesContent() {
        return AuditTestHelper.getAuditLogFilesContent(this.baseUrl, this.filesPattern);
    }

    abstract TypeSafeMatcher<String> matchesAuditPattern(Audit var1, Instant var2);
}

