/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test.audit;

import com.atlassian.audit.entity.CoverageArea;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.bitbucket.test.audit.Audit;
import com.atlassian.bitbucket.test.audit.AuditFileVerifier;
import com.atlassian.bitbucket.test.audit.AuditTestUtils;
import com.google.common.collect.ImmutableMap;
import io.restassured.path.json.JsonPath;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;

public class AdvancedAuditFileVerifier
extends AuditFileVerifier {
    public AdvancedAuditFileVerifier(String baseUrl) {
        super(baseUrl, "*.audit.log");
    }

    @Override
    TypeSafeMatcher<String> matchesAuditPattern(final Audit audit, final Instant startTime) {
        return new TypeSafeMatcher<String>(){

            public void describeTo(Description description) {
                description.appendText("an event with attributes: ").appendValue((Object)ImmutableMap.builder().put((Object)"action", (Object)audit.action()).put((Object)"affectedObjects", Arrays.stream(audit.affectedObjects()).map(a -> String.format("{name: %s, type: %s}", a.name(), a.type())).collect(Collectors.toList())).put((Object)"author", (Object)audit.user()).put((Object)"category", (Object)audit.category()).put((Object)"changedValues", Arrays.stream(audit.changedValues()).map(a -> String.format("{key: %s, to: %s, from: %s}", a.key(), a.to(), a.from())).collect(Collectors.toList())).put((Object)"coverageArea", (Object)audit.coverageArea()).put((Object)"coverageLevel", (Object)audit.coverageLevel()).put((Object)"extraAttributes", Arrays.stream(audit.attributes()).map(a -> String.format("{name: %s, value: %s}", a.name(), a.value())).collect(Collectors.toList())).put((Object)"method", (Object)audit.method()).put((Object)"source", (Object)audit.source()).put((Object)"system", (Object)audit.system()).put((Object)"target", (Object)audit.target()).build()).appendText(" and timestamp after " + startTime.getEpochSecond());
            }

            protected void describeMismatchSafely(String item, Description mismatchDescription) {
                String action = JsonPath.from((String)item).getString("auditType.action");
                if (audit.action().equals(action)) {
                    mismatchDescription.appendText("\nPartially matching event: ").appendValue((Object)item);
                } else {
                    mismatchDescription.appendText("\nEvent with the mismatching action ").appendValue((Object)action);
                }
            }

            protected boolean matchesSafely(String item) {
                JsonPath json = JsonPath.from((String)item);
                String action = Objects.requireNonNull(json.getString("auditType.action"), "auditType.action");
                if (!action.equals(audit.action())) {
                    return false;
                }
                List rawAffectedObjects = Objects.requireNonNull(json.getList("affectedObjects"), "affectedObjects");
                List affectedObjects = rawAffectedObjects.stream().map(AuditTestUtils::buildAffectedObject).collect(Collectors.toList());
                List rawAttributes = Objects.requireNonNull(json.getList("extraAttributes"), "extraAttributes");
                List attributes = rawAttributes.stream().map(AuditTestUtils::buildAttribute).collect(Collectors.toList());
                String author = Objects.requireNonNull(json.getString("author.name"), "author.name");
                String category = Objects.requireNonNull(json.getString("auditType.category"), "auditType.category");
                List rawChangedValues = Objects.requireNonNull(json.getList("changedValues"), "changedValues");
                List changedValues = rawChangedValues.stream().map(AuditTestUtils::buildChangedValue).collect(Collectors.toList());
                CoverageArea coverageArea = CoverageArea.valueOf((String)Objects.requireNonNull(json.getString("auditType.area"), "auditType.area"));
                CoverageLevel coverageLevel = CoverageLevel.valueOf((String)Objects.requireNonNull(json.getString("auditType.level"), "auditType.level"));
                Optional<String> method = Optional.ofNullable(json.getString("method"));
                Optional<String> source = Optional.ofNullable(json.getString("source"));
                Optional<String> system = Optional.ofNullable(json.getString("system"));
                Optional<String> target = Optional.ofNullable(json.getString("extraAttributes.find{it.name=='target'}.value"));
                String version = Objects.requireNonNull(json.getString("version"), "version");
                return affectedObjects.containsAll(Arrays.asList(audit.affectedObjects())) && attributes.containsAll(Arrays.asList(audit.attributes())) && author.equals(audit.user()) && category.equals(audit.category()) && changedValues.containsAll(Arrays.asList(audit.changedValues())) && coverageArea == audit.coverageArea() && coverageLevel == audit.coverageLevel() && version.equals(audit.version()) && source.map(s -> s.equals(audit.source()) || "0:0:0:0:0:0:0:1".equals(s)).orElse(true) != false && system.map(s -> s.equals(audit.system())).orElse(true) != false && (StringUtils.isEmpty((CharSequence)audit.target()) || target.map(t -> t.equals(audit.target())).orElse(true) != false) && method.map(m -> m.equals(audit.method())).orElse(true) != false && this.loggedAfterStartTime(item);
            }

            private boolean loggedAfterStartTime(String item) {
                JsonPath json = JsonPath.from((String)item);
                Instant logTime = Instant.ofEpochSecond(json.getLong("timestamp.epochSecond"), json.getLong("timestamp.nano"));
                return logTime.isAfter(startTime);
            }
        };
    }
}

