/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test;

import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.audit.rest.model.CoverageAreaJson;
import com.atlassian.audit.rest.model.EffectiveCoverageLevelJson;
import com.atlassian.bitbucket.mail.MailHostConfiguration;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.rest.project.RestProject;
import com.atlassian.bitbucket.test.AuditTestHelper;
import com.atlassian.bitbucket.test.BranchTestHelper;
import com.atlassian.bitbucket.test.DefaultFuncTestData;
import com.atlassian.bitbucket.test.GroupTestHelper;
import com.atlassian.bitbucket.test.LicenseTestHelper;
import com.atlassian.bitbucket.test.MailServerConfigHelper;
import com.atlassian.bitbucket.test.PermissionsTestHelper;
import com.atlassian.bitbucket.test.ProcessTestHelper;
import com.atlassian.bitbucket.test.ProductTopology;
import com.atlassian.bitbucket.test.ProjectTestHelper;
import com.atlassian.bitbucket.test.PullRequestTestHelper;
import com.atlassian.bitbucket.test.RepositoryTestHelper;
import com.atlassian.bitbucket.test.SshAccessKeysTestHelper;
import com.atlassian.bitbucket.test.SshKeyTestHelper;
import com.atlassian.bitbucket.test.TagTestHelper;
import com.atlassian.bitbucket.test.TaskTestHelper;
import com.atlassian.bitbucket.test.ThrowableUtils;
import com.atlassian.bitbucket.test.UserTestHelper;
import com.atlassian.bitbucket.test.rest.RestProjects;
import com.atlassian.bitbucket.test.rest.mirror.MirroringInstallationHelper;
import com.atlassian.bitbucket.test.rest.mirror.MirroringRequestHelper;
import com.atlassian.bitbucket.test.rest.server.stub.mirror.MirrorStub;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import javax.ws.rs.core.Response;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.mutable.MutableInt;
import org.codehaus.jackson.map.ObjectMapper;
import org.junit.Assert;
import org.junit.rules.ExternalResource;
import org.junit.rules.TemporaryFolder;
import org.junit.runners.model.MultipleFailureException;
import org.springframework.core.io.Resource;

public class TestContext
extends ExternalResource
implements AutoCloseable {
    public static final String DEFAULT_EMAIL_HOST = "@testdata.atlassian.com";
    private static final List<String> FEATURE_DISCOVERY_KEYS = Arrays.asList("sidebar", "side-by-side-diff-discovery");
    private static final long REPOSITORY_WAIT_TIMEOUT = 2500L;
    private static final long CLUSTER_REPOSITORY_WAIT_TIMEOUT = 10000L;
    private final Set<CreatedAccessKey> accessKeys = new HashSet<CreatedAccessKey>();
    private final Set<Integer> accountKeys = new HashSet<Integer>();
    private final Set<CreatedBranch> createdBranches = new HashSet<CreatedBranch>();
    private final Set<CreatedRepository> createdForks = new HashSet<CreatedRepository>();
    private final Set<String> createdGroups = new HashSet<String>();
    private final Set<String> createdProjects = new HashSet<String>();
    private final Set<PullRequestTestHelper> createdPullRequests = new HashSet<PullRequestTestHelper>();
    private final Set<CreatedRepository> createdRepositories = new HashSet<CreatedRepository>();
    private final Set<CreatedTag> createdTags = new HashSet<CreatedTag>();
    private final Set<TaskTestHelper> createdTasks = new HashSet<TaskTestHelper>();
    private final Set<String> createdUsers = new HashSet<String>();
    private final Set<Integer> mirroringRequests = new HashSet<Integer>();
    private final Set<MirrorStub> installedMirrors = new HashSet<MirrorStub>();
    private final List<Throwable> errors = new ArrayList<Throwable>();
    private final Set<GrantedPermission> grantedPermissions = new HashSet<GrantedPermission>();
    private Map<CoverageAreaJson, EffectiveCoverageLevelJson> originalAuditCoverageLevels;
    private Optional<MailHostConfiguration> origMailHostConfiguration;
    private String originalLicense;
    private Optional<String> origSenderAddress;

    protected void after() {
        try {
            this.cleanup();
        }
        catch (Throwable throwable) {
            throw Throwables.propagate((Throwable)throwable);
        }
    }

    public TestContext accessKey(String projKey, Permission permission, String publicKey) {
        return this.accessKey(projKey, null, permission, publicKey);
    }

    public TestContext accessKey(String projKey, String repoSlug, Permission permission, String publicKey) {
        return this.ensureCleanup(() -> {
            Response response = repoSlug != null ? SshAccessKeysTestHelper.add(projKey, repoSlug, permission, publicKey) : SshAccessKeysTestHelper.add(projKey, permission, publicKey);
            Map keyMap = response.getBody().jsonPath().getMap("key");
            if (keyMap != null) {
                Integer keyId = (Integer)keyMap.get("id");
                this.accessKeys.add(new CreatedAccessKey(keyId, projKey, repoSlug));
            }
            return this;
        });
    }

    public TestContext accountKey(String username, String keyText) {
        return this.ensureCleanup(() -> {
            Response response = SshKeyTestHelper.addSshKey(username, keyText);
            Map keyMap = response.getBody().jsonPath().getMap("");
            if (keyMap != null) {
                this.accountKeys.add((Integer)keyMap.get("id"));
            }
            return this;
        });
    }

    public TestContext addCreatedBranch(String projectKey, String repoSlug, String branchName) {
        this.createdBranches.add(new CreatedBranch(projectKey, repoSlug, branchName));
        return this;
    }

    public void addCreatedGroup(String group) {
        this.createdGroups.add(group);
    }

    public TestContext addCreatedTag(String projectKey, String repoSlug, String tagName) {
        this.createdTags.add(new CreatedTag(projectKey, repoSlug, tagName));
        return this;
    }

    public void addCreatedUser(String username) {
        this.createdUsers.add(username);
    }

    public TestContext branch(String projectKey, String repoSlug, String branchName, String branchFrom) {
        return this.ensureCleanup(() -> {
            BranchTestHelper.createBranch(projectKey, repoSlug, branchName, branchFrom);
            return this.addCreatedBranch(projectKey, repoSlug, branchName);
        });
    }

    public void cleanup() throws Throwable {
        this.cleanupAccountKeys();
        this.cleanupAccessKeys();
        this.cleanupPullRequests();
        this.cleanupTags();
        this.cleanupBranches();
        this.cleanupRepositories();
        this.cleanupPermissions();
        this.cleanupProjects();
        this.cleanupUsers();
        this.cleanupGroups();
        this.cleanupTasks();
        this.cleanupMailConfig();
        this.cleanupInstalledMirrors();
        this.cleanupMirroringRequests();
        this.cleanupAuditCoverageLevel();
        this.cleanupLicense();
        MultipleFailureException.assertEmpty(this.errors);
    }

    public TestContext auditCoverageLevel(CoverageLevel level) {
        return this.ensureCleanup(() -> {
            if (this.originalAuditCoverageLevels == null) {
                this.originalAuditCoverageLevels = AuditTestHelper.getLevels();
            }
            AuditTestHelper.setLevelForAllAreas(level);
            return this;
        });
    }

    public TestContext mailConfig(MailHostConfiguration configuration, String senderAddress) {
        if (this.origMailHostConfiguration == null) {
            this.origMailHostConfiguration = Optional.ofNullable(MailServerConfigHelper.getMailHostConfiguration());
        }
        if (this.origSenderAddress == null) {
            this.origSenderAddress = Optional.ofNullable(MailServerConfigHelper.getSenderAddress());
        }
        MailServerConfigHelper.setConfig(configuration, senderAddress);
        return this;
    }

    public TestContext license(String license) {
        if (this.originalLicense == null) {
            this.originalLicense = LicenseTestHelper.getLicense();
        }
        LicenseTestHelper.setLicense(license);
        return this;
    }

    public TestContext project(String projectKey) {
        return this.project(projectKey, (Consumer<Integer>)null);
    }

    public TestContext project(String projectKey, String projectName) {
        return this.project(projectKey, projectName, (Consumer<Integer>)null);
    }

    public TestContext project(String projectKey, String projectName, String projectDescription) {
        return this.project(projectKey, projectName, projectDescription, (Consumer<Integer>)null);
    }

    public TestContext project(String projectKey, String projectName, String projectDescription, String projectAvatar) {
        return this.project(projectKey, projectName, projectDescription, projectAvatar, null);
    }

    public TestContext project(String projectKey, Consumer<Integer> projectIdConsumer) {
        return this.project(projectKey, projectKey, projectIdConsumer);
    }

    public TestContext project(String projectKey, String projectName, Consumer<Integer> projectIdConsumer) {
        return this.project(projectKey, projectName, "Project description for " + projectName, projectIdConsumer);
    }

    public TestContext project(String projectKey, String projectName, String projectDescription, Consumer<Integer> projectIdConsumer) {
        return this.project(projectKey, projectName, projectDescription, null, projectIdConsumer);
    }

    public TestContext project(String projectKey, String projectName, String projectDescription, String projectAvatar, Consumer<Integer> projectIdConsumer) {
        return this.ensureCleanup(() -> {
            Response response = ProjectTestHelper.createProject(projectKey, projectName, projectDescription, projectAvatar);
            if (projectIdConsumer != null) {
                projectIdConsumer.accept(response.jsonPath().getInt("id"));
            }
            this.createdProjects.add(projectKey);
            return this;
        });
    }

    public TestContext projects(String projectKeyFormat, String projectNameFormat, int projectCount) {
        return this.projects(projectKeyFormat, projectNameFormat, "Project description for %s", projectCount);
    }

    public TestContext projects(String projectKeyFormat, String projectNameFormat, String projectDescriptionFormat, int projectCount) {
        return this.ensureCleanup(() -> {
            Response response = ProjectTestHelper.createProjects(projectKeyFormat, projectNameFormat, projectDescriptionFormat, projectCount);
            try {
                RestProjects projects = (RestProjects)((Object)((Object)new ObjectMapper().readValue(response.body().print(), RestProjects.class)));
                projects.getProjects().stream().map(RestProject::getKey).forEach(this.createdProjects::add);
            }
            catch (Exception e) {
                return this;
            }
            return this;
        });
    }

    public TestContext repository(String projectKey, String repositorySlug) {
        return this.repository(projectKey, repositorySlug, (Consumer<Integer>)null);
    }

    public TestContext repository(String projectKey, String repositoryName, boolean publiclyAccessible) {
        return this.repository(projectKey, repositoryName, publiclyAccessible, null);
    }

    public TestContext repository(String projectKey, String repositoryName, Resource repoZip) {
        return this.repository(projectKey, repositoryName, repoZip, (Function<? super ProcessTestHelper, Object>)((Function)helper -> null), null);
    }

    public TestContext repository(String projectKey, String repositoryName, Resource repoZip, boolean publiclyAccessible) {
        return this.repository(projectKey, repositoryName, repoZip, (Function<? super ProcessTestHelper, Object>)((Function)helper -> null), publiclyAccessible, null);
    }

    public TestContext repository(String projectKey, String repositoryName, Resource repoZip, Function<? super ProcessTestHelper, Object> callback) {
        return this.repository(projectKey, repositoryName, repoZip, callback, false, null);
    }

    public TestContext repository(String projectKey, String repositorySlug, Consumer<Integer> repositoryIdConsumer) {
        return this.repository(projectKey, repositorySlug, false, repositoryIdConsumer);
    }

    public TestContext repository(String projectKey, String repositoryName, boolean publiclyAccessible, Consumer<Integer> repositoryIdConsumer) {
        return this.ensureCleanup(() -> {
            CreatedRepository createdRepository = this.doCreateRepository(projectKey, repositoryName, publiclyAccessible);
            if (repositoryIdConsumer != null) {
                repositoryIdConsumer.accept(createdRepository.id);
            }
            return this;
        });
    }

    public TestContext repository(String projectKey, String repositoryName, Resource repoZip, Consumer<Integer> repositoryIdConsumer) {
        return this.repository(projectKey, repositoryName, repoZip, (Function<? super ProcessTestHelper, Object>)((Function)helper -> null), repositoryIdConsumer);
    }

    public TestContext repository(String projectKey, String repositoryName, Resource repoZip, boolean publiclyAccessible, Consumer<Integer> repositoryIdConsumer) {
        return this.repository(projectKey, repositoryName, repoZip, (Function<? super ProcessTestHelper, Object>)((Function)helper -> null), publiclyAccessible, repositoryIdConsumer);
    }

    public TestContext repository(String projectKey, String repositoryName, Resource repoZip, Function<? super ProcessTestHelper, Object> callback, Consumer<Integer> repositoryIdConsumer) {
        return this.repository(projectKey, repositoryName, repoZip, callback, false, repositoryIdConsumer);
    }

    private TestContext repository(String projectKey, String repositoryName, Resource repoZip, Function<? super ProcessTestHelper, Object> callback, boolean publiclyAccessible, Consumer<Integer> repositoryIdConsumer) {
        CreatedRepository created = this.doCreateRepository(projectKey, repositoryName, publiclyAccessible);
        if (repositoryIdConsumer != null) {
            repositoryIdConsumer.accept(created.id);
        }
        return this.ensureCleanup(() -> {
            TemporaryFolder temporaryFolder = new TemporaryFolder();
            temporaryFolder.create();
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                RepositoryTestHelper.pushRep(temporaryFolder, DefaultFuncTestData.getBaseURL(), DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword(), projectKey, created.slug, repoZip, callback);
                TestContext testContext = this;
                return testContext;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                temporaryFolder.delete();
            }
        });
    }

    public TestContext fork(String projectKey, String repoKey, String username, String password) {
        return this.fork(projectKey, repoKey, username, password, null);
    }

    public TestContext fork(String projectKey, String repoKey, String username, String password, Consumer<Integer> repositoryIdConsumer) {
        return this.ensureCleanup(() -> {
            Response response = RepositoryTestHelper.forkRepositoryAndWait(projectKey, repoKey, username, password, this.getTimeout());
            this.createdForks.add(new CreatedRepository((Integer)RepositoryTestHelper.getIdFromResponse(response), "~" + username, repoKey, (String)RepositoryTestHelper.getNameFromResponse(response)));
            if (repositoryIdConsumer != null) {
                repositoryIdConsumer.accept((Integer)RepositoryTestHelper.getIdFromResponse(response));
            }
            return this;
        });
    }

    public TestContext forkNonPersonal(String projectKey, String repoKey, String destProjectKey, String destRepoKey) {
        return this.forkNonPersonal(projectKey, repoKey, destProjectKey, destRepoKey, null);
    }

    public TestContext forkNonPersonal(String projectKey, String repoKey, String destProjectKey, String destRepoKey, Consumer<Integer> repositoryIdConsumer) {
        return this.ensureCleanup(() -> {
            Response response = RepositoryTestHelper.forkNonPersonalRepositoryAndWait(projectKey, repoKey, destProjectKey, destRepoKey, this.getTimeout());
            this.createdForks.add(new CreatedRepository((Integer)RepositoryTestHelper.getIdFromResponse(response), destProjectKey, destRepoKey, (String)RepositoryTestHelper.getNameFromResponse(response)));
            if (repositoryIdConsumer != null) {
                repositoryIdConsumer.accept((Integer)RepositoryTestHelper.getIdFromResponse(response));
            }
            return this;
        });
    }

    public TestContext group(String group, String ... users) {
        return this.ensureCleanup(() -> {
            GroupTestHelper.createGroups(group);
            for (String user : users) {
                GroupTestHelper.addUserToGroup(group, user);
            }
            this.addCreatedGroup(group);
            return this;
        });
    }

    public TestContext tag(String projectKey, String repoSlug, String tagName, String commitId) {
        return this.ensureCleanup(() -> {
            TagTestHelper.createTag(projectKey, repoSlug, tagName, commitId);
            return this.addCreatedTag(projectKey, repoSlug, tagName);
        });
    }

    public TestContext tag(String projectKey, String repoSlug, String tagName, String commitId, String message) {
        return this.ensureCleanup(() -> {
            TagTestHelper.createTag(projectKey, repoSlug, tagName, commitId, message);
            return this.addCreatedTag(projectKey, repoSlug, tagName);
        });
    }

    public TestContext user(String username) {
        return this.user(username, username, username, username + DEFAULT_EMAIL_HOST);
    }

    public TestContext user(String username, boolean addToDefaultGroup) {
        return this.user(username, username, username, username + DEFAULT_EMAIL_HOST, addToDefaultGroup);
    }

    public TestContext user(String username, String password) {
        return this.user(username, username, password, username + DEFAULT_EMAIL_HOST);
    }

    public TestContext user(String username, String displayName, String password) {
        return this.user(username, displayName, password, username + DEFAULT_EMAIL_HOST);
    }

    public TestContext user(String username, String displayName, String password, String emailAddress) {
        return this.user(username, displayName, password, emailAddress, true);
    }

    public TestContext user(String username, String displayName, String password, String emailAddress, boolean addToDefaultGroup) {
        return this.ensureCleanup(() -> {
            UserTestHelper.createUser(username, displayName, password, emailAddress, addToDefaultGroup);
            this.addCreatedUser(username);
            return this;
        });
    }

    public TestContext globalPermission(String username, Permission permission) {
        Preconditions.checkArgument((boolean)permission.isGlobal());
        return this.ensureCleanup(() -> {
            PermissionsTestHelper.setGlobalPermissionForUser(username, permission.name());
            this.grantedPermissions.add(new GrantedPermission(GrantedPermission.EntityType.USER, username, permission, null, null));
            return this;
        });
    }

    public TestContext globalPermissionForGroup(String group, Permission permission) {
        Preconditions.checkArgument((boolean)permission.isGlobal());
        return this.ensureCleanup(() -> {
            PermissionsTestHelper.setGlobalPermissionForGroup(group, permission.name());
            this.grantedPermissions.add(new GrantedPermission(GrantedPermission.EntityType.GROUP, group, permission, null, null));
            return this;
        });
    }

    public TestContext moveRepository(String sourceProjectKey, String repositorySlug, String targetProjectKey) {
        Optional<CreatedRepository> existingRepository = this.findCreatedRepository(sourceProjectKey, repositorySlug);
        return this.ensureCleanup(() -> {
            String newProjectKey = RepositoryTestHelper.getProjectKeyFromResponse(RepositoryTestHelper.moveRepositoryToDifferentProject(sourceProjectKey, repositorySlug, targetProjectKey));
            existingRepository.ifPresent(r -> {
                this.createdRepositories.remove(r);
                this.createdRepositories.add(new CreatedRepository(r.id, newProjectKey, r.slug, r.name));
            });
            return this;
        });
    }

    public TestContext projectPermission(String projectKey, String username, Permission permission) {
        Preconditions.checkArgument((boolean)permission.isResource(Project.class));
        return this.ensureCleanup(() -> {
            PermissionsTestHelper.setProjectPermissionForUser(projectKey, username, permission.name());
            this.grantedPermissions.add(new GrantedPermission(GrantedPermission.EntityType.USER, username, permission, projectKey, null));
            return this;
        });
    }

    public TestContext projectPermissionForAllUsers(String projectKey, Permission permission) {
        Preconditions.checkArgument((boolean)permission.isResource(Project.class));
        return this.ensureCleanup(() -> {
            PermissionsTestHelper.setProjectPermissionForAllUsers(projectKey, permission.name(), true);
            this.grantedPermissions.add(new GrantedPermission(GrantedPermission.EntityType.USER, null, permission, projectKey, null));
            return this;
        });
    }

    public TestContext projectPermissionForGroup(String projectKey, String group, Permission permission) {
        Preconditions.checkArgument((boolean)permission.isResource(Project.class));
        return this.ensureCleanup(() -> {
            PermissionsTestHelper.setProjectPermissionForGroup(projectKey, group, permission.name());
            this.grantedPermissions.add(new GrantedPermission(GrantedPermission.EntityType.GROUP, group, permission, projectKey, null));
            return this;
        });
    }

    public TestContext repositoryPermission(String projectKey, String repoSlug, String username, Permission permission) {
        Preconditions.checkArgument((boolean)permission.isResource(Repository.class));
        return this.ensureCleanup(() -> {
            PermissionsTestHelper.setRepositoryPermissionForUser(projectKey, repoSlug, username, permission.name());
            this.grantedPermissions.add(new GrantedPermission(GrantedPermission.EntityType.USER, username, permission, projectKey, repoSlug));
            return this;
        });
    }

    public TestContext repositoryPermissionForGroup(String projectKey, String repoSlug, String group, Permission permission) {
        Preconditions.checkArgument((boolean)permission.isResource(Repository.class));
        return this.ensureCleanup(() -> {
            PermissionsTestHelper.setRepositoryPermissionForGroup(projectKey, repoSlug, group, permission.name());
            this.grantedPermissions.add(new GrantedPermission(GrantedPermission.EntityType.GROUP, group, permission, projectKey, repoSlug));
            return this;
        });
    }

    public TestContext noFeatureDiscovery(String username, String password) {
        for (String featureKey : FEATURE_DISCOVERY_KEYS) {
            RestAssured.given().auth().preemptive().basic(username, password).formParam("json", new Object[]{"{\"isAllDismissed\": true}"}).header(DefaultFuncTestData.HDR_XSRF_NO_CHECK).expect().statusCode(Response.Status.OK.getStatusCode()).when().put(DefaultFuncTestData.getRestURL("chaperone", "1") + "/chaperone/" + featureKey, new Object[0]);
        }
        return this;
    }

    public PullRequestTestHelper pullRequest(PullRequestTestHelper.Builder pullRequestBuilder) {
        return this.ensureCleanup(() -> {
            PullRequestTestHelper pullRequest = pullRequestBuilder.create();
            this.createdPullRequests.add(pullRequest);
            return pullRequest;
        });
    }

    public TestContext install(MirrorStub mirror) {
        MutableInt requestId = new MutableInt();
        this.mirroringRequest(mirror.getId(), mirror.getBaseUrl(), mirror.getDescriptorUrl(), response -> requestId.setValue((Number)RepositoryTestHelper.getIdFromResponse(response)));
        MirroringRequestHelper.acceptRequest(requestId.getValue());
        mirror.waitForInstallation();
        this.installedMirrors.add(mirror);
        return this;
    }

    public TestContext mirroringRequest(String id, String baseUrl, String descriptorUrl, Consumer<Response> responseConsumer) {
        Response response = MirroringRequestHelper.createMirroringRequestV0(id, baseUrl, descriptorUrl, Response.Status.OK);
        this.mirroringRequests.add(MirroringRequestHelper.getIdFromResponse(response));
        responseConsumer.accept(response);
        return this;
    }

    public TestContext mirroringRequest(String id, String mirrorType, String baseUrl, String descriptorUrl, Consumer<Response> responseConsumer) {
        Response response = MirroringRequestHelper.createMirroringRequestV1(id, mirrorType, baseUrl, descriptorUrl, Response.Status.OK);
        this.mirroringRequests.add(MirroringRequestHelper.getIdFromResponse(response));
        responseConsumer.accept(response);
        return this;
    }

    public TaskTestHelper task(TaskTestHelper.Builder taskBuilder) {
        return this.ensureCleanup(() -> {
            TaskTestHelper task = taskBuilder.create();
            this.createdTasks.add(task);
            return task;
        });
    }

    public TestContext updateRepositoryName(String projectKey, String sourceSlug, String newName) {
        Optional<CreatedRepository> existingRepository = this.findCreatedRepository(projectKey, sourceSlug);
        return this.ensureCleanup(() -> {
            String updatedSlug = RepositoryTestHelper.getSlugFromResponse(RepositoryTestHelper.updateRepositoryName(projectKey, sourceSlug, newName));
            existingRepository.ifPresent(r -> {
                this.createdRepositories.remove(r);
                this.createdRepositories.add(new CreatedRepository(r.id, r.projectKey, updatedSlug, r.name));
            });
            return this;
        });
    }

    private <T> T ensureCleanup(Callable<T> work) {
        try {
            return work.call();
        }
        catch (Throwable t) {
            try {
                this.cleanup();
            }
            catch (Throwable t2) {
                ThrowableUtils.throwUnchecked((Throwable)new MultipleFailureException(Arrays.asList(t, new Exception("An exception occurred while attempting to clean up", t2))));
            }
            ThrowableUtils.throwUnchecked(t);
            return null;
        }
    }

    private void cleanupAccountKeys() {
        for (Integer keyId : this.accountKeys) {
            try {
                SshKeyTestHelper.removeSshKey(keyId);
            }
            catch (Throwable t) {
                this.errors.add(new TestContextCleanupException("Failed to clean up account key " + keyId, t));
            }
        }
        this.accountKeys.clear();
    }

    private void cleanupAccessKeys() {
        for (CreatedAccessKey accessKey : this.accessKeys) {
            try {
                accessKey.revoke();
            }
            catch (Throwable t) {
                this.errors.add(new TestContextCleanupException("Failed to clean up access key " + accessKey, t));
            }
        }
        this.accessKeys.clear();
    }

    private void cleanupAuditCoverageLevel() {
        try {
            if (this.originalAuditCoverageLevels != null) {
                AuditTestHelper.setLevels(this.originalAuditCoverageLevels);
            }
        }
        catch (Throwable t) {
            this.errors.add(new TestContextCleanupException("Failed to set original audit coverage level: " + this.originalAuditCoverageLevels, t));
        }
    }

    private void cleanupBranches() {
        for (CreatedBranch branch : this.createdBranches) {
            try {
                BranchTestHelper.deleteBranch(branch.projectKey, branch.repoSlug, branch.branchName);
            }
            catch (Throwable t) {
                this.errors.add(new TestContextCleanupException("Failed to clean up branch " + branch, t));
            }
        }
        this.createdBranches.clear();
    }

    private void cleanupLicense() {
        if (this.originalLicense != null) {
            LicenseTestHelper.setLicense(this.originalLicense);
        }
    }

    private void cleanupMailConfig() {
        if (this.origMailHostConfiguration != null) {
            try {
                if (this.origMailHostConfiguration.isPresent()) {
                    MailServerConfigHelper.setConfig(this.origMailHostConfiguration.get());
                    this.origMailHostConfiguration = null;
                } else {
                    MailServerConfigHelper.deleteConfig();
                }
            }
            catch (Throwable t) {
                this.errors.add(new TestContextCleanupException("Failed to clear mail host configuration", t));
            }
        }
        if (this.origSenderAddress != null) {
            try {
                if (this.origSenderAddress.isPresent()) {
                    MailServerConfigHelper.setSenderAddress(this.origSenderAddress.get());
                    this.origSenderAddress = null;
                } else {
                    MailServerConfigHelper.clearSenderAddress();
                }
            }
            catch (Throwable t) {
                this.errors.add(new TestContextCleanupException("Failed to clear server email address", t));
            }
        }
    }

    private void cleanupPermissions() {
        for (GrantedPermission permission : this.grantedPermissions) {
            try {
                permission.revoke();
            }
            catch (Throwable t) {
                this.errors.add(new TestContextCleanupException("Failed to revoke permission " + permission, t));
            }
        }
        this.grantedPermissions.clear();
    }

    private void cleanupTags() {
        for (CreatedTag tag : this.createdTags) {
            try {
                TagTestHelper.deleteTag(tag.projectKey, tag.repoSlug, tag.tagName);
            }
            catch (Throwable t) {
                this.errors.add(new TestContextCleanupException("Failed to clean up tag " + tag, t));
            }
        }
        this.createdTags.clear();
    }

    private void cleanupUsers() {
        for (String username : this.createdUsers) {
            boolean retry = true;
            int maxRetries = 3;
            int i = 0;
            while (retry && i++ < maxRetries) {
                try {
                    UserTestHelper.deleteUsers(true, username);
                    retry = false;
                }
                catch (Throwable t) {
                    if (i == maxRetries) {
                        this.errors.add(new TestContextCleanupException("Failed to delete user " + username, t));
                    }
                    retry = true;
                }
            }
        }
        this.createdUsers.clear();
    }

    private void cleanupGroups() {
        for (String group : this.createdGroups) {
            try {
                GroupTestHelper.deleteGroups(true, group);
            }
            catch (Throwable t) {
                this.errors.add(new TestContextCleanupException("Failed to delete group " + group, t));
            }
        }
        this.createdGroups.clear();
    }

    private void cleanupRepositories() {
        this.createdForks.forEach(this::cleanupRepo);
        this.createdForks.clear();
        this.createdRepositories.forEach(this::cleanupRepo);
        this.createdRepositories.clear();
    }

    private void cleanupRepo(CreatedRepository createdRepository) {
        try {
            RepositoryTestHelper.deleteRepositoryAndWait(createdRepository.projectKey, createdRepository.slug, TestContext.getTimeoutForRepositoryCleanup());
        }
        catch (Throwable t) {
            this.errors.add(new TestContextCleanupException("Failed to delete repository " + createdRepository, t));
        }
    }

    private void cleanupProjects() {
        for (String projectKey : this.createdProjects) {
            try {
                Response response = ProjectTestHelper.deleteProject(projectKey);
                Assert.assertTrue((String)("Project " + projectKey + " was not deleted"), (response.getStatusCode() == Response.Status.NO_CONTENT.getStatusCode() || response.getStatusCode() == Response.Status.NOT_FOUND.getStatusCode() ? 1 : 0) != 0);
            }
            catch (Throwable t) {
                this.errors.add(new TestContextCleanupException("Failed to delete project " + projectKey, t));
            }
        }
        this.createdProjects.clear();
    }

    private void cleanupPullRequests() {
        for (PullRequestTestHelper pullRequest : this.createdPullRequests) {
            try {
                pullRequest.deleteSafe();
            }
            catch (Throwable t) {
                this.errors.add(new TestContextCleanupException("Failed to cleanup pull request " + pullRequest, t));
            }
        }
        this.createdPullRequests.clear();
    }

    private void cleanupTasks() {
        for (TaskTestHelper task : this.createdTasks) {
            try {
                task.deleteSafe();
            }
            catch (Throwable t) {
                this.errors.add(new TestContextCleanupException("Failed to delete task " + task, t));
            }
        }
        this.createdTasks.clear();
    }

    private void cleanupInstalledMirrors() {
        for (MirrorStub installedMirror : this.installedMirrors) {
            try {
                MirroringInstallationHelper.uninstall(installedMirror, Response.Status.NO_CONTENT);
            }
            catch (Throwable t) {
                this.errors.add(new TestContextCleanupException("Failed to uninstall mirror " + installedMirror.getBaseUrl(), t));
            }
        }
    }

    private void cleanupMirroringRequests() {
        for (Integer id : this.mirroringRequests) {
            try {
                MirroringRequestHelper.deleteRequest(id);
            }
            catch (Throwable t) {
                this.errors.add(new TestContextCleanupException("Failed to delete mirroring request " + id, t));
            }
        }
    }

    private CreatedRepository doCreateRepository(String projectKey, String repositoryName, boolean publiclyAccessible) {
        JSONObject repositoryBody = RepositoryTestHelper.createRepositoryBody(repositoryName);
        repositoryBody.put((Object)"public", (Object)publiclyAccessible);
        Response response = RepositoryTestHelper.createRepositoryAndWait(projectKey, this.getTimeout(), repositoryBody);
        String slug = RepositoryTestHelper.getSlugFromResponse(response);
        int id = (Integer)RepositoryTestHelper.getIdFromResponse(response);
        CreatedRepository result = new CreatedRepository(id, projectKey, slug, repositoryName);
        this.createdRepositories.add(result);
        return result;
    }

    private long getTimeout() {
        if (ProductTopology.get().equals((Object)ProductTopology.BITBUCKET_CLUSTER_PAIR)) {
            return 10000L;
        }
        return 2500L;
    }

    private Optional<CreatedRepository> findCreatedRepository(String projectKey, String repositorySlug) {
        return this.createdRepositories.stream().filter(cr -> cr != null && projectKey.equalsIgnoreCase(cr.projectKey) && repositorySlug.equalsIgnoreCase(cr.slug)).findFirst();
    }

    @Override
    public void close() throws Exception {
        try {
            this.cleanup();
        }
        catch (Throwable throwable) {
            Throwables.propagate((Throwable)throwable);
        }
    }

    public static <A> A perform(Function<TestContext, A> f) throws Exception {
        try (TestContext context = new TestContext();){
            Object object = f.apply((Object)context);
            return (A)object;
        }
    }

    private static long getTimeoutForRepositoryCleanup() {
        if (ProductTopology.get().equals((Object)ProductTopology.BITBUCKET_STANDALONE)) {
            return 1000L;
        }
        return 10000L;
    }

    private static class TestContextCleanupException
    extends Exception {
        public TestContextCleanupException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    private static class CreatedTag {
        public final String projectKey;
        public final String repoSlug;
        public final String tagName;

        private CreatedTag(String projectKey, String repoSlug, String tagName) {
            this.projectKey = projectKey;
            this.repoSlug = repoSlug;
            this.tagName = tagName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof CreatedTag) {
                CreatedTag t = (CreatedTag)o;
                return Objects.equals(this.projectKey, t.projectKey) && Objects.equals(this.repoSlug, t.repoSlug) && Objects.equals(this.tagName, t.tagName);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.projectKey, this.repoSlug, this.tagName);
        }

        public String toString() {
            return "{projectKey: " + this.projectKey + ", repoSlug:" + this.repoSlug + ", tagName: " + this.tagName + "}";
        }
    }

    private static class CreatedRepository {
        public final int id;
        public final String name;
        public final String projectKey;
        public final String slug;

        public CreatedRepository(int id, String projectKey, String slug, String name) {
            this.id = id;
            this.projectKey = projectKey;
            this.slug = slug;
            this.name = name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof CreatedRepository) {
                CreatedRepository r = (CreatedRepository)o;
                return Objects.equals(this.projectKey, r.projectKey) && Objects.equals(this.slug, r.slug);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.projectKey, this.slug);
        }

        public String toString() {
            return "{projectKey: " + this.projectKey + ", repoSlug:" + this.slug + "}";
        }
    }

    private static class GrantedPermission {
        public final Permission permission;
        public final String projectKey;
        public final String repoSlug;
        public final String entity;
        public final EntityType entityType;

        public GrantedPermission(EntityType entityType, String entity, Permission permission, String projectKey, String repoSlug) {
            this.entityType = entityType;
            this.entity = entity;
            this.permission = permission;
            this.projectKey = projectKey;
            this.repoSlug = repoSlug;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void revoke() {
            if (this.entityType == EntityType.USER) {
                if (this.permission.isGlobal()) {
                    PermissionsTestHelper.revokeGlobalPermissionsForUser(this.entity);
                    return;
                } else if (this.permission.isResource(Project.class)) {
                    if (this.entity == null) {
                        PermissionsTestHelper.setProjectPermissionForAllUsers(this.projectKey, this.permission.name(), false);
                        return;
                    } else {
                        PermissionsTestHelper.revokeProjectPermissionForUser(this.projectKey, this.entity);
                    }
                    return;
                } else {
                    if (!this.permission.isResource(Repository.class)) throw new IllegalStateException("Unknown permission: " + this.permission.name());
                    PermissionsTestHelper.revokeRepositoryPermissionForUser(this.projectKey, this.repoSlug, this.entity);
                }
                return;
            } else if (this.permission.isGlobal()) {
                PermissionsTestHelper.revokeGlobalPermissionsForGroup(this.entity);
                return;
            } else if (this.permission.isResource(Project.class)) {
                PermissionsTestHelper.revokeProjectPermissionForGroup(this.projectKey, this.entity);
                return;
            } else {
                if (!this.permission.isResource(Repository.class)) throw new IllegalStateException("Unknown permission: " + this.permission.name());
                PermissionsTestHelper.revokeRepositoryPermissionForGroup(this.projectKey, this.repoSlug, this.entity);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof GrantedPermission) {
                GrantedPermission gp = (GrantedPermission)o;
                return Objects.equals((Object)this.entityType, (Object)gp.entityType) && Objects.equals(this.entity, gp.entity) && Objects.equals(this.projectKey, gp.projectKey) && Objects.equals(this.repoSlug, gp.repoSlug) && Objects.equals(this.permission, gp.permission);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.entityType, this.entity, this.projectKey, this.repoSlug, this.permission});
        }

        public String toString() {
            return "{projectKey: " + this.projectKey + ", repoSlug:" + this.repoSlug + ", permission: " + this.permission + ", entityType: " + (Object)((Object)this.entityType) + ", entity: " + this.entity + "}";
        }

        public static enum EntityType {
            USER,
            GROUP;

        }
    }

    private static class CreatedBranch {
        public final String projectKey;
        public final String repoSlug;
        public final String branchName;

        private CreatedBranch(String projectKey, String repoSlug, String branchName) {
            this.projectKey = projectKey;
            this.repoSlug = repoSlug;
            this.branchName = branchName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof CreatedBranch) {
                CreatedBranch b = (CreatedBranch)o;
                return Objects.equals(this.projectKey, b.projectKey) && Objects.equals(this.repoSlug, b.repoSlug) && Objects.equals(this.branchName, b.branchName);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.projectKey, this.repoSlug, this.branchName);
        }

        public String toString() {
            return "{projectKey: " + this.projectKey + ", repoSlug:" + this.repoSlug + ", branchName: " + this.branchName + "}";
        }
    }

    private static class CreatedAccessKey {
        public final Integer keyId;
        public final String projectKey;
        public final String repoSlug;

        public CreatedAccessKey(Integer keyId, String projectKey, String repoSlug) {
            this.keyId = keyId;
            this.projectKey = projectKey;
            this.repoSlug = repoSlug;
        }

        public void revoke() {
            if (this.repoSlug == null) {
                SshAccessKeysTestHelper.revoke(this.projectKey, this.keyId);
            } else {
                SshAccessKeysTestHelper.revoke(this.projectKey, this.repoSlug, this.keyId);
            }
        }

        public String toString() {
            return "{projectKey: " + this.projectKey + ", repoSlug:" + this.repoSlug + ", keyId: " + this.keyId + "}";
        }
    }
}

