/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test;

import com.atlassian.bitbucket.async.AsyncTestUtils;
import com.atlassian.bitbucket.async.WaitCondition;
import com.atlassian.bitbucket.test.ClusterUtils;
import com.atlassian.bitbucket.test.DefaultFuncTestData;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import javax.ws.rs.core.Response;
import net.sf.json.JSONObject;
import org.hamcrest.Description;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchTestHelper {
    private static final int RETRY_INTERVAL = 5000;
    private static final long TIMEOUT = 90000L;
    private static final Logger log = LoggerFactory.getLogger(SearchTestHelper.class);

    public static boolean assertCodeSearchCount(String query, int expectedNumResults) {
        Response response = (Response)RestAssured.given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).contentType("application/json;charset=UTF-8").body(SearchTestHelper.codeSearchFor(query)).when().post(SearchTestHelper.getCodeSearchRestUrl(), new Object[0]);
        if (response.getStatusCode() == Response.Status.OK.getStatusCode() && response.getBody().jsonPath().getInt("code.count") == expectedNumResults) {
            return true;
        }
        log.warn("Returned code search count did not match. Expected code matches: {}   Status code: {}  Body: {}", new Object[]{expectedNumResults, response.getStatusCode(), response.getBody().prettyPrint()});
        return false;
    }

    public static String codeSearchFor(String query) {
        return new JSONObject().element("query", (Object)query).element("entities", (Map)new JSONObject().element("code", (Map)new JSONObject())).element("limits", (Map)new JSONObject().element("primary", 100).element("secondary", 10)).toString();
    }

    public static String getCodeSearchRestUrl() {
        return DefaultFuncTestData.getRestURL("search", "latest") + "/search";
    }

    public static int getRepositoryCount(String projectKey) {
        return SearchTestHelper.getCount(DefaultFuncTestData.getProjectRestURL("search", "latest", projectKey) + "/repos");
    }

    public static int getRepositoryCount(String projectKey, String filter) {
        return SearchTestHelper.getCount(DefaultFuncTestData.getProjectRestURL("search", "latest", projectKey) + "/repos?filter=" + filter);
    }

    public static int getRepositoryForkCount(String originProject, String originRepo) {
        return SearchTestHelper.getCount(DefaultFuncTestData.getRepositoryRestURL("search", "latest", originProject, originRepo) + "/forks");
    }

    public static boolean hasRepository(String projectKey, String repoName) {
        return SearchTestHelper.getRepositoryCount(projectKey, repoName) > 0;
    }

    public static String status() {
        String restURL = DefaultFuncTestData.getRestURL("indexing", "latest");
        return SearchTestHelper.status(restURL);
    }

    public static void sync() {
        String restURL = DefaultFuncTestData.getRestURL("indexing", "latest");
        SearchTestHelper.sync(restURL);
    }

    public static void waitForSearch() {
        AsyncTestUtils.waitFor((WaitCondition)new WaitCondition(){
            Set<Response> lastResponses = null;

            public void describeFailure(Description description) {
                if (this.lastResponses != null && !this.lastResponses.isEmpty()) {
                    description.appendText("Expected status code 200 but got: ");
                    this.lastResponses.stream().filter(Objects::nonNull).forEach(lastResponse -> description.appendValue((Object)lastResponse.getStatusCode()).appendText("\nBody: ").appendValue((Object)lastResponse.getBody().prettyPrint()));
                } else {
                    description.appendText("Expected status code 200 but got no response");
                }
            }

            public boolean test() {
                ClusterUtils.acceptOnEachNode(DefaultFuncTestData.getRestURL("indexing", "latest"), restUrl -> {
                    if (!"INDEXING".equals(SearchTestHelper.status(restUrl))) {
                        SearchTestHelper.sync(restUrl);
                    }
                });
                this.lastResponses = ClusterUtils.executeOnEachNode(DefaultFuncTestData.getProjectRestURL("search", "latest", DefaultFuncTestData.getProject1()) + "/repos", x$0 -> SearchTestHelper.getCountResponse(x$0));
                return this.lastResponses.stream().allMatch(r -> r.getStatusCode() == Response.Status.OK.getStatusCode());
            }
        }, (long)90000L, (long)5000L);
    }

    public static void waitForIndexing(final Supplier<Boolean> condition, final String errorMessage) {
        AsyncTestUtils.waitFor((WaitCondition)new WaitCondition(){

            public void describeFailure(Description description) {
                description.appendText("Objects were not indexed within ").appendValue((Object)90000L).appendText(" milliseconds");
                if (errorMessage != null) {
                    description.appendText("Error message: ").appendValue((Object)errorMessage);
                }
            }

            public boolean test() {
                return (Boolean)condition.get();
            }
        }, (long)90000L, (long)5000L);
    }

    public static void waitForIndexing(Supplier<Boolean> condition) {
        SearchTestHelper.waitForIndexing(condition, null);
    }

    private static int getCount(String pagedApiUrl) {
        Response response = SearchTestHelper.getCountResponse(pagedApiUrl);
        if (response.getStatusCode() == Response.Status.OK.getStatusCode()) {
            return response.getBody().jsonPath().getInt("size");
        }
        log.error("Could not get count from the search server. Status code: {}, body: {}", (Object)response.getStatusCode(), (Object)response.getBody().prettyPrint());
        return -1;
    }

    private static Response getCountResponse(String pagedApiUrl) {
        return (Response)RestAssured.given().queryParam("start", new Object[]{0}).queryParam("limit", new Object[]{100}).auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).contentType("application/json;charset=UTF-8").when().get(pagedApiUrl, new Object[0]);
    }

    private static String status(String restURL) {
        return ((Response)RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).contentType("application/json;charset=UTF-8").when().get(restURL + "/status", new Object[0])).jsonPath().getString("status");
    }

    private static void sync(String restURL) {
        RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).contentType("application/json;charset=UTF-8").when().post(restURL + "/sync", new Object[0]);
    }
}

