/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test;

import com.atlassian.bitbucket.internal.rest.admin.RestMeshNode;
import com.atlassian.bitbucket.test.DefaultFuncTestData;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.ws.rs.core.Response;
import net.sf.json.JSONObject;

public class MeshNodeTestHelper {
    private MeshNodeTestHelper() {
        throw new UnsupportedOperationException("Static utility class - not for instantiation");
    }

    @Nonnull
    public static RestMeshNode registerNode(@Nullable String id, @Nonnull String name, @Nonnull String rpcUrl, @Nonnull String secret) {
        return MeshNodeTestHelper.registerNode(MeshNodeTestHelper.createMeshNodeBody(id, name, rpcUrl, secret));
    }

    @Nonnull
    public static RestMeshNode registerNode(@Nonnull JSONObject meshNodeJson) {
        return (RestMeshNode)((Response)RestAssured.given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).body((Object)Objects.requireNonNull(meshNodeJson, "meshNodeJson")).contentType("application/json").expect().statusCode(Response.Status.OK.getStatusCode()).log().ifError().when().post(MeshNodeTestHelper.getMeshNodesRestUrl(), new Object[0])).as(RestMeshNode.class);
    }

    public static void unregisterNode(long id) {
        RestAssured.given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).expect().statusCode(Response.Status.OK.getStatusCode()).log().ifError().when().delete(MeshNodeTestHelper.getMeshNodeRestUrl(id), new Object[0]);
    }

    private static JSONObject createMeshNodeBody(String nodeId, String name, String rpcUrl, String secret) {
        JSONObject bodyObject = new JSONObject();
        if (nodeId != null) {
            bodyObject.put((Object)"id", (Object)nodeId);
        }
        bodyObject.put((Object)"name", (Object)name);
        bodyObject.put((Object)"rpcUrl", (Object)rpcUrl);
        bodyObject.put((Object)"secret", (Object)secret);
        return bodyObject;
    }

    private static String getMeshNodeRestUrl(long id) {
        return MeshNodeTestHelper.getMeshNodesRestUrl() + "/" + id;
    }

    private static String getMeshNodesRestUrl() {
        return DefaultFuncTestData.getRestUiURL() + "/admin/mesh/nodes";
    }
}

