/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test;

import com.atlassian.bitbucket.test.BitbucketTestLicense;
import com.atlassian.bitbucket.test.DefaultFuncTestData;
import com.atlassian.bitbucket.test.UserTestHelper;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import java.util.concurrent.Callable;
import javax.ws.rs.core.Response;
import net.sf.json.JSONObject;
import org.hamcrest.Matchers;
import org.junit.Assert;

public class LicenseTestHelper {
    public static final int DEFAULT_LICENSED_USER_COUNT = 2;
    public static final BitbucketTestLicense FORGED_LICENSE = BitbucketTestLicense.builder().whenNonClustered("AAABsQ0ODAoPeNp9UtuO2jAQfc9XjNQ3JIfA0ouQIhWS0CItBCVhq27bB2OGjUuwI3tCy983CUZi\nq6qvc2aOz8VvvuAeZrWB4D0ED9PJu+noA3xaFTAOxiMv0oq4oDU/YSiOWpT6bI/Ss8Rt\n6T9KgcpicamxX4jS1SrJouXs0S2suFSEiiuBye9amkvMCcPN6PONN2k3qnviHM0ZzTIO\n55PnBQvyZMmibP7MntL1W0eamheupOUktQpnVHFrJVcOjNEKI+seK9ASVFeNcNAGqETI\nkZoaFo0S0OEW9AHy7tQRbBojSm6xV9pFwIIHNpo4NDLYv/tv1OXxl9XBYLBOC7ZIM7bJ\n0ngbFct0zbZ50gJhT9gWsLv06hwDJEroPRqojf6JguBbSVR/nw6HL9rnN8u+0Keh88fw\nevHDh1iD0gR7acnIXUPYMksLpEE0lvQJjfVvdu7a3Ug0Bh3QDuUZQzINdvqjLJkVSczm\nXzvNd3U5vW1fW3VU+pfy/p/Qujnt0KSHrW1VhGM3Tc68aq59Hnhl0XOmntqlbjh+Lff6\naWqstTSaPr7K49YiN6TQ9Ma8P3RJ/mwwLAIUGcc4nBFZAOVxWb380E+GmTr1nqcCFDj7\nrd+Bf0D4bQfk9SjmJJn2+VthX02ko").build();
    public static final BitbucketTestLicense HUNDRED_USER_LICENSE = BitbucketTestLicense.builder().whenClustered("AAABow0ODAoPeNp1ksuO2jAUhvd5iiN1h+SQAC0tUhYziUsZlQSRsOht4YQDuE3syD5hytvXQzIXz\nagLb871+//jd2ut4K6rIZxCMFvMwsU0hOW6gEkwCby0a0o02WFn0dgoDAIv1opERaloMKpsVxpxR\npKeJWFP/ldZobJYXFq8FhQ8L1bp8m32KbPpTHUSFhNBGD2sZMGchVPvf5OGOP/bSnO5Nm3CSfDlE\nYuvhaxfcuVozmhWSXTL55zNku8T9iG7m7Pl9NPHActNETEqQhOR6dDLu9JWRrYkteojo9EozQr2O\nduyzTZLdnGxylK2y7lLRLFBh7GH8gJ0QhgAgatK79FAa/RvrAh+nIjan4vx+Kh9QbWwVgrlV7oZ1\n30Hw77jlw+JBqUJ9tKSkWVH6CZLC6Sh6izpxt3C95xSx6yEqt660QtzfsgzPkmIt/ym4Am7/faA/\ncKjAdmZtFN/lL5XXs7TyD323h08M0ehpBVXO24eyb2rbBd6fbgEn80r0BIM8uCgDRhX7AKNJCiNv\nnefCsjVSHX0+FnUXb/kIGqL3j8XnuGlMCsCEy+qBwzk4zefPyhmS1DIrx8BkmECFA1RqBGUyBFVw\n2F69boJZC+jQPlqX02k4").whenNonClustered("AAABpw0ODAoPeNp9kc1u2zAQhO98igV6M0BZUuqkMaBDIrGui1oyLDlA/w4UvbZYS6RAUk789mVsJ\nwUatAdeljs7O9++W2gFd72B6BbC62k0mcYTmC0qiMM4IvnQ1WiK7dqisUkUhiTVynHhct5hUrda7\nZrBWEes47YJvkiBymJ17PHUULGymuczshyMaLjFjDtM/OCQhlc0ism/+i919tRLczyJllEcfnoxZ\nwsu2/+6v04q0RzQzLPknt0w+j77FtPr4vMNnV3dfiDlUFthZO+kVokzA5LRaJQXFf1YrOhyVWTrt\nJoXOV2XzH8kqUG/ygbqI7gG4WIHTAm9QQO90b9QOPjeONf/mI7HOx1w13JrJVeB0N24PSsonhU/A\n8g0KO1gI60zsh4c+snSgtMgBut056kHxKdVDhVX4i2Rc3LPRB7wNUK6YncVy+j91+e1xV6LRh/sX\nr5w9TjWaq/0oyIlyxP/6MSftjA7rqTlJxzsiXd9i5DqrufqSE7h/cffJ7xkevCbPstikuEfphVaB\n5cO2GoD20EJcL5qCTvwdjh7bXlrkfwGP7fbwDAtAhR+QdWNBnh1uLorI9T5KGrRdOPTFAIVAIFCD\ngnNasGeByLC++aVF0KH0B7hX02kc").build();
    public static final BitbucketTestLicense SINGLE_USER_LICENSE = BitbucketTestLicense.builder().whenClustered("AAABtQ0ODAoPeNqVUk2P2jAQvftXjNQbkkOgbNlFitQu8VKqkiASVurXwZiBuCR25A9a/n0NZLfa\nVj1Usi+eeW/ee+NXZeVhwQ0MbiEeTUY3k8EYZosShvFwQDLfbNDku7VFY5MBmWrluHAZ\nbzDZYOWbtjJ4sm+5q7m1kqtI6IZYx20VfZQClcXy1OKlv2RFOc9mZOmNqLjFlDtMwpSY\nxnfhkH/1d+/sZyvN6QJaDobx+yctbMFl/T9inokLNEc08zS5Z2NGR+nnIX2TfxjT2eu7\n2w4WxvEpKocmccYjKfzGCiNbJ7W6vvR6vSwv6UO+ostVnq6n5TzP6LpgoZBMDQa9W9ic\nwFUInQhgSugtGmiN/o7CwZfKufbrpN/f6+iF+H59RVC8Ir5FkGpQ2sFWWmfkxjsMzNKC\n0yC8dboJe4pIiCRoVlyJv2O7GgvBySM+W5iu2LuSpfT+01m2OGhR6aM9yKfwQ0hrdVD6\nhyIFy5Jw6U0ck9zsuZKWX+IozsTw4JWAEq2z5OI+VP5cdGfqMUg944Ykxd+hFlLtawQf\nPhx0jbDTBlygDCXCjrz214E7XlskvwBnRvERMCwCFCXAUPqCPId2904NUPU7jcMHp5d0\nAhRF83ciuAHMukX2kwZwbcKJFAfl2g==X02l1").whenNonClustered("AAABqw0ODAoPeNqVUstu2zAQvPMrFujNAGVZTZrEgIA2FuO6qCXDkgP0daDotcVaIgU+3PrvSz+S\nIi16KEBeuDuzM7N8VTUe5tzA6Bbiq/F1PE5imM4rSOJkRHLf1WiKzcqisemITLRyXLic\nd5jW2Piubwwe7FvuWm6t5CoSuiPWcdtEH6VAZbE69Hjqr1hZzfIpWXgjGm4x4w7TMCWm\n8V045F/9l3f2s5fmcAItRkn8/kkLm3PZ/o+YZ+ISzR7NLEvv2Q2jV9nnhL4pPtzQ6eu7\nW1L62gojeye1Sp3xSAaDQV5U9KFY0sWyyFaTalbkdFWyUEgnBoOyNdQHcA3CZRwwJfQa\nDfRGf0fh4EvjXP91PBxudfRC5rA9IyieEd8iyDQo7WAtrTOy9g4Ds7TgNAhvne7CRiIS\nzCuHiivxd0Bn5yEiucdnC5Mle1exjN5/OsoWOy0avbc7+RRziGOldkr/UKRkeRouvY5j\nUpgtV9LyUxzlkRgevBJQoXWWnNyHyp8rvZh6DFKPuIRk+DvUUqpti+DD14JLI2y0ARco\nQ4mwPW/9eeCGtxbJLwLr6NQwLQIUCIplPuPB4PD49q0cS7xV0zs0Fy4CFQCTiqbNn+v9\nDku+yFK0MmFqByE7Mg==X02kk").build();

    public static JSONObject createLicenseBody(String license) {
        JSONObject body = new JSONObject();
        body.put((Object)"license", (Object)license);
        return body;
    }

    public static <T> T doWithLicense(Callable<T> runnable) throws Exception {
        String original = LicenseTestHelper.getLicense();
        try {
            T t = runnable.call();
            return t;
        }
        finally {
            LicenseTestHelper.setLicense(original);
        }
    }

    public static String getLicense() {
        return LicenseTestHelper.getLicenseJson().getString("license");
    }

    public static JsonPath getLicenseJson() {
        return ((Response)RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).when().get(LicenseTestHelper.getLicenseURL(), new Object[0])).getBody().jsonPath();
    }

    public static void ensureLicensedUserCount(int expected) {
        int actual;
        long timeout = System.currentTimeMillis() + 10000L;
        do {
            if ((actual = LicenseTestHelper.getLicensedUserCount()) != expected) continue;
            return;
        } while (timeout > System.currentTimeMillis());
        Assert.assertEquals((String)("License count should match (users=" + UserTestHelper.allUsernames() + ")"), (long)expected, (long)actual);
    }

    public static int getLicensedUserCount() {
        return LicenseTestHelper.getLicenseJson().getInt("status.currentNumberOfUsers");
    }

    public static void setLicense(String license) {
        RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).body("license", Matchers.equalTo((Object)license), new Object[0]).log().ifError().given().auth().preemptive().basic(DefaultFuncTestData.getAdminUser(), DefaultFuncTestData.getAdminPassword()).when().body((Object)LicenseTestHelper.createLicenseBody(license)).contentType(ContentType.JSON).post(LicenseTestHelper.getLicenseURL(), new Object[0]);
    }

    public static String getLicenseURL() {
        return DefaultFuncTestData.getRestURL() + "/admin/license";
    }
}

