/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.test;

import com.atlassian.bitbucket.internal.scm.git.lfs.rest.lock.RestLfsLock;
import com.atlassian.bitbucket.internal.scm.git.lfs.rest.lock.RestLfsLockPage;
import com.atlassian.bitbucket.internal.scm.git.lfs.rest.lock.RestLfsLockPageForVerification;
import com.atlassian.bitbucket.rest.RestErrors;
import com.atlassian.bitbucket.rest.RestMapEntity;
import com.atlassian.bitbucket.test.DefaultFuncTestData;
import com.google.common.collect.Lists;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ResponseBody;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.junit.rules.ExternalResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitLfsTestRule
extends ExternalResource
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(GitLfsTestRule.class);
    private static final String CONTENT_TYPE = "application/vnd.git-lfs+json; charset=utf-8";
    private final Set<CreatedLock> locks = new HashSet<CreatedLock>();

    public void after() {
        this.cleanupLocks();
    }

    @Override
    public void close() {
        this.after();
    }

    public void forceUnlock(int id, String projectKey, String repoSlug) {
        this.unlockAsUser(this.getAdminUser(), this.getAdminPassword(), id, true, projectKey, repoSlug, 200);
    }

    public RestMapEntity forceUnlockAsUser(String user, String password, int id, String projectKey, String repoSlug, int expectedStatusCode) {
        return this.unlockAsUser(user, password, id, true, projectKey, repoSlug, expectedStatusCode);
    }

    public RestMapEntity listLocks(String projectKey, String repoSlug, int expectedStatusCode) {
        return this.listLocks(this.getLockUrl(projectKey, repoSlug), expectedStatusCode);
    }

    public RestMapEntity listLocksAsUser(String user, String password, String projectKey, String repoSlug, int expectedStatusCode) {
        return this.listLocksAsUser(user, password, this.getLockUrl(projectKey, repoSlug), expectedStatusCode);
    }

    public RestMapEntity listLocksById(String projectKey, String repoSlug, int lockId, int expectedStatusCode) {
        return this.listLocks(this.getLockUrl(projectKey, repoSlug) + "?id=" + lockId, expectedStatusCode);
    }

    public RestMapEntity listLocksByRepoAndPath(String projectKey, String repoSlug, String path, int expectedStatusCode) {
        return this.listLocks(this.getLockUrl(projectKey, repoSlug) + "?path=" + path, expectedStatusCode);
    }

    public RestMapEntity listLocksWithLimit(String projectKey, String repoSlug, int limit, int expectedStatusCode) {
        return this.listLocks(this.getLockUrl(projectKey, repoSlug) + "?limit=" + limit, expectedStatusCode);
    }

    public RestMapEntity listLocksWithLimitAndCursor(String projectKey, String repoSlug, int limit, int cursor, int expectedStatusCode) {
        return this.listLocks(this.getLockUrl(projectKey, repoSlug) + "?limit=" + limit + "&cursor=" + cursor, expectedStatusCode);
    }

    public RestMapEntity listLocksWithToken(String token, String sshLockUrl, int expectedStatusCode) {
        ResponseBody responseBody = ((Response)RestAssured.expect().statusCode(expectedStatusCode).log().ifError().given().header("Authorization", (Object)token, new Object[0]).accept(CONTENT_TYPE).contentType(CONTENT_TYPE).when().get(sshLockUrl, new Object[0])).getBody();
        if (!this.isSuccess(expectedStatusCode)) {
            return (RestMapEntity)responseBody.as(RestErrors.class);
        }
        return (RestMapEntity)responseBody.as(RestLfsLockPage.class);
    }

    public RestMapEntity lock(String path, String file, String projectKey, String repoSlug, int expectedStatusCode) {
        return this.lockAsUser(this.getAdminUser(), this.getAdminPassword(), path, file, projectKey, repoSlug, expectedStatusCode);
    }

    public RestMapEntity lockAsUser(String user, String password, String path, String file, String projectKey, String repoSlug, int expectedStatusCode) {
        String pathAndFile = StringUtils.isEmpty((CharSequence)path) ? file : path + "/" + file;
        String body = String.format("{\"path\":\"%s\",\"ref\":{\"name\":\"refs/heads/master\"}}", pathAndFile);
        ResponseBody responseBody = ((Response)RestAssured.expect().statusCode(expectedStatusCode).log().ifError().given().auth().preemptive().basic(user, password).body(body).accept(CONTENT_TYPE).contentType(CONTENT_TYPE).when().post(this.getLockUrl(projectKey, repoSlug), new Object[0])).getBody();
        if (!this.isSuccess(expectedStatusCode)) {
            return (RestMapEntity)responseBody.as(RestErrors.class);
        }
        RestLfsLock lock = RestLfsLock.valueOf((Object)responseBody.path("lock", new String[0]));
        this.locks.add(new CreatedLock(lock.getId(), projectKey, repoSlug));
        return lock;
    }

    public RestMapEntity lockWithToken(String token, String sshLockUrl, String path, String file, String projectKey, String repoSlug, int expectedStatusCode) {
        String pathAndFile = path + "/" + file;
        String body = String.format("{\"path\":\"%s\",\"ref\":{\"name\":\"refs/heads/master\"}}", pathAndFile);
        ResponseBody responseBody = ((Response)RestAssured.expect().statusCode(expectedStatusCode).log().ifError().given().header("Authorization", (Object)token, new Object[0]).body(body).accept(CONTENT_TYPE).contentType(CONTENT_TYPE).when().post(sshLockUrl, new Object[0])).getBody();
        if (!this.isSuccess(expectedStatusCode)) {
            return (RestMapEntity)responseBody.as(RestErrors.class);
        }
        RestLfsLock lock = RestLfsLock.valueOf((Object)responseBody.path("lock", new String[0]));
        this.locks.add(new CreatedLock(lock.getId(), projectKey, repoSlug));
        return lock;
    }

    public RestMapEntity unlock(int id, String projectKey, String repoSlug, int expectedStatusCode) {
        return this.unlockAsUser(this.getAdminUser(), this.getAdminPassword(), id, false, projectKey, repoSlug, expectedStatusCode);
    }

    public RestMapEntity unlockAsUser(String user, String password, int id, boolean force, String projectKey, String repoSlug, int expectedStatusCode) {
        String body = String.format("{\"force\":%s,\"ref\":{\"name\":\"refs/heads/master\"}}", force);
        ResponseBody responseBody = ((Response)RestAssured.expect().statusCode(expectedStatusCode).log().ifError().given().auth().preemptive().basic(user, password).body(body).accept(CONTENT_TYPE).contentType(CONTENT_TYPE).when().post(this.getLockUrl(projectKey, repoSlug) + "/" + id + "/unlock", new Object[0])).getBody();
        if (!this.isSuccess(expectedStatusCode)) {
            return (RestMapEntity)responseBody.as(RestErrors.class);
        }
        return RestLfsLock.valueOf((Object)responseBody.path("lock", new String[0]));
    }

    public RestMapEntity unlockWithToken(String token, String sshLockUrl, int id, boolean force, int expectedStatusCode) {
        String body = String.format("{\"force\":%s,\"ref\":{\"name\":\"refs/heads/master\"}}", force);
        ResponseBody responseBody = ((Response)RestAssured.expect().statusCode(expectedStatusCode).log().ifError().given().header("Authorization", (Object)token, new Object[0]).body(body).accept(CONTENT_TYPE).contentType(CONTENT_TYPE).when().post(sshLockUrl + "/" + id + "/unlock", new Object[0])).getBody();
        if (!this.isSuccess(expectedStatusCode)) {
            return (RestMapEntity)responseBody.as(RestErrors.class);
        }
        return RestLfsLock.valueOf((Object)responseBody.path("lock", new String[0]));
    }

    public RestMapEntity verifyLocksAsUser(String user, String password, String projectKey, String repoSlug, int expectedStatusCode) {
        ResponseBody responseBody = ((Response)RestAssured.expect().statusCode(expectedStatusCode).log().ifError().given().auth().preemptive().basic(user, password).accept(CONTENT_TYPE).contentType(CONTENT_TYPE).body("{}").when().post(this.getLockUrl(projectKey, repoSlug) + "/verify", new Object[0])).getBody();
        if (!this.isSuccess(expectedStatusCode)) {
            return (RestMapEntity)responseBody.as(RestErrors.class);
        }
        return (RestMapEntity)responseBody.as(RestLfsLockPageForVerification.class);
    }

    public RestMapEntity verifyLocksWithLimit(String user, String password, String projectKey, String repoSlug, int limit, int expectedStatusCode) {
        return this.verifyLocksWithLimitAndCursor(user, password, projectKey, repoSlug, limit, -1, expectedStatusCode);
    }

    public RestMapEntity verifyLocksWithLimitAndCursor(String user, String password, String projectKey, String repoSlug, int limit, int cursor, int expectedStatusCode) {
        StringBuilder body = new StringBuilder().append("{\"limit\": ").append(limit);
        if (cursor > 0) {
            body.append(", \"cursor\": ").append(cursor);
        }
        body.append("}");
        ResponseBody responseBody = ((Response)RestAssured.expect().statusCode(expectedStatusCode).log().ifError().given().auth().preemptive().basic(user, password).accept(CONTENT_TYPE).contentType(CONTENT_TYPE).body(body.toString()).when().post(this.getLockUrl(projectKey, repoSlug) + "/verify", new Object[0])).getBody();
        if (!this.isSuccess(expectedStatusCode)) {
            return (RestMapEntity)responseBody.as(RestErrors.class);
        }
        return (RestMapEntity)responseBody.as(RestLfsLockPageForVerification.class);
    }

    public RestMapEntity verifyLocksWithToken(String token, String sshLockUrl, int expectedStatusCode) {
        ResponseBody responseBody = ((Response)RestAssured.expect().statusCode(expectedStatusCode).log().ifError().given().header("Authorization", (Object)token, new Object[0]).accept(CONTENT_TYPE).contentType(CONTENT_TYPE).body("{}").when().post(sshLockUrl + "/verify", new Object[0])).getBody();
        if (!this.isSuccess(expectedStatusCode)) {
            return (RestMapEntity)responseBody.as(RestErrors.class);
        }
        return (RestMapEntity)responseBody.as(RestLfsLockPageForVerification.class);
    }

    public static List<RestLfsLock> getLockListFromResponse(RestMapEntity response) {
        return Lists.transform((List)((List)response.get((Object)"locks")), RestLfsLock::valueOf);
    }

    public static List<RestLfsLock> getOurLockListFromResponse(RestMapEntity response) {
        return Lists.transform((List)((List)response.get((Object)"ours")), RestLfsLock::valueOf);
    }

    public static List<RestLfsLock> getTheirLockListFromResponse(RestMapEntity response) {
        return Lists.transform((List)((List)response.get((Object)"theirs")), RestLfsLock::valueOf);
    }

    protected String getAdminUser() {
        return DefaultFuncTestData.getAdminUser();
    }

    protected String getAdminPassword() {
        return DefaultFuncTestData.getAdminPassword();
    }

    protected String getLockUrl(String projectKey, String repoSlug) {
        return DefaultFuncTestData.getBaseURL() + "/scm/" + projectKey + "/" + repoSlug + ".git/info/lfs/locks";
    }

    private boolean isSuccess(int expectedStatusCode) {
        Response.Status expectedStatus = Response.Status.fromStatusCode((int)expectedStatusCode);
        return expectedStatus != null && expectedStatus.getFamily() == Response.Status.Family.SUCCESSFUL;
    }

    private RestMapEntity listLocks(String url, int expectedStatusCode) {
        return this.listLocksAsUser(this.getAdminUser(), this.getAdminPassword(), url, expectedStatusCode);
    }

    private RestMapEntity listLocksAsUser(String user, String password, String url, int expectedStatusCode) {
        ResponseBody responseBody = ((Response)RestAssured.expect().statusCode(expectedStatusCode).log().ifError().given().auth().preemptive().basic(user, password).accept(CONTENT_TYPE).contentType(CONTENT_TYPE).when().get(url, new Object[0])).getBody();
        if (this.isSuccess(expectedStatusCode)) {
            return (RestMapEntity)responseBody.as(RestErrors.class);
        }
        return (RestMapEntity)responseBody.as(RestLfsLockPage.class);
    }

    private void cleanupLocks() {
        for (CreatedLock lock : this.locks) {
            try {
                lock.unlock();
            }
            catch (Throwable t) {
                log.error("Failed to clean up lock " + lock, t);
            }
        }
        this.locks.clear();
    }

    private class CreatedLock {
        public final Integer id;
        public final String projectKey;
        public final String repoSlug;

        CreatedLock(Integer id, String projectKey, String repoSlug) {
            this.id = id;
            this.projectKey = projectKey;
            this.repoSlug = repoSlug;
        }

        void unlock() {
            GitLfsTestRule.this.unlockAsUser(GitLfsTestRule.this.getAdminUser(), GitLfsTestRule.this.getAdminPassword(), this.id, true, this.projectKey, this.repoSlug, 200);
        }

        public String toString() {
            return "{projectKey: " + this.projectKey + ", repoSlug:" + this.repoSlug + ", id: " + this.id + "}";
        }
    }
}

